set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1111402',
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.184251,
      NULL,
      NULL,
      NULL,
      ' 3-24-1981',
      49,
      NULL,
      2,
      NULL,
      1.759892,
      ' 6-16-1979',
      NULL,
      1,
      NULL,
      99.406935,
      3,
      NULL,
      NULL,
      NULL,
      0.393253,
      0.192213,
      2,
      3.720368,
      1,
      0,
      6,
      0,
      0,
      36,
      3,
      3.806890,
      1.121894,
      0,
      23,
      4,
      14,
      4,
      NULL,
      2,
      0,
      0,
      NULL,
      1.629570,
      0.703936,
      1,
      1,
      1.466434,
      1,
      1,
      21,
      3,
      5,
      4,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      4,
      0,
      2,
      1,
      0,
      1.188963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.076146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.659086,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      2,
      4,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      4,
      NULL,
      5,
      1,
      0,
      3,
      2,
      1,
      0,
      1,
      1.908791,
      1.337391,
      ' 8-26-1988',
      466.591100,
      ' 0-20-1988',
      240.453493,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0.744743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730107,
      0,
      NULL,
      0,
      1.551522,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565156,
      0,
      0.616925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.333793,
      1.516681,
      NULL,
      NULL,
      1.191108,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839137,
      1.995284,
      2,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      3,
      2,
      3,
      0,
      3,
      0.129062,
      1,
      1,
      1,
      1.844758,
      NULL,
      0.710739,
      0,
      1.839011,
      1.148577,
      1.430341,
      0.901357,
      1,
      NULL,
      2.448748,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34333',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.072826,
      18.288934,
      NULL,
      NULL,
      3.679235,
      18,
      3.850127,
      2.285095,
      1,
      2.832225,
      0.728839,
      NULL,
      0.520105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.341041,
      1.066021,
      NULL,
      1.417590,
      NULL,
      NULL,
      0.779696,
      NULL,
      NULL,
      1.113039,
      2,
      1.819678,
      1.388301,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.615475,
      5.707907,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.387943,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.064089,
      NULL,
      1,
      1,
      1.841887,
      3,
      1.915519,
      0.759657,
      0,
      1,
      1.426883,
      0,
      0.666386,
      1.465251,
      1.847620,
      1.329068,
      0.242751,
      NULL,
      NULL,
      1.375339,
      NULL,
      NULL,
      1.384842,
      NULL,
      NULL,
      9.329434,
      0.193656,
      5.540199,
      NULL,
      1.358008,
      NULL,
      NULL,
      NULL,
      1.345779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.102862,
      0,
      1.355100,
      1.180571,
      NULL,
      NULL,
      0.763507,
      NULL,
      NULL,
      NULL,
      1.946649,
      0.030848,
      0.525840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.344171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.132486,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.082494,
      2.819093,
      0.315650,
      0,
      NULL,
      NULL,
      1.457059,
      NULL,
      NULL,
      1.791268,
      0,
      2,
      3,
      NULL,
      1,
      5.260404,
      0,
      1.626128,
      0.941370,
      0.073486,
      3.139266,
      0.210953,
      NULL,
      NULL,
      2.001890,
      1,
      3.448166,
      2,
      0,
      1.570033,
      2,
      0.487755,
      5.537561,
      NULL,
      NULL,
      0.166881,
      2.408012,
      0,
      0,
      NULL,
      1.774185,
      2.650640,
      1.827307,
      0.696957,
      3,
      5.070274,
      NULL,
      NULL,
      25.103613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.312481,
      NULL,
      NULL,
      15.544273,
      NULL,
      NULL,
      0,
      NULL,
      1.591397,
      3.349807,
      NULL,
      0,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102069,
      NULL,
      NULL,
      NULL,
      1.075996,
      NULL,
      NULL,
      2.389739,
      NULL,
      0.577202,
      9,
      NULL,
      0.319142,
      0.395041,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.217161,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      1.534702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.207181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.442304,
      NULL,
      0.602134,
      NULL,
      NULL,
      NULL,
      0.661142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.480067,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.559644,
      NULL,
      0.859286,
      NULL,
      1.647013,
      NULL,
      3.212720,
      NULL,
      1.465935,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.159416,
      NULL,
      7,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.918494,
      42,
      42.506802,
      1,
      NULL,
      NULL,
      1.410860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848017,
      NULL,
      NULL,
      0,
      0,
      0,
      0.911109,
      0.651874,
      NULL,
      1.099393,
      0,
      0.617674,
      1.828804,
      0.487032,
      1.347418,
      0.073380,
      0,
      1.187780,
      1.764244,
      1,
      1.915904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548815,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891263,
      0.705273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950859,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.458729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787497,
      2.589075,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.576186,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.845966,
      NULL,
      2,
      NULL,
      11.901113,
      3.267598,
      1,
      0,
      0,
      1.048188,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.874105,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.659688,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.259382,
      0.561093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081906,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.219601,
      NULL,
      NULL,
      62,
      8.533753,
      2,
      NULL,
      1.928300,
      '22300',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


