set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0243110',
      1.309822,
      1,
      1,
      NULL,
      '0013',
      0,
      0.111275,
      NULL,
      NULL,
      ' 6-23-1997',
      38.001620,
      NULL,
      1,
      NULL,
      1,
      ' 4-15-1976',
      11.366261,
      NULL,
      151,
      112.273637,
      3,
      ' 1- 0-1999',
      '10- 4-1975',
      ' 6-11-1989',
      2,
      1.114623,
      2.328517,
      0,
      1,
      0.721073,
      8,
      NULL,
      1.701247,
      115.351969,
      1,
      4.475540,
      NULL,
      10.352555,
      22,
      3,
      NULL,
      5,
      NULL,
      7,
      3.220096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      0.136163,
      1,
      5,
      1,
      1,
      1,
      3,
      NULL,
      4,
      5,
      2,
      0,
      4,
      5.663747,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.883024,
      NULL,
      NULL,
      0,
      1,
      0,
      2.411409,
      0,
      NULL,
      3.548661,
      NULL,
      1.157913,
      1,
      1.106151,
      2.738225,
      1.004561,
      3,
      1.025282,
      3.201057,
      2,
      0.307373,
      1.813984,
      2,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      2,
      4,
      1,
      NULL,
      5,
      NULL,
      1,
      1,
      7,
      0,
      NULL,
      1,
      1,
      1.231054,
      NULL,
      1.802790,
      0,
      1,
      NULL,
      2,
      5,
      0,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      4,
      0,
      4,
      1,
      1,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      1.312905,
      ' 6- 2-1986',
      263,
      ' 2- 5-1987',
      343,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      0.863365,
      1.306289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.031049,
      NULL,
      1,
      0.937216,
      NULL,
      1,
      1.208792,
      1,
      31.703691,
      2,
      0.153174,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      3,
      0.444356,
      NULL,
      NULL,
      NULL,
      0.535162,
      NULL,
      NULL,
      1.468385,
      1.295038,
      NULL,
      0.388339,
      1.071027,
      1.055330,
      1.999180,
      1.432729,
      0,
      1.040206,
      0.771110,
      0.105969,
      4.583003,
      1.833284,
      4,
      9,
      6,
      0.044881,
      2.437635,
      NULL,
      1.869173,
      0.103347,
      1,
      0,
      28.624399,
      NULL,
      3,
      NULL,
      48,
      58,
      26.563974,
      5,
      2,
      2.227512,
      '20003',
      '',
      '',
      1.545333,
      '',
      '',
      '',
      0.474213,
      '',
      '',
      '',
      1,
      2,
      8,
      10,
      3,
      NULL,
      6,
      13.253599,
      NULL,
      0.091295,
      2.295363,
      2,
      16.309111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.265359,
      2,
      NULL,
      1.184564,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.038770,
      1,
      1,
      0.918190,
      NULL,
      1.905416,
      0.207590,
      2.080716,
      1,
      NULL,
      3,
      2,
      0.742977,
      2,
      0.970670,
      0.410513,
      2.941211,
      4,
      NULL,
      0.302446,
      3,
      1.895354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.656578,
      0.681766,
      0.334412,
      NULL,
      NULL,
      NULL,
      0.065997,
      NULL,
      2.570834,
      1.842687,
      1,
      1,
      NULL,
      NULL,
      0.593095,
      0,
      1,
      2,
      1,
      NULL,
      0.389431,
      NULL,
      1.190290,
      1.835036,
      0,
      NULL,
      NULL,
      1.649744,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.216886,
      2.465696,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.020801,
      NULL,
      NULL,
      NULL,
      0.592617,
      NULL,
      NULL,
      2.803179,
      NULL,
      NULL,
      1.604393,
      NULL,
      3.048419,
      1,
      NULL,
      NULL,
      2.705690,
      0,
      5.556191,
      NULL,
      0.670750,
      0.226604,
      3.818674,
      0,
      1,
      4,
      1.453959,
      3.853585,
      1.310066,
      NULL,
      NULL,
      0.311015,
      NULL,
      NULL,
      0.093476,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.179866,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.969533,
      3.175809,
      4,
      0.963939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.680457,
      2.462089,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.000352,
      1,
      1,
      NULL,
      1.300488,
      6.055806,
      3,
      2,
      3,
      12.774112,
      NULL,
      NULL,
      2.462595,
      2.278559,
      2,
      1.463945,
      3,
      0.428056,
      1.537188,
      2.959157,
      7.423774,
      2.059606,
      2,
      2.776210,
      3,
      2,
      4,
      2,
      NULL,
      1.431519,
      0.826406,
      1.709562,
      1,
      4,
      NULL,
      2.824790,
      55,
      NULL,
      15.686500,
      1.582602,
      NULL,
      1.898452,
      1.511457,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.419712,
      2.076269,
      NULL,
      0.949695,
      8.502722,
      NULL,
      NULL,
      1,
      NULL,
      0.398276,
      1.740485,
      NULL,
      NULL,
      7.830012,
      NULL,
      1,
      0,
      NULL,
      0.636625,
      NULL,
      NULL,
      7.194365,
      0,
      NULL,
      2.524403,
      0,
      1.540859,
      1,
      0,
      3.248958,
      0,
      1.649434,
      NULL,
      0.652178,
      NULL,
      44,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.606851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540387,
      NULL,
      1.839298,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.257567,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.857427,
      NULL,
      0.826366,
      NULL,
      2,
      NULL,
      0.702145,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.105608,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      56.377504,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.795577,
      0,
      NULL,
      NULL,
      11,
      0.989238,
      11.014189,
      1,
      1,
      NULL,
      1.553498,
      258,
      NULL,
      NULL,
      0,
      0.674507,
      1,
      1.604868,
      1,
      0.789302,
      NULL,
      0.578343,
      1.678473,
      NULL,
      0,
      NULL,
      0.369412,
      NULL,
      0,
      0.734981,
      0.587198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.635808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203867,
      1.906904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.283785,
      NULL,
      1.837138,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.442862,
      1.295374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      3,
      10,
      NULL,
      NULL,
      1,
      NULL,
      0.365623,
      NULL,
      0.839404,
      2.730785,
      NULL,
      0,
      3.419079,
      NULL,
      1,
      1.699452,
      NULL,
      0.422368,
      0.750733,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.211878,
      1,
      NULL,
      1.097630,
      2,
      NULL,
      1.120359,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831146,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0,
      0,
      0,
      0.680999,
      0,
      67.215179,
      2,
      1,
      4,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      1.279663,
      NULL,
      '',
      NULL);
commit;
end;
/


