set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9434890';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '21',
      NULL,
      NULL,
      '2102443',
      2.311417,
      0.714096,
      2,
      3,
      '3222',
      5.341657,
      1.799073,
      NULL,
      NULL,
      ' 6-17-1999',
      22.232865,
      49,
      NULL,
      1,
      1,
      ' 0-12-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4- 7-1979',
      NULL,
      ' 0- 2-1991',
      2.931708,
      NULL,
      2,
      0,
      1.806714,
      3,
      2,
      0.534156,
      1.948724,
      7,
      5,
      17.213290,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.243365,
      0,
      2,
      0.824969,
      1,
      1.727820,
      NULL,
      0,
      0,
      0.903795,
      0.054552,
      3,
      NULL,
      0,
      1.939863,
      3,
      4,
      4,
      3,
      0,
      NULL,
      0,
      1,
      5,
      0,
      0,
      1,
      6.107183,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      7.600193,
      2.917998,
      NULL,
      0.531303,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.595087,
      0,
      NULL,
      0.195401,
      3.030932,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      0,
      1.882279,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.798690,
      NULL,
      0.719817,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      0,
      1,
      1,
      2,
      0,
      3,
      1,
      2,
      5,
      NULL,
      4,
      1,
      4,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.233178,
      ' 8- 9-1976',
      36,
      ' 7-16-1994',
      NULL,
      1.025640,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980021,
      1.175785,
      1.343154,
      0.883800,
      6.168782,
      1,
      0.291953,
      0,
      0,
      NULL,
      0,
      1.140016,
      0.921635,
      3,
      0.126551,
      NULL,
      1,
      NULL,
      NULL,
      2.208006,
      1,
      0.106338,
      0.169505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.184580,
      0,
      4.560098,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      2,
      0,
      3,
      0,
      3,
      0,
      5,
      3.456475,
      NULL,
      1.411087,
      0,
      NULL,
      2,
      0.234507,
      0.468140,
      1,
      0,
      1.357060,
      0,
      NULL,
      1.079624,
      0,
      0.571052,
      NULL,
      1,
      NULL,
      11,
      2.629060,
      6.146585,
      9.729502,
      5,
      NULL,
      1,
      0,
      1.559929,
      3,
      2,
      27.844069,
      1,
      1,
      29,
      NULL,
      NULL,
      0.420304,
      2,
      NULL,
      0,
      '41203',
      '22143',
      NULL,
      0.074741,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      36,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.673720,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.392360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.422650,
      NULL,
      0.057394,
      80.175950,
      5040,
      NULL,
      0.867735,
      0.366224,
      1,
      1,
      1.184984,
      NULL,
      1,
      1,
      0,
      3,
      1,
      1,
      0,
      1,
      1.075157,
      3,
      0.177767,
      0,
      NULL,
      0.942690,
      NULL,
      0.798254,
      NULL,
      2,
      NULL,
      2,
      NULL,
      69.236950,
      NULL,
      0,
      NULL,
      18.809379,
      NULL,
      NULL,
      0.812734,
      NULL,
      0.931160,
      NULL,
      NULL,
      NULL,
      1.644240,
      NULL,
      1.325663,
      NULL,
      1,
      NULL,
      0.756936,
      NULL,
      3.801064,
      NULL,
      1.013008,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.147808,
      NULL,
      0.390202,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      0.477275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464915,
      NULL,
      1.258649,
      NULL,
      0.700131,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.491488,
      1,
      NULL,
      0.851601,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580910,
      NULL,
      0.960044,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.844842,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.945213,
      0.299110,
      NULL,
      NULL,
      NULL,
      104.219051,
      NULL,
      2.755520,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1.341948,
      24.061457,
      NULL,
      3.866278,
      NULL,
      3,
      0.384236,
      1,
      0,
      NULL,
      2.460653,
      1.777727,
      5,
      3,
      0,
      15,
      0.312505,
      1,
      NULL,
      1,
      1,
      NULL,
      1.742099,
      1.791179,
      NULL,
      0.520314,
      1.491119,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.932299,
      NULL,
      0.129191,
      2,
      NULL,
      1.519226,
      NULL,
      NULL,
      0.079342,
      1.142428,
      NULL,
      3.216148,
      2,
      NULL,
      1.141014,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936763,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      4,
      NULL,
      0,
      3,
      0,
      32.376016,
      NULL,
      0,
      4.874334,
      4,
      '31041',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


