set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3313432',
      NULL,
      1.456476,
      NULL,
      NULL,
      '2432',
      1.269681,
      0.929385,
      NULL,
      NULL,
      ' 9-15-1996',
      46.424235,
      NULL,
      4,
      NULL,
      0.859485,
      ' 8-11-1991',
      26.958390,
      2,
      243,
      7.854585,
      2,
      '10-28-1985',
      NULL,
      ' 4-18-1995',
      3.586279,
      1,
      NULL,
      NULL,
      0.214920,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.928799,
      NULL,
      14.839214,
      0,
      22.017835,
      3,
      4,
      7,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.472263,
      NULL,
      3,
      0,
      NULL,
      3,
      0,
      1,
      5,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      0,
      4,
      0,
      NULL,
      1,
      1,
      0.575501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      2.627533,
      NULL,
      0.060802,
      1.124000,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      8.777308,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.868003,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.213899,
      0,
      0,
      1,
      NULL,
      1.532929,
      NULL,
      1.543499,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      2,
      4,
      4,
      1,
      0,
      1,
      0,
      ' 5-17-1986',
      1.802032,
      NULL,
      316.370487,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      3.560414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121714,
      NULL,
      NULL,
      1.555599,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.247443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268641,
      1.291049,
      1.455459,
      0.815970,
      0,
      0.271753,
      1,
      NULL,
      1,
      0.359599,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      2,
      0,
      2,
      0,
      3,
      3,
      NULL,
      3,
      0,
      1.352422,
      0,
      1.634532,
      1,
      1.369828,
      NULL,
      0.668911,
      1,
      NULL,
      0.939600,
      0.476522,
      NULL,
      0.935141,
      0,
      0.258492,
      0,
      3,
      1.531704,
      1.226407,
      8.383952,
      NULL,
      7.745778,
      0.557145,
      NULL,
      2,
      2,
      NULL,
      2,
      3.319820,
      1,
      1,
      17.089635,
      0,
      1.029584,
      NULL,
      NULL,
      30,
      41.808169,
      4,
      1,
      0,
      '04332',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.328976,
      9.285898,
      NULL,
      16,
      3,
      17.089528,
      1,
      3.510645,
      0,
      3,
      3.519384,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831161,
      NULL,
      NULL,
      1,
      3,
      1,
      1.496222,
      NULL,
      NULL,
      0.852911,
      NULL,
      0.673197,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.284149,
      3.137614,
      1,
      1,
      NULL,
      NULL,
      1.555820,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.029701,
      5,
      4.288232,
      0,
      1.528116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673070,
      1,
      2.088583,
      0,
      NULL,
      NULL,
      1.431774,
      2.031461,
      0.943944,
      1,
      0.410337,
      1,
      2,
      1,
      0.783781,
      2,
      2.090295,
      NULL,
      3,
      3.778539,
      3,
      1,
      0,
      3.146950,
      1,
      2.379627,
      NULL,
      0,
      1.230456,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.526819,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196089,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.263157,
      NULL,
      NULL,
      2,
      2.051983,
      1.890742,
      1.065528,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.738056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.338513,
      NULL,
      NULL,
      0.629569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.214547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.017690,
      NULL,
      NULL,
      1.694190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598131,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      1.757728,
      0.362027,
      NULL,
      NULL,
      1.962864,
      5,
      0.381799,
      0.639761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.417591,
      0.473718,
      3.921537,
      2,
      NULL,
      1.095073,
      1,
      2,
      1,
      2.432485,
      0.217182,
      0.291400,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.774498,
      0.183963,
      1.382359,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841187,
      NULL,
      NULL,
      0.462004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.301581,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.134394,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.566789,
      0,
      2,
      0.050517,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572767,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.353386,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.628823,
      NULL,
      NULL,
      NULL,
      0.724066,
      NULL,
      NULL,
      NULL,
      1.111527,
      NULL,
      NULL,
      NULL,
      1.285574,
      NULL,
      NULL,
      NULL,
      1,
      11,
      NULL,
      1.511710,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.388084,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.011378,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202150,
      437.468422,
      23,
      0,
      0.237574,
      NULL,
      1.141549,
      1,
      1.437245,
      0,
      0.305822,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0.944213,
      NULL,
      0.788140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.070473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.450195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199501,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.866646,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.305967,
      NULL,
      0.650941,
      NULL,
      1.575582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1,
      0.468782,
      0,
      NULL,
      1.523106,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.594593,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.378281,
      NULL,
      0,
      NULL,
      NULL,
      1.524798,
      1,
      NULL,
      NULL,
      1.167350,
      NULL,
      0,
      1,
      NULL,
      1.944066,
      0.468121,
      0.026190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.586570,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      0.954075,
      NULL,
      NULL,
      NULL,
      7,
      1,
      4.149884,
      3,
      '31124',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


