set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3240311',
      1,
      NULL,
      NULL,
      2,
      '1110',
      1.896183,
      1.679554,
      NULL,
      NULL,
      ' 1-15-1996',
      24.282367,
      NULL,
      4,
      3.310636,
      NULL,
      ' 3-25-1974',
      49,
      NULL,
      214,
      51,
      0,
      ' 3-21-1998',
      NULL,
      ' 0-16-1976',
      2.435383,
      3.014296,
      0,
      0,
      1,
      3.124533,
      NULL,
      0.756223,
      NULL,
      NULL,
      NULL,
      5,
      1,
      10,
      18.375748,
      3,
      24.037245,
      3,
      3,
      8,
      1,
      1,
      NULL,
      0.910811,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      3,
      3.750468,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1.320886,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      4,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      5,
      NULL,
      5,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      0,
      4,
      0,
      5,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.373944,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.153855,
      4,
      0,
      5.580258,
      5.505424,
      3.949613,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.536184,
      0,
      NULL,
      2,
      2.421661,
      '11- 9-1974',
      92.923365,
      NULL,
      165.358787,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0.511485,
      0.949590,
      NULL,
      2,
      4.016850,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.141688,
      2,
      1,
      1,
      1,
      3,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      17.172606,
      NULL,
      0.020759,
      1.914456,
      0,
      1.061514,
      NULL,
      1.129998,
      1.427613,
      1.439298,
      0,
      0.369883,
      0.319102,
      0,
      0,
      1,
      1,
      5.686889,
      2.882955,
      6.234889,
      6.467844,
      5.806528,
      6,
      3,
      0,
      3.058151,
      1,
      0.471901,
      3,
      56.014513,
      0,
      3.107600,
      NULL,
      37,
      59,
      30.139694,
      3,
      NULL,
      4.972692,
      '4412',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.630603,
      NULL,
      20,
      6,
      2.137032,
      13,
      0,
      3.390086,
      NULL,
      2.700977,
      3.875072,
      0.931504,
      0.927380,
      NULL,
      NULL,
      0.721864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376423,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.087231,
      0.993677,
      NULL,
      0.246731,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.100224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978848,
      NULL,
      0.480505,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.524824,
      NULL,
      0.553217,
      1,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.491376,
      1.946573,
      0,
      3.733110,
      1,
      NULL,
      0.698062,
      1.302708,
      0,
      0,
      0,
      1.157311,
      0.597996,
      0.332577,
      1.925832,
      0,
      NULL,
      NULL,
      NULL,
      0.440069,
      NULL,
      NULL,
      1.889905,
      NULL,
      NULL,
      5,
      3.343581,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.903772,
      0.396331,
      1.433349,
      NULL,
      NULL,
      0.908593,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.375834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228070,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.632902,
      NULL,
      NULL,
      1.295773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      5.399918,
      NULL,
      0,
      6.763148,
      4,
      5.956788,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114507,
      1,
      3,
      3,
      0.031250,
      1,
      1.856931,
      1,
      2,
      NULL,
      3.403609,
      NULL,
      NULL,
      3.657307,
      3.192383,
      2.686620,
      2.872563,
      2.893814,
      0.017447,
      NULL,
      0,
      1,
      2.752826,
      5,
      2,
      NULL,
      4.615219,
      NULL,
      5,
      1.651010,
      NULL,
      NULL,
      1,
      0.909084,
      0,
      0.947731,
      0.707921,
      2.771269,
      NULL,
      NULL,
      0.904205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.855527,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484701,
      NULL,
      NULL,
      1.065261,
      3.506551,
      NULL,
      NULL,
      2.874405,
      NULL,
      2.859793,
      NULL,
      5.488062,
      NULL,
      9.400601,
      NULL,
      2,
      NULL,
      3.858992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.406202,
      NULL,
      3,
      NULL,
      3.649402,
      NULL,
      1.885947,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.669085,
      NULL,
      0,
      NULL,
      7,
      NULL,
      0,
      NULL,
      0.903679,
      1.227218,
      NULL,
      NULL,
      NULL,
      3,
      9,
      1,
      NULL,
      2.980150,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.513195,
      NULL,
      NULL,
      459.612792,
      NULL,
      1,
      3.175020,
      1.549393,
      1.245496,
      0,
      1.000053,
      NULL,
      3.773135,
      NULL,
      1.805185,
      NULL,
      NULL,
      1.151094,
      NULL,
      1.558866,
      NULL,
      0.552963,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      100.389374,
      NULL,
      3,
      8,
      4,
      3.448693,
      2.555713,
      1,
      NULL,
      1,
      NULL,
      1.677578,
      NULL,
      3.496851,
      NULL,
      1.610940,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.992620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.647031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430788,
      1.346702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.580421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443818,
      NULL,
      0.715279,
      NULL,
      NULL,
      1.060909,
      1,
      NULL,
      0.102461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913936,
      NULL,
      1.161696,
      NULL,
      0.172804,
      1,
      1.567157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436977,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      280.180070,
      NULL,
      NULL,
      NULL,
      1.530328,
      NULL,
      NULL,
      0.148330,
      2,
      5,
      14.332238,
      3,
      NULL,
      2,
      NULL,
      1,
      1,
      0,
      3.798608,
      0.968101,
      3.166174,
      NULL,
      3,
      2.151385,
      1,
      0,
      NULL,
      1.234757,
      0,
      1,
      0.409793,
      1.761163,
      NULL,
      NULL,
      1.751592,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1.739081,
      3.172262,
      0,
      NULL,
      1.743658,
      1,
      3.750930,
      NULL,
      NULL,
      2.460029,
      1,
      0,
      1.585833,
      NULL,
      1,
      NULL,
      1.659201,
      NULL,
      2.039933,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.221466,
      1,
      0.487194,
      NULL,
      0,
      3.142733,
      2,
      NULL,
      1,
      1.907254,
      1,
      0.082046,
      1.490665,
      3.619346,
      NULL,
      NULL,
      NULL,
      0.830542,
      2,
      2.379900,
      3,
      NULL,
      1.761945,
      3,
      2,
      0,
      69,
      1,
      NULL,
      1,
      0,
      2,
      1,
      1,
      0,
      1,
      5,
      6,
      0,
      NULL,
      NULL,
      84.052891,
      NULL,
      4,
      3,
      0,
      '2434',
      '13402',
      '03101',
      0,
      '',
      '',
      '',
      1.105495,
      NULL,
      '',
      '');
commit;
end;
/


