set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1.404230,
      NULL,
      3.131440,
      1.499261,
      0.464227,
      0,
      0,
      NULL,
      '23013144',
      NULL,
      24.248847,
      '0100210',
      0.295380,
      1,
      3,
      1,
      '0142',
      4,
      1,
      NULL,
      NULL,
      ' 9-17-1982',
      31,
      103,
      NULL,
      1,
      3.666226,
      ' 0-21-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11-17-1976',
      ' 7- 0-2003',
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      2,
      0.756006,
      NULL,
      NULL,
      NULL,
      1.388847,
      4.241442,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      1.916265,
      1.997788,
      1,
      0,
      2.085898,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      0,
      1,
      1,
      1,
      5,
      NULL,
      5,
      0,
      NULL,
      2,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      9.483732,
      2.889821,
      1.772221,
      0.937190,
      0,
      1,
      0.017095,
      2.784402,
      0.761939,
      0,
      1.648790,
      1.472348,
      1.265693,
      2,
      0.611237,
      3,
      1,
      2,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0.981795,
      NULL,
      NULL,
      1.604805,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.186947,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      5,
      3,
      1,
      1,
      2,
      0,
      NULL,
      2,
      3,
      0,
      3,
      1,
      1,
      NULL,
      3,
      4,
      4,
      3,
      2,
      4,
      4,
      4,
      0,
      5,
      2,
      NULL,
      50.295309,
      ' 0- 3-1991',
      NULL,
      1.540589,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0,
      1,
      1.269712,
      1.978936,
      0,
      1.649333,
      8,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.477576,
      4,
      9,
      0,
      1.994037,
      5.077821,
      0,
      NULL,
      NULL,
      NULL,
      0.629935,
      5.255990,
      1.061420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.069512,
      NULL,
      0,
      1.535505,
      13.390045,
      0.838743,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      3,
      3,
      1,
      3,
      3,
      3,
      1,
      1,
      0,
      NULL,
      0,
      0.857197,
      NULL,
      0.671152,
      5.653958,
      1.360917,
      0.746210,
      0.806053,
      0,
      1.976444,
      NULL,
      1.814046,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.063615,
      6.513067,
      3,
      2,
      NULL,
      2.342722,
      0.618041,
      NULL,
      NULL,
      3.898637,
      NULL,
      67.867168,
      NULL,
      NULL,
      36,
      NULL,
      41,
      21,
      NULL,
      NULL,
      3,
      '33424',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648508,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624878,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.938782,
      NULL,
      1,
      41.613575,
      1,
      1,
      0.780072,
      0,
      0.472745,
      NULL,
      0.736929,
      0.313842,
      1.863807,
      0,
      1,
      1.485652,
      0.164587,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343756,
      0.013839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.772556,
      3,
      NULL,
      1,
      NULL,
      1.747714,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.331449,
      NULL,
      1.352659,
      1,
      0.569270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853700,
      3.749341,
      NULL,
      0,
      NULL,
      0.149070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.368221,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267614,
      NULL,
      NULL,
      NULL,
      1.796016,
      0,
      0.611278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.948086,
      1.659262,
      3,
      NULL,
      2.632903,
      NULL,
      0.795962,
      NULL,
      NULL,
      NULL,
      0.368196,
      NULL,
      0.485406,
      NULL,
      NULL,
      1.972011,
      NULL,
      5.208398,
      10,
      1.526355,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      4,
      NULL,
      0.575455,
      3.398676,
      2,
      2.015209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.110631,
      1.241199,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.291787,
      NULL,
      0,
      0,
      NULL,
      0,
      0.541223,
      NULL,
      0.808518,
      NULL,
      NULL,
      1,
      1.505052,
      NULL,
      1.053865,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.334444,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.120086,
      NULL,
      1.322282,
      NULL,
      0,
      NULL,
      1,
      0.249651,
      NULL,
      NULL,
      94,
      44,
      3,
      3,
      1,
      '40332',
      '23340',
      '',
      0.075994,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


