set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9033939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      3.380373,
      NULL,
      0,
      NULL,
      '3402',
      2,
      NULL,
      NULL,
      NULL,
      ' 2-23-1975',
      29,
      NULL,
      NULL,
      3,
      0.702156,
      ' 4-22-1996',
      8,
      0.599261,
      75.591789,
      91,
      1,
      ' 2- 4-2001',
      ' 2-20-1985',
      '10- 9-1997',
      3,
      3,
      3.846477,
      1.720947,
      0.035084,
      1.717613,
      1,
      NULL,
      0,
      NULL,
      8,
      12.728013,
      5,
      167.838965,
      87.385749,
      5,
      NULL,
      5,
      3,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      2,
      3,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      1.847570,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1,
      3,
      1.533689,
      2,
      2.996405,
      1.792845,
      3,
      1.194548,
      0,
      1,
      NULL,
      0.832197,
      1,
      2,
      NULL,
      1.510441,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0.250211,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      4,
      NULL,
      3,
      3,
      4,
      2,
      5,
      0,
      5,
      4,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      ' 8- 8-1994',
      391,
      ' 9-18-1986',
      NULL,
      2,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.348122,
      1.806949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.082649,
      2.016010,
      NULL,
      2,
      2.746956,
      NULL,
      NULL,
      1,
      6.722744,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      8,
      NULL,
      1,
      4,
      1,
      8.981173,
      ' 1- 1-1985',
      5.805702,
      ' 5- 9-1984',
      1,
      1,
      0,
      NULL,
      1,
      3.921340,
      0,
      3,
      1.554226,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.201176,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      2,
      0,
      3,
      0,
      17,
      3.451990,
      34,
      91,
      125,
      107,
      107,
      NULL,
      0.081391,
      NULL,
      NULL,
      1,
      0.149281,
      0,
      1,
      18,
      16,
      1.690280,
      0,
      1,
      NULL,
      2,
      NULL,
      7,
      2.491515,
      NULL,
      5,
      0.202217,
      3.703580,
      NULL,
      NULL,
      1,
      1.770107,
      NULL,
      31,
      21,
      42,
      0,
      0,
      4.654894,
      NULL,
      '02220',
      '',
      1,
      '',
      '',
      '',
      0.955267,
      '',
      '',
      '',
      0,
      3,
      50.158371,
      38.770876,
      2.430579,
      32.756939,
      1,
      0,
      3,
      0.367759,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.880570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990764,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1,
      1.200886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349431,
      NULL,
      1.661769,
      1.879917,
      NULL,
      NULL,
      0,
      1,
      1.571135,
      0.676494,
      0.368482,
      0,
      0.001491,
      0.486446,
      0,
      NULL,
      0.478192,
      NULL,
      NULL,
      1.397536,
      3.107209,
      2,
      0,
      0.927459,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.961101,
      1,
      6.520111,
      0.985781,
      0.280345,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537449,
      NULL,
      NULL,
      NULL,
      0.106252,
      NULL,
      NULL,
      0.035091,
      NULL,
      NULL,
      0.774479,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.532637,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.547081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.733600,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.229816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166559,
      NULL,
      0,
      1.413894,
      NULL,
      NULL,
      6.466887,
      7,
      0,
      NULL,
      0.057910,
      2.753779,
      NULL,
      1,
      2,
      2.498997,
      2,
      0,
      0.953539,
      3,
      3,
      NULL,
      NULL,
      2.512687,
      7,
      1,
      4,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.709889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.224811,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.511640,
      0,
      1,
      0.646919,
      NULL,
      0.491469,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351655,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.907710,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.386255,
      NULL,
      NULL,
      NULL,
      1.496715,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.889948,
      NULL,
      1,
      3.141922,
      NULL,
      1.480454,
      NULL,
      NULL,
      2.495058,
      NULL,
      NULL,
      1.672156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.422075,
      162,
      NULL,
      0.717454,
      1.800730,
      1,
      1.568822,
      1,
      NULL,
      0.219332,
      1,
      1.517195,
      NULL,
      1,
      1.118194,
      1.978981,
      NULL,
      0,
      1,
      0.548278,
      0.954069,
      NULL,
      3.523978,
      NULL,
      0.803153,
      NULL,
      NULL,
      NULL,
      0.779063,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.174168,
      NULL,
      21.916052,
      NULL,
      1.448878,
      NULL,
      NULL,
      1.147829,
      NULL,
      NULL,
      NULL,
      0.321782,
      NULL,
      1.190469,
      NULL,
      0,
      NULL,
      0.553338,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.752292,
      NULL,
      1.224055,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.014298,
      3.450788,
      NULL,
      0,
      NULL,
      3.535628,
      NULL,
      1.194866,
      NULL,
      617.574609,
      NULL,
      0.381315,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.351444,
      1.604099,
      3.225007,
      NULL,
      1.100512,
      NULL,
      0.256195,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.482913,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      11,
      NULL,
      2,
      NULL,
      0.714635,
      NULL,
      1.466489,
      NULL,
      NULL,
      1.537233,
      0.372966,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      738,
      NULL,
      2.104071,
      NULL,
      1,
      NULL,
      1.366179,
      NULL,
      NULL,
      NULL,
      3.335505,
      NULL,
      1.508681,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.984174,
      NULL,
      0.248339,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.119719,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.071308,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      24.427996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1.698492,
      1,
      NULL,
      1,
      0.221099,
      NULL,
      0,
      NULL,
      NULL,
      0.486720,
      0.418964,
      NULL,
      1.071633,
      0,
      NULL,
      0.499922,
      0.906305,
      NULL,
      1.807044,
      0,
      NULL,
      0.587933,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.434071,
      NULL,
      0.977527,
      1,
      NULL,
      1,
      0.945014,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906955,
      NULL,
      1.894539,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      1,
      1.380608,
      0,
      17.653591,
      4,
      1,
      5,
      '00130',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


