set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.386633,
      2,
      0.007676,
      4.595625,
      4.157561,
      NULL,
      NULL,
      2.105377,
      '003',
      '20422033',
      46.643843,
      NULL,
      '4334004',
      NULL,
      0.423391,
      NULL,
      3,
      '4420',
      4,
      1.871301,
      NULL,
      NULL,
      ' 1-23-1986',
      28,
      NULL,
      NULL,
      0,
      1.492182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3- 5-1992',
      ' 8-29-1976',
      ' 0- 5-1976',
      1,
      2,
      2,
      0,
      0.691800,
      0,
      0,
      0.655366,
      1,
      13.000589,
      8,
      12.953349,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.478978,
      0,
      2,
      1,
      4,
      NULL,
      3,
      0.051302,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      1,
      1,
      4,
      1,
      7,
      0,
      1,
      0,
      2,
      0.972763,
      NULL,
      NULL,
      1.895301,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2.319116,
      1,
      NULL,
      1.134854,
      0,
      0.604886,
      0,
      0.499954,
      0.122886,
      NULL,
      1,
      NULL,
      1.980442,
      1,
      0.785280,
      1.088657,
      1,
      1,
      1,
      1,
      1,
      1,
      0.851933,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      4,
      4,
      3,
      0,
      NULL,
      1,
      0,
      0,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.804286,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      0,
      2,
      1,
      1,
      1,
      NULL,
      3,
      2,
      5,
      4,
      5,
      2,
      NULL,
      0,
      1,
      NULL,
      ' 5-10-1989',
      270.142231,
      ' 5-27-1984',
      44.261393,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      3,
      2.311162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.533568,
      1,
      2.546371,
      2,
      1,
      0.575185,
      NULL,
      5,
      6,
      2.226833,
      4,
      1,
      NULL,
      NULL,
      1.245683,
      2.103508,
      1.435457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610126,
      0.664551,
      0,
      1,
      1.148130,
      0,
      0,
      3,
      11.553975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      1,
      2,
      0,
      0,
      0,
      0,
      0,
      NULL,
      3,
      2,
      2.449814,
      NULL,
      NULL,
      1,
      1.509185,
      NULL,
      0,
      0,
      1,
      1,
      0.763242,
      1.109006,
      1,
      0,
      1.178672,
      3,
      0.353742,
      2.368602,
      2.368939,
      4.458515,
      10,
      3,
      7.416517,
      4.184239,
      2.857776,
      NULL,
      0,
      2.878931,
      3,
      11.929822,
      0,
      1.676863,
      54,
      NULL,
      53,
      15.877497,
      0,
      5.050573,
      1.567121,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3.635619,
      4,
      230.775802,
      19.986127,
      1.040604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.785245,
      1,
      0.736403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637403,
      NULL,
      0,
      1.142537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.213276,
      0.336698,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.691200,
      NULL,
      NULL,
      0.176923,
      NULL,
      NULL,
      1.360888,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      0.405570,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      0.977165,
      NULL,
      NULL,
      1.890587,
      1.736428,
      1,
      3,
      1,
      1.767103,
      NULL,
      1.039831,
      0,
      2,
      3,
      0.738685,
      0.852532,
      0.551259,
      0.417723,
      1.609875,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.082715,
      NULL,
      1.534779,
      0.658363,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.625476,
      NULL,
      NULL,
      NULL,
      3.118146,
      NULL,
      3,
      0.302062,
      3.375028,
      0.036657,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.196924,
      NULL,
      4,
      NULL,
      2.758921,
      0.965253,
      1.928376,
      NULL,
      NULL,
      1,
      NULL,
      1.188683,
      0.073753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.932195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      4,
      3.833355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.312136,
      2,
      NULL,
      0.229395,
      2.782931,
      0,
      1.664763,
      NULL,
      NULL,
      2.922901,
      3,
      5.409733,
      0.733278,
      3.078140,
      2.991187,
      0,
      2.330078,
      NULL,
      NULL,
      0,
      1.689262,
      0,
      1.259390,
      0.467902,
      3,
      6,
      4,
      0.868433,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      NULL,
      0.902715,
      1.507046,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.705552,
      NULL,
      NULL,
      3.141810,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.450382,
      1,
      NULL,
      1.822999,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.217786,
      NULL,
      NULL,
      NULL,
      1.669125,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.217628,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.044210,
      NULL,
      NULL,
      NULL,
      1.505160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.573382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.452820,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.734708,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.558012,
      0.029203,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.448756,
      NULL,
      NULL,
      1.804100,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.546665,
      NULL,
      1,
      513.683313,
      7.738555,
      NULL,
      2.436032,
      1,
      NULL,
      1.317550,
      1,
      1,
      0.129316,
      3.567890,
      NULL,
      1.436455,
      NULL,
      1.109348,
      NULL,
      1.872278,
      0,
      1.526581,
      0,
      1.990243,
      0,
      0.367581,
      3,
      NULL,
      1.292110,
      1.483457,
      2.041562,
      1,
      3,
      0.410595,
      18.558348,
      NULL,
      1,
      37.227673,
      3.256579,
      1.424244,
      NULL,
      NULL,
      1.580075,
      NULL,
      0,
      NULL,
      0.028234,
      1.797893,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.587046,
      1.835021,
      0.185825,
      1.104355,
      0,
      1.300875,
      1,
      1.750833,
      0.089611,
      NULL,
      0.907836,
      1,
      1.085721,
      0.831352,
      1,
      1,
      1.797420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677985,
      0.502642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.188961,
      3.771372,
      3.939530,
      NULL,
      3.814106,
      0.644718,
      13,
      89.870587,
      NULL,
      3.843088,
      NULL,
      1.972633,
      1,
      1.790994,
      0.844125,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      13.409328,
      2.748254,
      4.773839,
      2.183466,
      3,
      5.029021,
      NULL,
      1.962001,
      0,
      NULL,
      1.941126,
      NULL,
      0,
      3.666651,
      NULL,
      3.423642,
      1,
      NULL,
      1,
      0.980763,
      NULL,
      1.452743,
      3,
      NULL,
      0.792787,
      2,
      NULL,
      NULL,
      1.272858,
      NULL,
      0,
      0.471894,
      NULL,
      1.149716,
      NULL,
      NULL,
      NULL,
      1.187161,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429421,
      NULL,
      1,
      NULL,
      4,
      4,
      5,
      3,
      NULL,
      1.184290,
      6.081573,
      29.883180,
      3,
      0.333960,
      4.832698,
      NULL,
      '42310',
      '43020',
      1,
      '',
      '',
      '',
      1.702388,
      '',
      '',
      NULL);
commit;
end;
/


