set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223065';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0131012',
      3.815853,
      0.560257,
      3,
      0,
      NULL,
      1.749209,
      1,
      NULL,
      NULL,
      NULL,
      46.064502,
      NULL,
      1,
      3,
      NULL,
      ' 1-20-1994',
      49,
      0.052174,
      203,
      71.347421,
      0,
      ' 6- 6-1978',
      ' 8- 1-1989',
      NULL,
      3.057788,
      3.175596,
      1.465347,
      2,
      0.905704,
      3.337803,
      NULL,
      1.493463,
      1.639830,
      92,
      1,
      6,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      2.308772,
      NULL,
      0,
      1,
      2,
      4,
      3,
      5,
      2,
      1,
      0,
      1,
      NULL,
      7.384262,
      1,
      0,
      NULL,
      NULL,
      1.849310,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0.003389,
      2,
      1.846826,
      0.231209,
      1,
      NULL,
      NULL,
      0.344689,
      1.405401,
      0,
      1.203113,
      0,
      1.130771,
      NULL,
      1.768307,
      1.872688,
      NULL,
      4,
      NULL,
      0,
      NULL,
      0,
      0,
      5.664236,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      5,
      0,
      3,
      4,
      5,
      1,
      0,
      2,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.290470,
      3,
      5,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1,
      4,
      4,
      5,
      3,
      5,
      1,
      4,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      1,
      2.783329,
      NULL,
      2,
      ' 5-12-1974',
      14,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      1,
      1,
      0,
      0,
      1.608194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858152,
      1.864831,
      0.048153,
      0.841800,
      1.441491,
      1.978979,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.277569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.674604,
      1,
      0.276292,
      1.897923,
      0.734664,
      1.998406,
      1,
      1,
      NULL,
      0.010485,
      0.714913,
      NULL,
      NULL,
      NULL,
      1,
      1.288384,
      0,
      NULL,
      0,
      1,
      2,
      0,
      1,
      2,
      1,
      3,
      2,
      1.178100,
      1.230975,
      0,
      10,
      0.727100,
      0.692131,
      1,
      1.978134,
      1.410053,
      1,
      0.345709,
      0.081276,
      0.625736,
      1,
      1.342978,
      1,
      1,
      2.695460,
      1,
      2.672082,
      4,
      NULL,
      NULL,
      9,
      NULL,
      3.628450,
      2.449796,
      NULL,
      0.569807,
      NULL,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      35,
      21,
      18,
      NULL,
      0,
      0,
      '12143',
      '',
      '',
      0.327759,
      '',
      '',
      NULL,
      0.573672,
      '',
      '',
      NULL,
      1,
      16,
      177.385020,
      15.132185,
      NULL,
      34,
      0,
      1,
      1,
      1,
      1.469544,
      3.173208,
      0.435176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.499264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.356201,
      2.250500,
      1,
      NULL,
      NULL,
      1.930820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.478241,
      6.891547,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.244095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.954944,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.422548,
      NULL,
      1.979450,
      NULL,
      NULL,
      1.114350,
      0.242157,
      1,
      0,
      3,
      3,
      NULL,
      1.532114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178225,
      0.303796,
      NULL,
      NULL,
      4.343852,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071059,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      5,
      7.354045,
      3,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      2.721418,
      4.608697,
      0.168694,
      1.348331,
      NULL,
      NULL,
      1.053221,
      NULL,
      NULL,
      1.327712,
      NULL,
      NULL,
      1.845642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.524427,
      1,
      NULL,
      NULL,
      3.530448,
      NULL,
      0.076947,
      3.902556,
      2,
      2.811733,
      0,
      4.989217,
      5.520250,
      NULL,
      NULL,
      0,
      1.098685,
      NULL,
      3,
      1.823217,
      2.544028,
      1,
      7,
      NULL,
      1,
      3.654591,
      1.320495,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.460025,
      0.900650,
      2,
      1,
      1,
      4.168749,
      2.764463,
      9,
      5.095573,
      2,
      1,
      1.700038,
      2,
      4,
      NULL,
      NULL,
      0,
      1.030380,
      1.881368,
      3.162134,
      NULL,
      NULL,
      6.291864,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.366880,
      NULL,
      NULL,
      0.594048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.647255,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.388953,
      NULL,
      NULL,
      2.187443,
      NULL,
      NULL,
      1,
      0.453467,
      0,
      0,
      0,
      2.339941,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      15.136830,
      NULL,
      NULL,
      NULL,
      2.125681,
      NULL,
      NULL,
      NULL,
      1.989814,
      NULL,
      NULL,
      NULL,
      1.118604,
      NULL,
      NULL,
      NULL,
      0.773891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377392,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680943,
      NULL,
      NULL,
      NULL,
      1.343835,
      NULL,
      NULL,
      NULL,
      1.120872,
      NULL,
      NULL,
      NULL,
      1.608718,
      NULL,
      NULL,
      NULL,
      1.005112,
      NULL,
      NULL,
      NULL,
      0.038573,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.336530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      34.919866,
      0,
      NULL,
      8.412047,
      1.630907,
      NULL,
      NULL,
      1,
      0.388756,
      NULL,
      2.230920,
      2,
      0.725958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.946106,
      17.413483,
      NULL,
      NULL,
      1,
      1.319301,
      0,
      1.011241,
      1,
      1.161699,
      1.247670,
      0,
      1.708307,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152321,
      NULL,
      0.957789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037970,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939408,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.696490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.432563,
      NULL,
      1.801859,
      NULL,
      0.511339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998493,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730411,
      NULL,
      1,
      0.357875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9.571039,
      4,
      3,
      NULL,
      0,
      4.251853,
      3.110644,
      0,
      3.488730,
      NULL,
      1,
      3.370422,
      0,
      1.091353,
      3,
      1.122970,
      0,
      NULL,
      1,
      0.402864,
      1,
      3,
      1.575902,
      0,
      NULL,
      0.328542,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      2,
      0,
      2.838594,
      1.260542,
      0,
      2,
      0,
      3,
      NULL,
      3,
      0.901841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.619778,
      0,
      1.682702,
      0.681775,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      9.522604,
      6.938861,
      1,
      1.462157,
      3,
      '14210',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


