set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.036280,
      1,
      1,
      '0310',
      3.511201,
      1,
      NULL,
      NULL,
      NULL,
      60.787445,
      NULL,
      5,
      0.036245,
      1.664681,
      ' 9- 0-1994',
      NULL,
      1.868659,
      294,
      25.986327,
      2,
      ' 0-25-1993',
      ' 0- 4-1998',
      ' 2-21-1991',
      2,
      0.903011,
      1,
      NULL,
      0.400106,
      0.223206,
      3,
      2.212228,
      NULL,
      NULL,
      NULL,
      0.851972,
      5.418524,
      18.331811,
      9,
      2,
      21,
      4,
      NULL,
      2,
      1,
      0,
      1,
      0.744394,
      0,
      NULL,
      1.815563,
      1,
      0,
      NULL,
      0.760768,
      2,
      3,
      0,
      2.999987,
      1,
      0,
      1,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      4,
      NULL,
      1,
      1,
      0,
      2,
      0,
      1,
      0.280528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.528255,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.127492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      4,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      4,
      1,
      NULL,
      3,
      1,
      1,
      0,
      2,
      0,
      3,
      2,
      5,
      2,
      2.469988,
      NULL,
      ' 7-11-1999',
      NULL,
      ' 0-24-1992',
      2.926320,
      1,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      0.301346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.579238,
      1,
      2,
      1.176988,
      1.651094,
      NULL,
      1.616074,
      1,
      NULL,
      0.431262,
      NULL,
      NULL,
      NULL,
      0.500484,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.391075,
      1.609139,
      0.513761,
      NULL,
      1.535336,
      1.214297,
      0.872446,
      14,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1.139058,
      NULL,
      3.742036,
      NULL,
      1,
      0.757108,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.691126,
      0,
      1,
      0.587459,
      1,
      4.523553,
      2,
      NULL,
      2.211340,
      8,
      6,
      5,
      3,
      4.285976,
      0.104837,
      1.701571,
      NULL,
      1.404609,
      1,
      2,
      NULL,
      64,
      27,
      66,
      1,
      0.649265,
      1.874317,
      '43421',
      '30223',
      NULL,
      0,
      '',
      '',
      '',
      0.823277,
      '',
      '',
      '',
      0,
      NULL,
      21,
      13,
      2.423940,
      27,
      0.396072,
      2.776241,
      1,
      NULL,
      1.585985,
      0.198686,
      1.017821,
      NULL,
      NULL,
      3,
      2,
      1.612562,
      2.653432,
      1.120025,
      0,
      0.729125,
      1.902459,
      0.263725,
      3.069200,
      2.150828,
      NULL,
      0,
      1.672467,
      0.366162,
      1.116647,
      NULL,
      NULL,
      0.977540,
      NULL,
      NULL,
      2.154059,
      0.832235,
      0.422173,
      0.155797,
      1.935445,
      0,
      0,
      NULL,
      NULL,
      11.820187,
      4.688451,
      1.394900,
      1,
      1.895814,
      NULL,
      NULL,
      NULL,
      1.313598,
      NULL,
      NULL,
      NULL,
      1,
      1.711443,
      1,
      0.887474,
      1.761021,
      0.985684,
      NULL,
      2.778834,
      1.700120,
      2.969315,
      2.748509,
      3,
      2.935586,
      3.337239,
      0,
      1.339416,
      1,
      0.730614,
      1,
      2.551376,
      1.023805,
      1.530896,
      1.324638,
      3,
      0,
      1,
      0,
      1.859160,
      0.231242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.303072,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.343357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.388661,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499295,
      NULL,
      NULL,
      0.270069,
      NULL,
      NULL,
      2,
      2,
      0,
      0.483406,
      5.923653,
      NULL,
      NULL,
      1.724902,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2.576837,
      1.393475,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      0.652088,
      3.884783,
      3.712574,
      NULL,
      3.113283,
      0,
      NULL,
      NULL,
      2.426698,
      1.981381,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.708877,
      NULL,
      3,
      0,
      0.807023,
      1,
      1.376019,
      1,
      1.236730,
      0.187037,
      NULL,
      NULL,
      1.762272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.997147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044167,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.000731,
      NULL,
      NULL,
      0.079724,
      0,
      NULL,
      NULL,
      NULL,
      0.921442,
      0,
      NULL,
      NULL,
      1.203543,
      NULL,
      NULL,
      NULL,
      3.559646,
      NULL,
      NULL,
      NULL,
      0.812175,
      NULL,
      NULL,
      NULL,
      3.226050,
      1,
      NULL,
      NULL,
      1.867009,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.400382,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.349222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.641069,
      1,
      NULL,
      NULL,
      1.453299,
      1.395077,
      NULL,
      NULL,
      1.077020,
      0,
      NULL,
      NULL,
      14,
      1.794092,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      3,
      5,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.162249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.145380,
      136,
      NULL,
      1.648016,
      1.305454,
      1.539058,
      0,
      0.302523,
      2,
      NULL,
      0.121349,
      0,
      1.129744,
      NULL,
      3.442011,
      1.767003,
      NULL,
      1.674122,
      1.661876,
      1.877106,
      2.285240,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.947301,
      18,
      18,
      1.638055,
      1.455483,
      NULL,
      NULL,
      0.740175,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.547172,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.130066,
      NULL,
      0.083960,
      NULL,
      1,
      NULL,
      1.440648,
      NULL,
      1.209227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.558112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712298,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.522227,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298709,
      NULL,
      0.030986,
      NULL,
      0.300701,
      0,
      1.282887,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391086,
      NULL,
      1,
      NULL,
      1.898122,
      NULL,
      0.574059,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956436,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411726,
      1.774192,
      0.982175,
      1.212323,
      2.074555,
      1.916645,
      2.597779,
      NULL,
      NULL,
      1,
      0,
      1.740866,
      0,
      1.390446,
      0.801668,
      1,
      2.815925,
      19.313770,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0.914454,
      4,
      4,
      3.655133,
      2,
      15,
      3,
      1,
      NULL,
      0,
      0,
      0.134926,
      1,
      1,
      0.924477,
      1,
      3.633417,
      1,
      0,
      2,
      1.475762,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.096208,
      0.813772,
      0,
      0,
      1,
      1,
      1.729807,
      1.878884,
      1.949048,
      1.980194,
      0,
      0.383969,
      1.897444,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.494105,
      1,
      0,
      2,
      NULL,
      5,
      1.530653,
      NULL,
      NULL,
      67.180487,
      116,
      NULL,
      NULL,
      7,
      NULL,
      '43230',
      NULL,
      1.152192,
      '',
      '',
      '',
      1.764239,
      '',
      NULL,
      '');
commit;
end;
/


