set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '32',
      27.101665,
      NULL,
      '4122412',
      3.981964,
      1.682332,
      NULL,
      NULL,
      '1142',
      0.280002,
      NULL,
      NULL,
      NULL,
      ' 3-29-1983',
      121.356224,
      45.385421,
      NULL,
      1.239971,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 8- 0-2001',
      3.376429,
      NULL,
      2.335986,
      3.849808,
      0,
      3,
      1,
      0,
      1.300581,
      0.723499,
      NULL,
      17.471528,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.763276,
      1,
      NULL,
      5.217761,
      1.017569,
      0,
      2,
      4,
      2,
      2,
      NULL,
      0,
      3,
      1,
      0,
      5,
      2,
      3,
      5,
      NULL,
      0,
      2,
      1.589781,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.717324,
      NULL,
      NULL,
      3,
      NULL,
      0.498352,
      2.114329,
      1,
      1,
      1,
      0,
      0,
      0.734066,
      2,
      NULL,
      1.097390,
      1.657408,
      0.115819,
      0,
      NULL,
      0.668410,
      3,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.802073,
      NULL,
      NULL,
      1.238813,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      6,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.217981,
      NULL,
      4,
      1,
      1,
      0,
      2,
      5,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4,
      NULL,
      1,
      0,
      2,
      5,
      NULL,
      3,
      NULL,
      2,
      2,
      4,
      NULL,
      5.373228,
      3,
      ' 0- 5-1982',
      205,
      NULL,
      NULL,
      1.543900,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1,
      4,
      NULL,
      3.805037,
      1.804041,
      0.368737,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.311274,
      0.206208,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      10.341794,
      5,
      0,
      2,
      0,
      3,
      0.468289,
      0,
      0.774061,
      5.051973,
      2,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254986,
      NULL,
      0.129819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.328947,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      2,
      0,
      1,
      2,
      1,
      0,
      0,
      2,
      2.291133,
      0,
      0.725751,
      NULL,
      1,
      0,
      3.256859,
      NULL,
      1,
      0.235770,
      0.350987,
      0,
      1,
      1,
      0.905826,
      1,
      0,
      1,
      1,
      11.249546,
      7,
      1.634257,
      NULL,
      1,
      4.907743,
      0.362929,
      1.004910,
      3,
      NULL,
      2.941548,
      2.415315,
      22,
      NULL,
      1,
      0,
      NULL,
      60,
      52.515722,
      1,
      2,
      3,
      NULL,
      '',
      '',
      1.158901,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3,
      19,
      4,
      17.230618,
      NULL,
      19.547806,
      7.018331,
      3.653194,
      NULL,
      2.479519,
      2.135861,
      3.259642,
      1.347992,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.551093,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.482102,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      0,
      3.704791,
      1.195285,
      0,
      3.201119,
      0,
      NULL,
      NULL,
      3.304088,
      0.164272,
      0,
      0.099063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.176379,
      0.239666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      2,
      1.423309,
      NULL,
      3,
      1,
      3.413581,
      1.660700,
      3.183477,
      NULL,
      2,
      0,
      3,
      0.751065,
      NULL,
      NULL,
      0.407843,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.931952,
      0,
      1.831514,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.998858,
      3,
      0.958021,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.887909,
      0,
      3.775958,
      0.965879,
      1.473822,
      1,
      NULL,
      NULL,
      4.661605,
      0.946159,
      2,
      1.741125,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.021899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.812256,
      3,
      0,
      NULL,
      NULL,
      8,
      1,
      3.334133,
      3,
      2.669444,
      2,
      2,
      NULL,
      NULL,
      2,
      3,
      2,
      0.165645,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433204,
      NULL,
      1,
      6.727567,
      1,
      2,
      2.305907,
      0,
      2,
      0.891490,
      2,
      NULL,
      0.635590,
      0.023177,
      3.796825,
      2,
      5,
      4.956616,
      5,
      2,
      NULL,
      0,
      2.414205,
      NULL,
      3,
      NULL,
      1,
      1.510932,
      0.014388,
      1,
      2.654449,
      NULL,
      NULL,
      1.556842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216189,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.250470,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949664,
      1.078176,
      0.927341,
      NULL,
      0,
      2.921197,
      3.184606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950668,
      0.276915,
      NULL,
      NULL,
      1.595028,
      NULL,
      NULL,
      NULL,
      1.208626,
      3.891496,
      NULL,
      NULL,
      1,
      2.392718,
      NULL,
      NULL,
      1.852362,
      0,
      NULL,
      NULL,
      1,
      1.742768,
      NULL,
      NULL,
      0,
      1.615200,
      NULL,
      NULL,
      5,
      3.424437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884817,
      0.207328,
      5,
      0.875795,
      18,
      0,
      1,
      NULL,
      NULL,
      1.964932,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389588,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598201,
      NULL,
      0.423786,
      0,
      NULL,
      NULL,
      0.329380,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.504892,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      3.791696,
      0.991742,
      NULL,
      0.628108,
      0,
      0,
      1.238711,
      3.121102,
      1.070578,
      0,
      NULL,
      1,
      0.382676,
      1,
      1.261249,
      1,
      1.470047,
      0.177426,
      1,
      0.500981,
      1,
      0.332865,
      0.561984,
      1.325577,
      1.943747,
      0,
      2,
      1.104979,
      1,
      1,
      0,
      1,
      0.883848,
      NULL,
      1.740921,
      0,
      NULL,
      0.877461,
      0.166163,
      1.671742,
      NULL,
      2,
      NULL,
      1,
      1.235096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.905604,
      1,
      1,
      1.108190,
      0.101863,
      1.723305,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0.193202,
      1.855554,
      0.740917,
      0,
      1.084232,
      1,
      0,
      1,
      1.487739,
      0.441310,
      16,
      0.833079,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.970288,
      NULL,
      NULL,
      NULL,
      117.119995,
      NULL,
      5.900065,
      3,
      NULL,
      '20033',
      '',
      1,
      '',
      '',
      '',
      1.125086,
      '',
      '',
      '');
commit;
end;
/


