set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1011204',
      NULL,
      1,
      0,
      2,
      '2441',
      2.966192,
      0.723365,
      NULL,
      NULL,
      NULL,
      44.508169,
      NULL,
      NULL,
      1,
      5,
      ' 5-27-1988',
      26,
      3,
      51.192387,
      92.020822,
      1,
      ' 4- 1-1991',
      ' 4-29-1976',
      ' 7-26-1982',
      3.773982,
      0,
      0.501147,
      0,
      NULL,
      3,
      2,
      0.731096,
      0.979360,
      30,
      4,
      15,
      8,
      1.573646,
      22,
      1,
      NULL,
      NULL,
      0,
      0,
      1.438643,
      0,
      0,
      0,
      1,
      1,
      1.516221,
      0.055139,
      1.946725,
      1.751806,
      0,
      NULL,
      0,
      1,
      2,
      3,
      0,
      0,
      NULL,
      5,
      NULL,
      5,
      2,
      1,
      0,
      5,
      NULL,
      4.729948,
      NULL,
      1,
      1,
      0,
      0.616309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.140147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      5,
      NULL,
      5,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1.807858,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      3,
      5,
      3,
      0,
      2,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      0,
      NULL,
      0.325348,
      2.790295,
      ' 6- 4-1984',
      289.714609,
      ' 7-19-1992',
      22.689859,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3,
      0.939356,
      0,
      1.552708,
      1.944040,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.463102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.091938,
      0.041632,
      NULL,
      1.398612,
      3.813794,
      1,
      NULL,
      3.639528,
      1.187397,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.984541,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      0.596671,
      NULL,
      NULL,
      0,
      NULL,
      1.770404,
      0.792755,
      1,
      NULL,
      0.194197,
      1,
      0,
      1,
      0,
      0,
      NULL,
      10.290911,
      3,
      1,
      3,
      2,
      2,
      1.114837,
      7.551647,
      1,
      2.594472,
      3,
      13.685160,
      0,
      1,
      NULL,
      35,
      55,
      58.600399,
      3,
      0.332332,
      5,
      '22243',
      '03310',
      '41241',
      0.983130,
      '',
      NULL,
      NULL,
      1,
      '1023',
      '',
      '',
      0.194827,
      24,
      103,
      4,
      NULL,
      46.536277,
      0.972924,
      NULL,
      NULL,
      0.218593,
      3.757583,
      1.328878,
      0,
      NULL,
      NULL,
      3.513546,
      NULL,
      2.998911,
      2.877863,
      3.795291,
      1.293366,
      NULL,
      0,
      2,
      2,
      0.287494,
      0,
      3,
      1.085159,
      3.671580,
      NULL,
      NULL,
      NULL,
      0.886763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.286832,
      0,
      2,
      NULL,
      NULL,
      NULL,
      10.991319,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.078719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.254322,
      NULL,
      2.459018,
      3.507680,
      0,
      1,
      1,
      NULL,
      0.963482,
      NULL,
      1.189203,
      4.622144,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357659,
      NULL,
      NULL,
      NULL,
      1.243818,
      NULL,
      NULL,
      NULL,
      0.029719,
      1.810343,
      2.399642,
      0,
      1.967810,
      0,
      NULL,
      NULL,
      2,
      2.016925,
      0.008528,
      1.960761,
      3.515164,
      NULL,
      0.846247,
      NULL,
      0.830070,
      3.575637,
      NULL,
      1.384588,
      NULL,
      NULL,
      NULL,
      1.305215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.569402,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.649532,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070992,
      4,
      1,
      NULL,
      1.164709,
      0.453480,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      0.414395,
      1,
      2.600290,
      2.565240,
      1.966325,
      0.933211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.359667,
      1,
      1.819668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.666969,
      2,
      2.003131,
      NULL,
      1.348913,
      3,
      2,
      1,
      1.857455,
      1.721750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.900522,
      NULL,
      NULL,
      6.965247,
      NULL,
      NULL,
      0.737177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.177892,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.553802,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.106656,
      NULL,
      NULL,
      0.390791,
      3.274098,
      0.789600,
      0.371847,
      0.492934,
      0.154074,
      0,
      NULL,
      NULL,
      3.707982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.381683,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.172505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.558249,
      NULL,
      NULL,
      NULL,
      0,
      1.625098,
      2,
      4,
      0,
      33,
      NULL,
      0,
      NULL,
      NULL,
      0.842716,
      NULL,
      NULL,
      0.222244,
      NULL,
      NULL,
      2.860642,
      7.906130,
      4.032056,
      0,
      NULL,
      NULL,
      0.109640,
      NULL,
      NULL,
      295.956049,
      23,
      1,
      0.661815,
      NULL,
      1,
      1.370327,
      0.541080,
      1,
      1.357451,
      1,
      1,
      1,
      1,
      0.866625,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.411697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      3.285408,
      6,
      25.569323,
      1.226038,
      0.406753,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.253179,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.440470,
      NULL,
      NULL,
      NULL,
      1.327490,
      NULL,
      2.417924,
      NULL,
      0.486708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.366037,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141571,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.360797,
      NULL,
      0.267828,
      NULL,
      0,
      NULL,
      NULL,
      0.413668,
      0,
      NULL,
      1.222971,
      NULL,
      0.866389,
      NULL,
      NULL,
      NULL,
      1.533693,
      NULL,
      NULL,
      NULL,
      1.600702,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.160068,
      NULL,
      0.204530,
      NULL,
      929.769650,
      NULL,
      3.266082,
      NULL,
      1.117857,
      NULL,
      0,
      1,
      3.962212,
      5,
      NULL,
      3,
      1.676279,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0.017153,
      0.249588,
      NULL,
      2,
      7,
      3,
      3.685331,
      1.753369,
      1,
      1,
      NULL,
      1.421887,
      0,
      NULL,
      2.776490,
      0,
      NULL,
      NULL,
      0.337272,
      NULL,
      NULL,
      0.346788,
      NULL,
      0.788551,
      2.253178,
      NULL,
      NULL,
      0,
      NULL,
      0.038623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.384712,
      NULL,
      0.593257,
      1.752464,
      1.655660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175250,
      NULL,
      1,
      NULL,
      0.910273,
      NULL,
      1,
      NULL,
      5,
      1.024683,
      NULL,
      NULL,
      56,
      80,
      1,
      1.413400,
      NULL,
      NULL,
      NULL,
      '11223',
      1,
      '',
      NULL,
      '',
      1,
      '0233',
      NULL,
      '');
commit;
end;
/


