set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015635';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3042240',
      0,
      1,
      3,
      1,
      '2222',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1996',
      0.643770,
      NULL,
      5,
      3.608747,
      NULL,
      NULL,
      11,
      3,
      199,
      104.844916,
      3,
      ' 1-11-1988',
      ' 3-15-1987',
      NULL,
      2,
      0,
      1,
      0.154817,
      0,
      2,
      NULL,
      1.800262,
      0,
      17,
      1,
      11,
      0.024495,
      91.656886,
      NULL,
      1,
      21.671841,
      3,
      0,
      11.341649,
      NULL,
      0,
      1,
      NULL,
      0.017090,
      0.788520,
      0.744235,
      0.815493,
      NULL,
      NULL,
      25,
      8,
      NULL,
      1,
      0.314920,
      2,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.016058,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      4,
      NULL,
      2,
      1,
      NULL,
      5,
      1,
      NULL,
      1,
      8,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      1,
      2,
      3,
      3,
      0,
      5,
      3,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      3,
      2,
      5,
      2,
      3,
      0,
      5,
      NULL,
      0,
      3.108185,
      ' 9- 5-1996',
      73.498823,
      ' 8-21-1981',
      7.335069,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.339011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.313901,
      0.233477,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      0.366315,
      4.041816,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.150455,
      0.337810,
      1,
      1.568838,
      1,
      3.271678,
      1,
      0.487163,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.336377,
      2,
      NULL,
      0,
      3,
      2,
      2,
      0,
      3,
      1,
      3,
      3.135685,
      11.778973,
      2,
      30.402865,
      NULL,
      46.580529,
      11.039948,
      119,
      NULL,
      0.719267,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      10,
      NULL,
      8.277407,
      10.642750,
      6,
      11,
      1,
      1.921261,
      5,
      NULL,
      4.273782,
      0.859190,
      3.619719,
      NULL,
      NULL,
      3,
      3.245068,
      NULL,
      32,
      10,
      NULL,
      5,
      0,
      NULL,
      '01334',
      '33410',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      22,
      86.511108,
      NULL,
      2,
      29,
      2,
      3,
      1,
      1,
      1.665391,
      0.748084,
      1.595780,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.216563,
      1,
      NULL,
      NULL,
      1.663765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.978909,
      NULL,
      NULL,
      NULL,
      0.880902,
      NULL,
      NULL,
      0.876380,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.502457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800820,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.345462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.446763,
      1.249748,
      0,
      NULL,
      1,
      0.688482,
      NULL,
      NULL,
      3.542422,
      5.143022,
      6,
      3,
      2.029351,
      NULL,
      0,
      NULL,
      NULL,
      0.619653,
      0.191175,
      3.669508,
      0.343838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      3.107458,
      0,
      NULL,
      NULL,
      2,
      3,
      0.734852,
      2,
      1.053315,
      3,
      0,
      1,
      0.764084,
      7,
      3.349146,
      NULL,
      2.380507,
      2.731953,
      0.053393,
      NULL,
      NULL,
      0,
      0.726424,
      0.870702,
      0,
      1,
      0,
      3.373353,
      3.213253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1.147478,
      1,
      1,
      0.297169,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.265128,
      NULL,
      NULL,
      1.366003,
      NULL,
      NULL,
      0.553521,
      NULL,
      NULL,
      2,
      0,
      3.430484,
      0,
      NULL,
      3,
      0,
      7,
      NULL,
      1,
      2,
      16.990480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911493,
      NULL,
      NULL,
      NULL,
      1.548460,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150639,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.654688,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.720014,
      NULL,
      NULL,
      0.658701,
      NULL,
      NULL,
      1.370298,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.533535,
      1.649628,
      NULL,
      NULL,
      2.165097,
      1.805322,
      2.578910,
      NULL,
      0,
      NULL,
      3.079793,
      NULL,
      NULL,
      1,
      8.087779,
      NULL,
      5,
      3.532906,
      NULL,
      NULL,
      2.846241,
      3.372293,
      2,
      0,
      0,
      61,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115559,
      NULL,
      NULL,
      NULL,
      18.275511,
      42.485580,
      3.418533,
      3.686905,
      2.023632,
      NULL,
      14.327785,
      0.501048,
      0,
      1.705918,
      1,
      0.509880,
      NULL,
      0,
      0.341782,
      NULL,
      1.484448,
      NULL,
      1.026029,
      0.409646,
      0,
      1.449677,
      0.659750,
      1.031126,
      0.785796,
      NULL,
      0.483676,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4.412707,
      3,
      0.841814,
      3.035923,
      1,
      12.427063,
      NULL,
      2,
      1,
      0.054429,
      0.584244,
      NULL,
      0,
      1,
      1.476877,
      1.589879,
      0,
      1,
      0.745619,
      0.679107,
      NULL,
      0,
      1.989394,
      0.835868,
      0.396926,
      0.945365,
      NULL,
      1.353888,
      0.203438,
      0.321503,
      0,
      1.077417,
      0,
      NULL,
      0.197605,
      0,
      NULL,
      0,
      NULL,
      1,
      1.926757,
      0.109055,
      3,
      3.314818,
      1.936281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037984,
      0.923707,
      0,
      NULL,
      0.428719,
      NULL,
      4,
      4,
      2.212121,
      0,
      3.946455,
      32,
      56.967834,
      1,
      NULL,
      3,
      '32422',
      '10331',
      '',
      NULL,
      '',
      '',
      '',
      1.471495,
      NULL,
      '',
      '');
commit;
end;
/


