set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7712658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0220224',
      1,
      1.598262,
      1,
      3,
      '0444',
      0,
      0,
      NULL,
      NULL,
      ' 7-21-1984',
      NULL,
      NULL,
      0,
      NULL,
      1,
      ' 0-12-1979',
      3,
      0.822970,
      353.269522,
      112,
      NULL,
      ' 6-14-1993',
      ' 4- 6-2000',
      ' 2-28-1995',
      0,
      1.992045,
      1.718790,
      NULL,
      0,
      NULL,
      1,
      1.459588,
      0.281858,
      27,
      NULL,
      16,
      3,
      5.684240,
      8.196476,
      5,
      24,
      NULL,
      0,
      NULL,
      3.755925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      3,
      3,
      3,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      1,
      2,
      2.360073,
      1,
      0.054959,
      NULL,
      3.889233,
      NULL,
      1,
      0.573065,
      0,
      0.141305,
      0,
      1.541263,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      2,
      2,
      1,
      NULL,
      NULL,
      1.828245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      4,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      0,
      1,
      0,
      0,
      0,
      NULL,
      3,
      1,
      1,
      3,
      0,
      1,
      2,
      4,
      5,
      4,
      NULL,
      4,
      0,
      0,
      2.979062,
      '10-27-1984',
      12.480451,
      '11- 6-2003',
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      0,
      1,
      1.325546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.962255,
      3.567489,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.481050,
      0.556219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.826652,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      3,
      3,
      NULL,
      3,
      3,
      2,
      NULL,
      2,
      NULL,
      2.465526,
      0.144287,
      1.061952,
      0.261871,
      0,
      3.684053,
      1.590295,
      2,
      1,
      0,
      NULL,
      0.676411,
      0.448042,
      NULL,
      NULL,
      0.838090,
      2.770928,
      NULL,
      7,
      6,
      7.455702,
      7,
      10.056314,
      0,
      1,
      2,
      4.891050,
      3.099246,
      0,
      NULL,
      50.908982,
      0,
      0,
      NULL,
      43,
      NULL,
      50,
      NULL,
      0.284924,
      3.033433,
      NULL,
      NULL,
      '',
      1.022817,
      '',
      '',
      '',
      1.548036,
      '',
      '',
      '',
      1,
      2,
      49.372762,
      NULL,
      1,
      NULL,
      0,
      7.135316,
      NULL,
      1,
      0.767831,
      2.339170,
      0,
      NULL,
      NULL,
      2.003993,
      0.114188,
      0,
      2,
      0,
      1.442235,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.458702,
      1,
      0.199000,
      3,
      2,
      NULL,
      NULL,
      1.815065,
      NULL,
      3.242629,
      0.163124,
      0.803517,
      1,
      0.135482,
      1.530972,
      NULL,
      0,
      0.739569,
      6,
      7.651909,
      NULL,
      0,
      NULL,
      1.540305,
      3,
      3,
      0.565471,
      0,
      3,
      1.924895,
      1.448806,
      2,
      3.951169,
      1.828980,
      1,
      0.895891,
      NULL,
      1.850170,
      1.669139,
      3.952790,
      3.152688,
      1,
      1.232708,
      2.489284,
      0,
      2.688254,
      NULL,
      1,
      2,
      1.563283,
      3,
      1.540427,
      0,
      1,
      1.628110,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5,
      4,
      1,
      NULL,
      3.078352,
      NULL,
      2,
      0,
      NULL,
      3,
      3.791066,
      1.650785,
      NULL,
      NULL,
      1,
      2,
      1,
      3.129550,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.494317,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      2.262791,
      1,
      0.271353,
      2.279879,
      0.085575,
      0.790688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.842230,
      NULL,
      NULL,
      0.683049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760370,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.066855,
      1.754594,
      NULL,
      3,
      2.180949,
      NULL,
      1,
      1.593014,
      7,
      4,
      NULL,
      NULL,
      1.374447,
      1.025743,
      0.255565,
      0,
      0,
      NULL,
      NULL,
      0,
      9,
      NULL,
      1.045527,
      1,
      3,
      1,
      0,
      NULL,
      0,
      0.156616,
      NULL,
      NULL,
      1,
      1.917512,
      0,
      4.835862,
      2,
      3.691085,
      4.151871,
      1.900819,
      0,
      3,
      3,
      NULL,
      0,
      2,
      0,
      0.534134,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      10,
      27,
      NULL,
      NULL,
      1,
      NULL,
      3.002549,
      0.406494,
      NULL,
      NULL,
      3.139305,
      NULL,
      1.227810,
      NULL,
      NULL,
      3.174074,
      NULL,
      NULL,
      0,
      0.935251,
      NULL,
      1.317187,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0.820300,
      NULL,
      1,
      0.204092,
      NULL,
      3.563604,
      1.359371,
      NULL,
      2.391557,
      10.794576,
      NULL,
      NULL,
      NULL,
      NULL,
      2.413917,
      1,
      NULL,
      3,
      3,
      NULL,
      6,
      5,
      0,
      NULL,
      0.933530,
      54,
      3,
      NULL,
      1.232699,
      NULL,
      NULL,
      NULL,
      1.353352,
      0.229859,
      1.503495,
      NULL,
      1,
      1.844796,
      0.643087,
      NULL,
      0.312766,
      NULL,
      0.873854,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      0,
      1.181528,
      NULL,
      0,
      1,
      0.625041,
      NULL,
      1.654236,
      NULL,
      NULL,
      NULL,
      3.823133,
      0.784793,
      2,
      NULL,
      1.117104,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      0.240032,
      NULL,
      0,
      NULL,
      2,
      1,
      3.457697,
      NULL,
      8.298796,
      1.379981,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834771,
      4,
      1,
      NULL,
      242.902162,
      NULL,
      0,
      10.539727,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      0,
      NULL,
      67,
      27.936766,
      1.925885,
      NULL,
      NULL,
      1,
      NULL,
      1,
      42,
      4,
      0,
      1,
      0.081485,
      2,
      1,
      0.466370,
      1.496855,
      0.164545,
      1,
      1,
      1.124908,
      1,
      0.963670,
      3,
      0,
      0,
      1.704522,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.805810,
      3,
      NULL,
      1.546703,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.600371,
      NULL,
      2.704781,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221435,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.869091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586051,
      0.783053,
      NULL,
      3.934153,
      NULL,
      0.691582,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.763940,
      NULL,
      1.569457,
      NULL,
      0.632830,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512526,
      NULL,
      1,
      NULL,
      0.076296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234753,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.534982,
      2,
      1.602907,
      3,
      1,
      4.565452,
      NULL,
      1.280268,
      1,
      1.974048,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      2.807849,
      0,
      NULL,
      3.738409,
      0,
      0.877897,
      3.043139,
      0.257794,
      1,
      3,
      0,
      0,
      3,
      1,
      3,
      3.310610,
      1.691131,
      NULL,
      1.795450,
      0.576819,
      NULL,
      0,
      1,
      NULL,
      1,
      3.692381,
      2,
      2.063555,
      0,
      NULL,
      0,
      3.016290,
      0,
      2,
      0,
      3.454657,
      1,
      0,
      1.897956,
      1,
      NULL,
      0,
      0.186273,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.158695,
      NULL,
      NULL,
      1,
      16.608357,
      0.458058,
      14.389675,
      3,
      NULL,
      3.753634,
      3.852947,
      2.988630,
      0,
      0.987893,
      3.453056,
      3,
      2,
      NULL,
      2.876299,
      3,
      0.383578,
      NULL,
      2.659577,
      2.762094,
      2.290796,
      1.835573,
      NULL,
      0.515863,
      1,
      NULL,
      0,
      1,
      3.917762,
      2,
      NULL,
      3,
      NULL,
      0,
      0.410381,
      1.142941,
      NULL,
      1,
      1.558671,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      57.784501,
      75,
      2,
      NULL,
      3.240476,
      '20112',
      '32044',
      NULL,
      0,
      NULL,
      '',
      '',
      1.784323,
      NULL,
      '',
      '');
commit;
end;
/


