set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      0.939806,
      NULL,
      1,
      1,
      '1222',
      1,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1984',
      NULL,
      NULL,
      2,
      2,
      0.952007,
      ' 3-25-1979',
      50,
      2,
      95.510051,
      5.613614,
      0,
      ' 4- 1-1994',
      ' 5- 5-2002',
      ' 3-12-1998',
      1,
      NULL,
      0.799311,
      1.409843,
      1.327561,
      2,
      3,
      0.742241,
      1,
      64,
      NULL,
      1,
      2.580642,
      10.128857,
      18.396358,
      2,
      6,
      NULL,
      2,
      6.956401,
      0,
      0,
      1,
      0,
      0.847184,
      1,
      NULL,
      5,
      0,
      1.133309,
      0.150615,
      0,
      3,
      0,
      1.936582,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      2,
      2,
      NULL,
      2,
      2,
      0,
      8.270146,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.947451,
      NULL,
      NULL,
      2,
      1,
      0.598516,
      3,
      0,
      3.063208,
      3,
      0.805592,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      2.378039,
      0,
      0.377424,
      NULL,
      NULL,
      0,
      9.674338,
      1,
      NULL,
      1.153597,
      NULL,
      NULL,
      NULL,
      0.219056,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      4,
      3,
      0,
      NULL,
      4,
      1,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      0.493832,
      NULL,
      0.923648,
      2,
      4,
      0,
      1,
      0,
      2,
      3,
      3,
      2,
      1,
      NULL,
      2,
      2,
      3,
      0,
      5,
      4,
      4,
      3,
      2,
      NULL,
      5,
      4,
      NULL,
      5,
      7,
      NULL,
      ' 0- 1-1986',
      NULL,
      ' 5- 8-1989',
      498,
      2,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0.343773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3.224027,
      3.545944,
      2,
      NULL,
      0,
      5,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.058498,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928138,
      1.381583,
      0,
      0.093458,
      1,
      1.183257,
      0,
      0,
      NULL,
      2.151718,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.022845,
      3,
      2,
      0,
      3,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.191620,
      0.293083,
      0,
      NULL,
      0,
      1.407599,
      1.065504,
      NULL,
      0.770430,
      1.317654,
      NULL,
      1,
      1.354970,
      0.603479,
      1,
      1.697637,
      0.105657,
      0,
      NULL,
      NULL,
      7,
      NULL,
      2.078983,
      0.222376,
      2,
      NULL,
      0.135975,
      2,
      0.706192,
      2.020809,
      61,
      3,
      0,
      NULL,
      25,
      NULL,
      18.688032,
      3,
      NULL,
      0.901792,
      '03431',
      '00330',
      '',
      0.221823,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      85,
      26.536588,
      1,
      0,
      10,
      NULL,
      2,
      1.398965,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      1.521016,
      NULL,
      NULL,
      NULL,
      1.865779,
      3.780954,
      1,
      NULL,
      NULL,
      1.173659,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.596075,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.530094,
      NULL,
      NULL,
      0.996468,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      1.123576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054171,
      2,
      2.356957,
      1,
      NULL,
      NULL,
      1.336635,
      NULL,
      NULL,
      NULL,
      0.673894,
      3.362729,
      3,
      0,
      1.966912,
      3.135411,
      3.919147,
      1,
      1.937018,
      0.480714,
      1.018086,
      0.669518,
      3.884694,
      1.255434,
      0.100639,
      1.882959,
      NULL,
      NULL,
      2.327586,
      1.594165,
      0,
      NULL,
      1,
      0.678287,
      10,
      3.222759,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.045019,
      1.646884,
      0.016184,
      0.728459,
      NULL,
      NULL,
      1.835080,
      1.123704,
      0,
      2.884838,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.118878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.754563,
      0.425985,
      0,
      0.612196,
      1,
      5,
      0,
      4.560918,
      8.970410,
      8.237362,
      NULL,
      4,
      7,
      4.877376,
      1.731188,
      2,
      3,
      0,
      2,
      0.982355,
      3,
      NULL,
      1,
      4.724654,
      1,
      9.685637,
      NULL,
      3,
      1,
      0.398278,
      0.541935,
      3,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.877492,
      NULL,
      3.683065,
      9.629543,
      3,
      4,
      NULL,
      1,
      0,
      3,
      0.586279,
      1.581424,
      0,
      0.962696,
      1.854818,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816835,
      NULL,
      NULL,
      0.760246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.982939,
      NULL,
      NULL,
      0.233415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.615640,
      0,
      0.218317,
      0.774508,
      1,
      3.677424,
      1,
      NULL,
      NULL,
      2.998613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798679,
      NULL,
      NULL,
      NULL,
      1.244003,
      NULL,
      NULL,
      NULL,
      0.550681,
      NULL,
      NULL,
      NULL,
      3.179056,
      NULL,
      NULL,
      NULL,
      0.411877,
      NULL,
      NULL,
      NULL,
      1.788055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744674,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.052993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.307433,
      NULL,
      NULL,
      NULL,
      2.381470,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3.551856,
      NULL,
      NULL,
      0,
      NULL,
      95,
      1,
      0.262489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.636840,
      3.024571,
      5.420736,
      1.530559,
      NULL,
      NULL,
      1.397115,
      NULL,
      NULL,
      0.418758,
      NULL,
      1,
      24,
      9,
      0.871841,
      1,
      0.571875,
      0,
      3,
      0,
      1,
      0.227462,
      1,
      1,
      0,
      0,
      0,
      0.689259,
      0.501539,
      0,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.696904,
      NULL,
      0,
      NULL,
      27.774934,
      NULL,
      2,
      NULL,
      21,
      NULL,
      0.268388,
      2,
      4,
      0,
      NULL,
      0.598778,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.302437,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2.731568,
      0.231267,
      6.115574,
      NULL,
      0,
      14.530413,
      2,
      1,
      1.662751,
      1.749797,
      1,
      NULL,
      1.980769,
      1.223660,
      NULL,
      1,
      0.631723,
      NULL,
      0.909791,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.537444,
      1,
      NULL,
      0.551335,
      2,
      NULL,
      3,
      2.914091,
      NULL,
      1,
      0.706678,
      NULL,
      NULL,
      0.002342,
      NULL,
      1,
      0.946672,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595122,
      NULL,
      0,
      NULL,
      1.793182,
      NULL,
      2,
      4,
      0,
      1,
      0,
      1,
      65,
      77,
      2,
      1.555997,
      5,
      '20323',
      '14333',
      '',
      0.008904,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


