set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      '1334',
      3.026912,
      0,
      0.350047,
      22.822361,
      ' 2-26-1979',
      117.658942,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-14-2003',
      17,
      1,
      143.179706,
      88.309156,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1977',
      3,
      NULL,
      0.288288,
      0.759892,
      NULL,
      3,
      3,
      NULL,
      0,
      110.818288,
      5,
      NULL,
      NULL,
      15.125039,
      NULL,
      2,
      NULL,
      0,
      3,
      5,
      1.966792,
      NULL,
      NULL,
      0.993865,
      1,
      NULL,
      1,
      3.467406,
      1.307265,
      1,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      1,
      1,
      5,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.756668,
      NULL,
      0,
      0,
      0.531955,
      NULL,
      NULL,
      3.630920,
      0,
      0.078495,
      1.949118,
      NULL,
      1.984512,
      NULL,
      3,
      1,
      0.488381,
      NULL,
      0,
      NULL,
      0.373781,
      0,
      NULL,
      0.263090,
      0.891085,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      3,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1.010122,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      4,
      4,
      NULL,
      1,
      3,
      3,
      1,
      5,
      2,
      1,
      1,
      0,
      4,
      NULL,
      2,
      2,
      2,
      5,
      3.802425,
      0,
      '11- 9-1981',
      1160,
      ' 6-28-2000',
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.730944,
      0.771099,
      0.593290,
      NULL,
      0.651104,
      0,
      NULL,
      NULL,
      NULL,
      1.682854,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.574050,
      1,
      NULL,
      NULL,
      0.147276,
      NULL,
      0.648778,
      NULL,
      1,
      1.391349,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.268770,
      0,
      2,
      3,
      2,
      0,
      2,
      3,
      3,
      NULL,
      3,
      2.535840,
      2.472296,
      0,
      4,
      0.955248,
      1,
      3.375199,
      1.742473,
      0.178889,
      0,
      0.202716,
      1.699291,
      0,
      1.137629,
      1.621984,
      1,
      0.964106,
      3,
      1,
      9,
      7.924672,
      1.207331,
      5.251064,
      0,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      0.534079,
      23,
      0,
      0.651372,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      '33200',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.118526,
      34.201061,
      148,
      7,
      NULL,
      29.016246,
      2,
      4,
      2,
      3,
      0.061289,
      2,
      2.720238,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      NULL,
      3.778292,
      1.609147,
      1.360275,
      1,
      NULL,
      NULL,
      0.366937,
      3,
      3,
      1,
      NULL,
      NULL,
      3.167817,
      0.122125,
      1.290087,
      3.793725,
      2,
      0.662467,
      1.594222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.352680,
      4.085730,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.031907,
      NULL,
      NULL,
      NULL,
      1.613990,
      0.958921,
      2.172142,
      NULL,
      NULL,
      0,
      0.392956,
      NULL,
      NULL,
      3,
      0,
      1.673180,
      3,
      2,
      3.428804,
      0.677646,
      3,
      NULL,
      3.752083,
      1.189639,
      3,
      2.526431,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.237192,
      0.871662,
      0.687379,
      0,
      1.316182,
      0,
      4,
      NULL,
      4,
      NULL,
      1.074220,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.654180,
      NULL,
      NULL,
      NULL,
      0.837491,
      NULL,
      3,
      NULL,
      1.849341,
      NULL,
      NULL,
      NULL,
      2.069542,
      0.383645,
      1.587106,
      0,
      2,
      3.355530,
      1.482922,
      NULL,
      NULL,
      5,
      NULL,
      0.833662,
      0.272931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.463179,
      NULL,
      NULL,
      1.373684,
      NULL,
      NULL,
      1.801934,
      NULL,
      NULL,
      1.757524,
      NULL,
      NULL,
      2.624621,
      1,
      1.738054,
      4,
      1.310303,
      0,
      NULL,
      5.036854,
      4.487507,
      2,
      NULL,
      4.754094,
      0.695634,
      NULL,
      NULL,
      2,
      3.988610,
      1,
      0,
      2.147537,
      2.430898,
      2.018446,
      2,
      2,
      3.286153,
      1.387545,
      3.061364,
      0,
      2,
      0.749345,
      2.987686,
      2.234272,
      1,
      2.923940,
      NULL,
      3.564546,
      9.146160,
      7.575507,
      7.936924,
      9.093136,
      1.556169,
      3.578087,
      0,
      2,
      0,
      0.962667,
      1,
      1,
      0.908408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.186865,
      NULL,
      NULL,
      0.515315,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.034174,
      0.864627,
      NULL,
      1,
      3.721186,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.077509,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.442681,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.520906,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123046,
      1,
      NULL,
      NULL,
      1.292843,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.562659,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708092,
      NULL,
      NULL,
      NULL,
      1.874834,
      NULL,
      NULL,
      1,
      0.979918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3.111267,
      147.665610,
      109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.351465,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.225847,
      247,
      6,
      0.701835,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.529960,
      3.321914,
      0.376736,
      1.045773,
      1,
      0.459049,
      1.612895,
      1,
      0.001372,
      1.872766,
      NULL,
      3.259410,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.170821,
      NULL,
      3.772895,
      NULL,
      1,
      NULL,
      0.680991,
      NULL,
      5.393377,
      13,
      54,
      0,
      0.445995,
      3,
      NULL,
      0.687011,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.671484,
      NULL,
      1.555438,
      NULL,
      3.110894,
      NULL,
      NULL,
      NULL,
      0.128321,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.643587,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.200675,
      NULL,
      3.503319,
      NULL,
      0.335134,
      NULL,
      0,
      NULL,
      1.248471,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944979,
      3.798532,
      NULL,
      2.842624,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0.633361,
      0,
      14,
      6.923487,
      0.616633,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.961063,
      NULL,
      NULL,
      2.499781,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      3.293575,
      1,
      2,
      0,
      1,
      NULL,
      3,
      3.942837,
      1,
      NULL,
      3,
      2.911725,
      3,
      NULL,
      0,
      0,
      1,
      0,
      2.052860,
      2,
      0.673796,
      3,
      1,
      0.380228,
      0,
      0,
      2.121294,
      2,
      NULL,
      3,
      0,
      1,
      3,
      0,
      0.869759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345276,
      1,
      NULL,
      0,
      NULL,
      0.631323,
      0,
      1,
      7,
      NULL,
      0.966854,
      3,
      33,
      37.658664,
      4,
      NULL,
      1,
      '00004',
      '20430',
      '02443',
      2,
      '01144',
      '',
      '',
      NULL,
      NULL,
      '134',
      '231');
commit;
end;
/


