set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1341221',
      3,
      1,
      5,
      2,
      '2123',
      0,
      0.451361,
      NULL,
      NULL,
      ' 4-10-1990',
      8.411081,
      NULL,
      3,
      0,
      5,
      ' 1- 1-1998',
      22,
      0.388586,
      62,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 6-1985',
      0.476552,
      0,
      NULL,
      1,
      1.642264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      24,
      6,
      3,
      13.867223,
      1,
      2,
      1.706893,
      0,
      3,
      1,
      0,
      1,
      0.559369,
      0.588785,
      NULL,
      NULL,
      0.626379,
      0,
      2,
      4,
      2,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.817965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.916630,
      0.438460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0.980215,
      NULL,
      1.165296,
      1,
      NULL,
      1,
      0,
      4,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      3,
      3,
      2,
      0.740287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1721.820886,
      0.754633,
      1,
      0,
      NULL,
      1.030015,
      0.513130,
      1.458746,
      0,
      NULL,
      1,
      1.929710,
      3,
      0,
      NULL,
      NULL,
      0.997522,
      0.406158,
      0,
      0.579410,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.479765,
      1.959931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185231,
      1.449601,
      1,
      1,
      1.200043,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      0,
      0,
      1,
      1,
      1.356650,
      3.832039,
      NULL,
      1.244789,
      0.647694,
      6,
      1,
      NULL,
      1.700305,
      NULL,
      0.641232,
      0,
      1,
      1.803239,
      1,
      1,
      2,
      1.266939,
      1,
      NULL,
      5.998877,
      9,
      9,
      5,
      NULL,
      1,
      2.636345,
      2,
      NULL,
      1.394994,
      66,
      NULL,
      0.427151,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.612860,
      0.950647,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      6.965651,
      16.202791,
      27.864258,
      3,
      26.388928,
      4.675752,
      9,
      2,
      NULL,
      2.749552,
      0.716331,
      1.966581,
      NULL,
      NULL,
      0.512360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      0.454963,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.800688,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279828,
      NULL,
      NULL,
      NULL,
      2,
      3.343077,
      1,
      1.354032,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235639,
      2.096205,
      NULL,
      0,
      1,
      NULL,
      3.354764,
      0.944811,
      3.297695,
      3,
      NULL,
      NULL,
      0.104639,
      0.310987,
      2.477129,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.991421,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.052230,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.214801,
      0,
      2.748957,
      3.254313,
      1.765982,
      1,
      NULL,
      NULL,
      NULL,
      3.337177,
      1.064224,
      0.684831,
      1.631600,
      0.074644,
      NULL,
      NULL,
      NULL,
      1.940748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952945,
      1.661109,
      1,
      1.971077,
      1,
      1.063828,
      1.231717,
      NULL,
      9,
      NULL,
      0.133448,
      2.687332,
      6.044283,
      NULL,
      NULL,
      NULL,
      2,
      0.042766,
      NULL,
      0.288483,
      2,
      3,
      1.892670,
      NULL,
      NULL,
      NULL,
      6.085369,
      0.798806,
      1.447479,
      0.019992,
      2,
      0.548843,
      2,
      2,
      1,
      1.210801,
      2.912868,
      NULL,
      0.306610,
      3,
      2.219034,
      5.168991,
      5.728921,
      0.288085,
      9.379224,
      2.884221,
      1,
      NULL,
      1,
      2,
      1.918958,
      0.468515,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      0.293388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.443464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.527853,
      NULL,
      NULL,
      0.149151,
      1.507298,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.205889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587571,
      1.035494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.163071,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.287810,
      NULL,
      NULL,
      NULL,
      1.825373,
      0.661824,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.387189,
      NULL,
      NULL,
      NULL,
      1.803255,
      NULL,
      NULL,
      NULL,
      1.244198,
      1.869038,
      NULL,
      NULL,
      1.588320,
      0,
      NULL,
      NULL,
      0.006042,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811465,
      NULL,
      NULL,
      0.642509,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      65.109609,
      3.295263,
      549,
      900,
      1.094782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.957989,
      NULL,
      NULL,
      0.510151,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.317734,
      NULL,
      1.309070,
      NULL,
      1,
      NULL,
      1.195148,
      0,
      0.738446,
      1,
      NULL,
      0,
      1.214979,
      0.027065,
      0,
      1.112182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      2.741326,
      NULL,
      3,
      5,
      NULL,
      17.933464,
      3.601873,
      0.503696,
      3.267811,
      8.606085,
      16,
      1.897594,
      19.505123,
      NULL,
      3.940453,
      12.129980,
      5.483129,
      0.688478,
      NULL,
      10,
      0.120448,
      4,
      18,
      NULL,
      4,
      14,
      0.206695,
      18,
      12.576570,
      0,
      19,
      19,
      0,
      13.060737,
      NULL,
      1.176253,
      18,
      3.968977,
      0.321687,
      NULL,
      5,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347630,
      NULL,
      1.595839,
      0,
      NULL,
      0,
      3,
      3,
      NULL,
      1.002417,
      0.436946,
      3.755476,
      100,
      16,
      1,
      0,
      3.683383,
      '23210',
      NULL,
      '',
      1.623400,
      '',
      '',
      '',
      1.105580,
      NULL,
      '',
      '');
commit;
end;
/


