set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4310023',
      5.983294,
      0.770549,
      0,
      NULL,
      '4040',
      1.638436,
      0,
      NULL,
      NULL,
      ' 1-21-1989',
      3,
      NULL,
      NULL,
      0.182388,
      0.692440,
      ' 3-10-1997',
      47.872217,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 6-19-1987',
      3,
      1.446443,
      1.607510,
      NULL,
      1,
      0.131435,
      3,
      2,
      NULL,
      NULL,
      NULL,
      6.183722,
      2.157931,
      116.080899,
      148.261350,
      NULL,
      4,
      3,
      0,
      2.700898,
      0.933462,
      2,
      0,
      1,
      NULL,
      1,
      0,
      1.255434,
      1,
      0,
      0.144704,
      2,
      2,
      3,
      1.016777,
      2,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      5,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.840206,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.752795,
      0.463751,
      0.651818,
      2.168265,
      NULL,
      3,
      0,
      3.164419,
      2.331809,
      0.369548,
      1.115934,
      1,
      1.289297,
      0.409848,
      NULL,
      1,
      1,
      0,
      0,
      5,
      1,
      1,
      1.716133,
      0,
      NULL,
      NULL,
      1.666575,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      3,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      2,
      0,
      4,
      0,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      0,
      ' 6- 4-1989',
      143.573030,
      ' 0- 9-1986',
      2.307323,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1.435590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.503057,
      2,
      NULL,
      0.503639,
      0,
      5.625821,
      0,
      NULL,
      NULL,
      1.804782,
      0.891544,
      NULL,
      NULL,
      NULL,
      0,
      1.432906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667634,
      1,
      1.289886,
      1,
      1,
      NULL,
      NULL,
      0.218116,
      NULL,
      1,
      0.985691,
      NULL,
      NULL,
      NULL,
      0,
      0.807343,
      0,
      NULL,
      3,
      3,
      3,
      NULL,
      1,
      3,
      2,
      NULL,
      3,
      0,
      2.635800,
      0.546416,
      2,
      NULL,
      1,
      2,
      1.091341,
      1,
      0,
      1.665107,
      1,
      1.136767,
      NULL,
      0,
      0,
      1,
      0.782491,
      1.994168,
      3.340760,
      NULL,
      4.834910,
      3.075575,
      NULL,
      1,
      4,
      3.583429,
      NULL,
      1,
      0,
      1,
      24,
      2,
      0,
      70,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      '43341',
      '',
      NULL,
      1.573394,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      2.235806,
      10,
      54,
      NULL,
      NULL,
      3.513634,
      0,
      3.592519,
      2,
      0,
      3.930806,
      1,
      0.841159,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.669298,
      1.256189,
      0.693795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.481060,
      NULL,
      NULL,
      0,
      1.588170,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.428563,
      NULL,
      NULL,
      NULL,
      2.958677,
      1,
      NULL,
      0.312034,
      NULL,
      NULL,
      3.267525,
      NULL,
      0.688237,
      NULL,
      1.662286,
      1,
      3.979191,
      0,
      0.501106,
      NULL,
      0,
      2,
      NULL,
      0.798246,
      0.082864,
      1,
      NULL,
      0.693622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.547537,
      1,
      1.149705,
      NULL,
      NULL,
      NULL,
      1.320157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.015864,
      0.993769,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      4,
      NULL,
      3,
      1,
      1.140235,
      1,
      NULL,
      NULL,
      5.260516,
      3.204680,
      0,
      0.845422,
      2.651935,
      1.990463,
      0.366622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019245,
      4.941861,
      NULL,
      NULL,
      1.723504,
      1.996290,
      2.797340,
      3,
      1,
      6.642546,
      NULL,
      1,
      3.764887,
      NULL,
      1,
      6.243776,
      6.838942,
      NULL,
      2,
      3.714527,
      0,
      NULL,
      0.113403,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5.963106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.145149,
      1.352536,
      0.969691,
      2,
      2.754641,
      3.540333,
      6,
      1.640393,
      5,
      9.104453,
      7.470513,
      1,
      2.074678,
      3,
      2,
      0.434108,
      0.871193,
      0.345097,
      NULL,
      1,
      2.559293,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121753,
      NULL,
      NULL,
      1.413468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.877977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.613401,
      0.352719,
      0.190700,
      1.777189,
      0.605874,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824308,
      1.945159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908663,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.279168,
      0.947492,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.924938,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.244087,
      0.028519,
      NULL,
      NULL,
      1.752484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      0.504211,
      1281,
      1741,
      0,
      NULL,
      NULL,
      1.996184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266674,
      NULL,
      NULL,
      3967.050673,
      NULL,
      1.858205,
      NULL,
      1.956881,
      0,
      1,
      1,
      1,
      1.633123,
      NULL,
      0,
      1,
      1.016663,
      0,
      1.837403,
      0,
      0,
      0,
      0.979384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      2.906147,
      0.436619,
      NULL,
      3.398979,
      2,
      14,
      0,
      0,
      1,
      4.610930,
      16,
      1,
      NULL,
      0,
      1,
      13,
      10.241681,
      0.772901,
      9,
      NULL,
      0,
      1,
      5,
      NULL,
      17,
      15,
      NULL,
      15,
      NULL,
      NULL,
      18,
      12,
      1,
      9.925050,
      2.882206,
      0,
      13,
      11,
      3,
      NULL,
      6.630473,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468604,
      0,
      NULL,
      1.460202,
      NULL,
      1.567098,
      NULL,
      2,
      3,
      3.260687,
      0.835116,
      2.821129,
      NULL,
      25.728715,
      5,
      1.781501,
      0.741178,
      '21112',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


