set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '1442',
      1.393135,
      NULL,
      NULL,
      NULL,
      ' 6-17-1978',
      66.771361,
      NULL,
      NULL,
      0.388571,
      0,
      '10- 2-1985',
      45.711881,
      2,
      205,
      7.649793,
      NULL,
      ' 4-16-1975',
      ' 1-12-1987',
      NULL,
      NULL,
      0,
      2.945963,
      2,
      0.428671,
      1.222351,
      2,
      0.250733,
      0.251240,
      9,
      1,
      7,
      4,
      7,
      NULL,
      4,
      NULL,
      0,
      1,
      5.835913,
      0.139311,
      0,
      NULL,
      NULL,
      NULL,
      1.935519,
      0.197868,
      0.515338,
      1.693102,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      5,
      4,
      4,
      0,
      5,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.710963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.068643,
      1,
      2,
      2.193312,
      2,
      1.669640,
      2.805406,
      1,
      NULL,
      0,
      1,
      3.364532,
      1.836458,
      3,
      NULL,
      0,
      1.087228,
      1,
      0,
      NULL,
      4,
      1,
      NULL,
      3,
      1.321224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      3,
      1,
      2,
      1,
      0,
      1,
      1,
      0,
      0,
      6,
      0,
      1,
      NULL,
      0,
      0.416799,
      NULL,
      1.873516,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      4,
      4,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      2,
      0,
      5,
      3,
      1,
      2,
      3,
      NULL,
      2,
      0.511825,
      1.722621,
      NULL,
      391,
      NULL,
      419.328845,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1.913363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.197147,
      NULL,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.579879,
      1.028158,
      1.163098,
      0.496709,
      NULL,
      3,
      4.791710,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.889339,
      1,
      NULL,
      0,
      2,
      0,
      2,
      0,
      0,
      2,
      NULL,
      3,
      1,
      2,
      3.049181,
      1,
      0,
      3,
      0.164968,
      NULL,
      0,
      0.526545,
      0.475613,
      0.560028,
      1.687003,
      0.756061,
      NULL,
      0,
      0.297264,
      4,
      NULL,
      9.223800,
      NULL,
      1.356174,
      9.504269,
      5.349378,
      NULL,
      NULL,
      3.481572,
      2.062088,
      3,
      1.154992,
      2,
      41.688488,
      1,
      0.956474,
      NULL,
      NULL,
      65,
      NULL,
      1,
      0.812497,
      2,
      '14234',
      '',
      NULL,
      1.257694,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      69.707454,
      40.840509,
      2.706093,
      34.974503,
      5,
      0.072979,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.285057,
      3.657061,
      NULL,
      NULL,
      NULL,
      3.116854,
      0.884053,
      2,
      3,
      0.801133,
      0.770351,
      1.774809,
      1.798041,
      0.162646,
      1.283774,
      NULL,
      NULL,
      3.658724,
      1,
      1.109858,
      0.420365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901019,
      NULL,
      NULL,
      6,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.582612,
      3,
      1.173006,
      NULL,
      NULL,
      1.521283,
      NULL,
      NULL,
      1,
      2.048007,
      0,
      NULL,
      1.509787,
      1.326990,
      0.442412,
      NULL,
      NULL,
      0,
      1.056020,
      1.550422,
      3.618013,
      0.825007,
      NULL,
      2.150437,
      NULL,
      NULL,
      NULL,
      3,
      3.869566,
      0,
      0.818856,
      NULL,
      NULL,
      2.288650,
      5,
      2,
      NULL,
      0.206779,
      NULL,
      NULL,
      NULL,
      1.523146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.406583,
      NULL,
      1.191705,
      1,
      0.870264,
      NULL,
      1.265787,
      2.480920,
      3.133553,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      5.538904,
      6.673960,
      0.283362,
      0.437722,
      NULL,
      NULL,
      0.814472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103485,
      NULL,
      NULL,
      1.352692,
      NULL,
      NULL,
      1.759523,
      NULL,
      NULL,
      NULL,
      3.299518,
      2,
      1.116053,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.725138,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.699871,
      1.658436,
      0.637292,
      2.708223,
      NULL,
      3,
      1.309010,
      3.928553,
      4,
      NULL,
      3.738183,
      1.623737,
      1.470929,
      1,
      NULL,
      3.420989,
      2.908573,
      2.976440,
      0.269385,
      2,
      1,
      0,
      NULL,
      0,
      2.421335,
      3.666559,
      NULL,
      4.338005,
      NULL,
      4,
      2,
      NULL,
      1.073009,
      1.128514,
      NULL,
      1,
      3.466457,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.511665,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      5.487045,
      NULL,
      NULL,
      NULL,
      3.651450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811142,
      NULL,
      NULL,
      NULL,
      2.314614,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.094694,
      NULL,
      NULL,
      NULL,
      0.202218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.710741,
      NULL,
      NULL,
      NULL,
      1.627324,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.304750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.189469,
      NULL,
      NULL,
      NULL,
      2.210513,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      29.539195,
      0,
      NULL,
      34,
      0,
      0.803592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.492013,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359159,
      NULL,
      NULL,
      0.237132,
      0.118364,
      0,
      0,
      1.861749,
      1,
      0.603723,
      0.558134,
      NULL,
      0.207109,
      NULL,
      0.938960,
      0,
      1.778926,
      0,
      0.964839,
      1.747522,
      1.548660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      4,
      2.778314,
      1,
      10,
      3,
      1.510266,
      NULL,
      0,
      0.989699,
      NULL,
      2.733078,
      NULL,
      NULL,
      2.540609,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.243581,
      0.119022,
      NULL,
      NULL,
      0,
      NULL,
      2.746904,
      3,
      NULL,
      3.128149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.309984,
      0.801365,
      NULL,
      2,
      1.342126,
      0.135984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.567124,
      NULL,
      1.338073,
      NULL,
      1,
      NULL,
      0.870480,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.104149,
      NULL,
      1,
      NULL,
      1.474329,
      NULL,
      1.839615,
      NULL,
      NULL,
      NULL,
      17.422316,
      0.193108,
      NULL,
      0.976838,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5,
      2.974806,
      0.051867,
      1,
      26,
      61.075481,
      2,
      1,
      3.359597,
      '00231',
      '',
      '',
      1,
      '',
      '',
      '',
      1.905506,
      '',
      '',
      NULL);
commit;
end;
/


