set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4143314',
      1.116681,
      NULL,
      3,
      1,
      '0140',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      1,
      2,
      2,
      ' 8-11-2003',
      2.544882,
      3.433852,
      217,
      77.869082,
      1,
      ' 4- 6-1985',
      ' 6- 5-1991',
      ' 2- 5-1989',
      3.409556,
      0,
      3,
      2,
      0.810477,
      0.974129,
      2,
      0.456260,
      NULL,
      4,
      6,
      13,
      1,
      4,
      NULL,
      3,
      6.890388,
      0,
      0,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.125712,
      0.603911,
      0.418323,
      0,
      0.421094,
      1,
      5,
      2,
      3.131328,
      1,
      1,
      4,
      NULL,
      0,
      2,
      4,
      0,
      2,
      NULL,
      NULL,
      1,
      1.985833,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      0,
      NULL,
      0,
      2,
      0.488816,
      0,
      2.540671,
      NULL,
      1.866907,
      3,
      0,
      NULL,
      0,
      1,
      1.005245,
      0,
      1,
      0,
      0.050466,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      4,
      NULL,
      1,
      0,
      0,
      4,
      0,
      1,
      NULL,
      8.461599,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      4,
      3,
      3,
      5,
      NULL,
      0,
      1,
      1,
      5,
      NULL,
      1,
      0,
      2,
      4,
      4,
      NULL,
      3,
      0,
      4.746202,
      0.007410,
      NULL,
      407.055552,
      '10-21-1983',
      456.768148,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.217094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.848381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      11.485558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.489973,
      0.876093,
      1,
      NULL,
      1.526183,
      2,
      81.158383,
      NULL,
      0.542606,
      NULL,
      NULL,
      NULL,
      2,
      0.607722,
      2.025230,
      2,
      2,
      3,
      1,
      0,
      2,
      1,
      0,
      2,
      3,
      3,
      2,
      3,
      3.835430,
      1.904613,
      0,
      1.960315,
      0,
      1,
      1.696530,
      1,
      NULL,
      0.902475,
      1,
      NULL,
      0,
      1.649859,
      4,
      0,
      NULL,
      11.589289,
      NULL,
      8,
      NULL,
      4.617716,
      5.460757,
      1,
      6,
      NULL,
      2.830610,
      NULL,
      71,
      3,
      NULL,
      NULL,
      75,
      20,
      45.003905,
      2,
      1,
      1.116809,
      '12314',
      NULL,
      NULL,
      0.390484,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      3,
      NULL,
      42.674163,
      41,
      3.448082,
      20.074564,
      1.464663,
      NULL,
      3,
      0.249678,
      NULL,
      NULL,
      1.217293,
      NULL,
      NULL,
      NULL,
      1,
      3.733444,
      NULL,
      NULL,
      NULL,
      2.648723,
      3,
      0.235099,
      1.271607,
      NULL,
      NULL,
      0.738268,
      NULL,
      NULL,
      0.720086,
      NULL,
      NULL,
      0,
      NULL,
      0.034715,
      1.296922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.021712,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.974944,
      3,
      2.516535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.892358,
      1,
      3.609014,
      1.600429,
      1,
      0.272921,
      0.037713,
      1.269244,
      0,
      1.694028,
      2,
      3.305262,
      NULL,
      1.042156,
      0.737819,
      3,
      1,
      1.071718,
      NULL,
      NULL,
      3.705228,
      5,
      0.966130,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2.592724,
      1.438394,
      3,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.309650,
      3.135932,
      1,
      0.459844,
      NULL,
      NULL,
      1.845403,
      NULL,
      NULL,
      0.575559,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.647008,
      NULL,
      NULL,
      3,
      0.520091,
      2.539367,
      1.158752,
      NULL,
      NULL,
      0,
      0,
      1.465622,
      3,
      3.866853,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.009546,
      1.341244,
      NULL,
      0,
      NULL,
      1.631169,
      3.828483,
      3.143044,
      5,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      3,
      1,
      1.751656,
      1.096651,
      0.887779,
      0,
      2.388650,
      NULL,
      7.179287,
      8,
      6,
      7.808635,
      0,
      4,
      2,
      4,
      1,
      0.743410,
      1,
      0.845487,
      NULL,
      0,
      0.823189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.049768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.638346,
      NULL,
      1,
      1.973522,
      0,
      1.172720,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      4.960890,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.365654,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.797618,
      NULL,
      NULL,
      NULL,
      0.970893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.051218,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      3,
      35,
      14,
      0.675501,
      NULL,
      1.482806,
      0,
      NULL,
      NULL,
      0.353736,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.252609,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      25.617784,
      1.042035,
      1,
      1.786071,
      1.117145,
      1.970505,
      0,
      1,
      1.482313,
      1,
      1,
      0,
      NULL,
      1,
      1.084490,
      0,
      NULL,
      0.783321,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6,
      0.110026,
      1.104090,
      1,
      3,
      4,
      0.642266,
      1,
      NULL,
      1.661777,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.351907,
      0.464222,
      NULL,
      0.446884,
      1,
      NULL,
      0.116572,
      NULL,
      NULL,
      1.084129,
      1.658888,
      NULL,
      3.223709,
      NULL,
      NULL,
      2.640995,
      1.038570,
      NULL,
      1.435022,
      1.333265,
      NULL,
      1.520661,
      NULL,
      NULL,
      0,
      0.230864,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.163879,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.305363,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.329112,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.629809,
      1.208502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      7,
      3.324030,
      1,
      3.526458,
      53,
      28.336077,
      NULL,
      0,
      0.412400,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


