set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '4134034',
      0.992220,
      1.109083,
      3,
      1,
      NULL,
      0,
      0.337784,
      NULL,
      NULL,
      ' 0-28-1989',
      43.844720,
      NULL,
      2,
      3.130046,
      3.414233,
      NULL,
      46.527693,
      NULL,
      230.827163,
      54,
      NULL,
      ' 7-16-1989',
      ' 4-14-1985',
      ' 1-18-1987',
      0.161156,
      1,
      2,
      3.801277,
      1.922075,
      1.122960,
      3,
      1.670623,
      0.960473,
      8.731852,
      8,
      12.860558,
      4.373189,
      NULL,
      25,
      NULL,
      24,
      NULL,
      0,
      6,
      NULL,
      3,
      0,
      1,
      1.441745,
      1,
      0,
      1.196293,
      NULL,
      0,
      0,
      NULL,
      2,
      3,
      0.996040,
      0,
      0,
      2,
      0,
      1,
      3,
      2,
      0,
      0,
      1,
      0,
      0,
      0.119815,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.958597,
      0.425500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      3,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0.390559,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      2,
      0,
      NULL,
      3,
      1,
      4,
      3,
      0,
      1,
      3,
      0,
      2,
      2,
      3,
      NULL,
      1,
      0,
      NULL,
      2.184096,
      2.168764,
      ' 2-29-1990',
      441.213409,
      ' 2- 8-1998',
      25.778862,
      3.316822,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.652017,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.504215,
      3,
      6.091136,
      0,
      1.177801,
      NULL,
      NULL,
      NULL,
      1.661254,
      3,
      1.673025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.029819,
      2.482065,
      0.285176,
      NULL,
      0.092146,
      1.990842,
      0.529486,
      NULL,
      52,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.696648,
      2.678188,
      3,
      3,
      2,
      0,
      3,
      3,
      NULL,
      0,
      0,
      0,
      0.933068,
      NULL,
      2.711502,
      0.118642,
      1.187757,
      1.453892,
      0,
      1,
      0,
      1,
      0,
      1.131852,
      NULL,
      1.071929,
      1.149858,
      1,
      0,
      3.339031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      87,
      0,
      1,
      NULL,
      '32211',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1.955411,
      '',
      '',
      NULL,
      NULL,
      14,
      NULL,
      22,
      NULL,
      17.654622,
      3,
      2.967084,
      5,
      0.536802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.643354,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.972433,
      0.935100,
      3,
      0.686041,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.983938,
      1,
      0.508647,
      1,
      0.731870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.410144,
      NULL,
      NULL,
      1,
      1.258135,
      1.817715,
      1,
      1,
      1.434854,
      NULL,
      1,
      0.132906,
      NULL,
      1.733762,
      1,
      3.124505,
      1.181088,
      0,
      NULL,
      NULL,
      NULL,
      1.086934,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471492,
      NULL,
      NULL,
      3.674794,
      NULL,
      0,
      0.263252,
      NULL,
      NULL,
      1,
      0.829042,
      3,
      NULL,
      5,
      2,
      1,
      2.501018,
      NULL,
      1,
      NULL,
      NULL,
      0.295345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.924185,
      NULL,
      NULL,
      0.615429,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.430070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785606,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.263844,
      NULL,
      NULL,
      NULL,
      1.497741,
      6.470786,
      4,
      2.566609,
      1,
      1.761241,
      2.549555,
      NULL,
      2.555640,
      1.103385,
      1.227794,
      2.044645,
      2,
      1.796552,
      NULL,
      0.612865,
      NULL,
      2.090926,
      NULL,
      4.119570,
      2.086847,
      0,
      3.742034,
      3,
      NULL,
      1.624965,
      0,
      NULL,
      1.937193,
      NULL,
      3.984497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.212989,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.895372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060892,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.206614,
      0.726814,
      1,
      NULL,
      NULL,
      1.591665,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.484920,
      NULL,
      NULL,
      0.981553,
      1.112878,
      NULL,
      NULL,
      1,
      0.744373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.870888,
      3.748988,
      NULL,
      NULL,
      0.361562,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.993022,
      NULL,
      NULL,
      NULL,
      0.383033,
      2,
      NULL,
      NULL,
      NULL,
      0.445697,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.185555,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2,
      11,
      NULL,
      NULL,
      10.857296,
      NULL,
      NULL,
      NULL,
      1.334653,
      3,
      5,
      3,
      NULL,
      30.693361,
      NULL,
      3.737774,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.151363,
      NULL,
      1.405085,
      0.447658,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.934708,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.897906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      4.168575,
      4,
      NULL,
      NULL,
      12,
      1.676562,
      NULL,
      3,
      1,
      NULL,
      1,
      2.782968,
      2,
      1,
      0.243408,
      1,
      0.311919,
      NULL,
      1,
      1.812637,
      1,
      1,
      0,
      0.471707,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.060932,
      1.265947,
      0,
      1.431479,
      NULL,
      1.409164,
      1,
      0.321851,
      0,
      0,
      0,
      NULL,
      NULL,
      1.104342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413176,
      NULL,
      0,
      1,
      1,
      0,
      3,
      NULL,
      4,
      1.557194,
      NULL,
      NULL,
      NULL,
      98.121334,
      2,
      1,
      2,
      '43134',
      '',
      '',
      0.530175,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


