set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5513125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1242022',
      2,
      0.062215,
      3,
      NULL,
      '3334',
      3,
      1,
      NULL,
      NULL,
      ' 8-10-1977',
      1.951355,
      NULL,
      5,
      3.185766,
      16,
      NULL,
      17,
      1,
      68,
      38.953747,
      0,
      ' 0- 4-1987',
      NULL,
      ' 8-18-1991',
      2.317712,
      0.188084,
      2.384984,
      0,
      0.673497,
      1,
      7,
      3,
      NULL,
      NULL,
      NULL,
      5,
      6.943814,
      NULL,
      29.340480,
      0,
      1.973645,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.072825,
      4,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      0,
      0,
      2,
      3,
      9.978876,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.801244,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      7.196508,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      2,
      0,
      1,
      2,
      3,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      4,
      2,
      3,
      3,
      5,
      5,
      0,
      1,
      1.009941,
      1,
      ' 4-10-1989',
      NULL,
      ' 6-14-1982',
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      0,
      3,
      2.972226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.967932,
      0,
      1.064237,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690487,
      1.118853,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741913,
      NULL,
      1.611359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479055,
      0,
      NULL,
      NULL,
      0,
      0.760602,
      3,
      19,
      1.533495,
      1.766843,
      NULL,
      NULL,
      NULL,
      1,
      1.368215,
      1.427674,
      0,
      NULL,
      0,
      3,
      3,
      2,
      3,
      NULL,
      0,
      NULL,
      3,
      0.660704,
      2.889509,
      3,
      0,
      0.113651,
      3.153049,
      0,
      0,
      1,
      0,
      1,
      0.446566,
      1.482518,
      1,
      2,
      0.188307,
      3.389363,
      1.518367,
      2,
      0.414824,
      3,
      6,
      11.326899,
      1,
      1.479605,
      2.573236,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.121621,
      NULL,
      NULL,
      20,
      NULL,
      4,
      0.699051,
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      3.690325,
      15,
      6.008925,
      45,
      0,
      NULL,
      0,
      4.599813,
      3,
      1.753441,
      2.979260,
      1.799507,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.068063,
      1,
      0.425605,
      NULL,
      NULL,
      0.228541,
      NULL,
      NULL,
      0,
      NULL,
      0.374546,
      1,
      1,
      0,
      3,
      2.152655,
      2,
      1.223309,
      NULL,
      NULL,
      NULL,
      0,
      1.046311,
      3,
      0.108882,
      0.531093,
      9.422202,
      6.628042,
      2,
      1,
      0.406690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.395517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.712143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.957854,
      3,
      3.669216,
      2,
      2,
      NULL,
      NULL,
      2.867743,
      1,
      1.313158,
      7,
      0,
      1.240170,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.543860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.581850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3.171453,
      0,
      3.714481,
      NULL,
      NULL,
      0.615404,
      NULL,
      NULL,
      1.226804,
      0.012603,
      1,
      1.124584,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.381368,
      1.424679,
      0,
      1.729314,
      NULL,
      NULL,
      0.426689,
      2.425312,
      3.924084,
      1,
      1.387537,
      NULL,
      5,
      6.873041,
      5.534238,
      3,
      1.550353,
      1.804490,
      NULL,
      0,
      3,
      1,
      0,
      1,
      0.920004,
      1.536038,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.756292,
      NULL,
      NULL,
      0.870341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.262076,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.884089,
      1.406553,
      1,
      1,
      0,
      3.569475,
      1.761477,
      NULL,
      NULL,
      1,
      0.027833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291538,
      0.882493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423337,
      0.108540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605480,
      NULL,
      NULL,
      NULL,
      0.098910,
      0,
      NULL,
      NULL,
      0.590176,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.703195,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941518,
      NULL,
      NULL,
      NULL,
      0.829186,
      NULL,
      NULL,
      NULL,
      1.719667,
      NULL,
      NULL,
      0.722548,
      NULL,
      NULL,
      NULL,
      NULL,
      4.004496,
      NULL,
      0.576148,
      22,
      NULL,
      0.155951,
      NULL,
      NULL,
      1.354647,
      NULL,
      NULL,
      3.468967,
      1.734455,
      2.036048,
      0.051115,
      NULL,
      NULL,
      1,
      NULL,
      0.667265,
      NULL,
      NULL,
      NULL,
      1.744741,
      NULL,
      0,
      1.313889,
      0.867994,
      0,
      NULL,
      1,
      1,
      1.520272,
      0.553672,
      0,
      0,
      0.337152,
      1.227899,
      1,
      2,
      NULL,
      3.267746,
      NULL,
      NULL,
      NULL,
      1.932923,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      8.213821,
      1,
      2,
      4.823683,
      0,
      9.637767,
      1.294008,
      3.083198,
      1.302003,
      1,
      1.508643,
      NULL,
      1,
      1.357477,
      NULL,
      NULL,
      1.032178,
      NULL,
      0,
      1.321918,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.827017,
      NULL,
      1,
      1.104424,
      NULL,
      3,
      0.599302,
      1.985683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.407790,
      NULL,
      0.980441,
      NULL,
      0,
      3,
      3,
      2,
      0,
      2,
      18.169743,
      52,
      4,
      0,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


