set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9623778';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3013023',
      1,
      0,
      0,
      NULL,
      '2432',
      3.557272,
      0,
      NULL,
      NULL,
      ' 8-10-1998',
      31.195624,
      NULL,
      4,
      NULL,
      0.818445,
      ' 4- 5-1998',
      54,
      4,
      134.223334,
      200,
      2,
      ' 1- 9-1977',
      ' 0-28-1985',
      ' 9- 8-1981',
      3,
      2,
      1.162619,
      0,
      1,
      3.569286,
      4,
      0.507323,
      1.464154,
      NULL,
      6,
      13,
      10,
      12,
      6,
      3,
      19,
      3,
      1,
      NULL,
      1,
      1,
      0,
      0.701335,
      1,
      NULL,
      1.394613,
      0.657583,
      NULL,
      0,
      0.031962,
      0,
      0,
      1,
      NULL,
      3,
      1,
      1,
      2,
      1,
      1,
      4,
      NULL,
      3,
      3,
      NULL,
      1,
      8.033344,
      1,
      1,
      2,
      1,
      0.447687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      1.397722,
      NULL,
      0.676057,
      2.969183,
      3,
      3,
      1,
      1,
      1.933238,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.685847,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      2,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      7,
      3,
      ' 5-25-1983',
      19.863043,
      ' 7-11-1977',
      26.618030,
      0.000473,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.330413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.358991,
      0.957902,
      2.598105,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.049092,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938994,
      0.039441,
      0.631547,
      0.208355,
      NULL,
      0.891384,
      0.642323,
      NULL,
      35,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.443604,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      2,
      0,
      1,
      0,
      4.454514,
      155,
      161,
      139,
      155,
      117,
      121,
      0,
      NULL,
      1,
      0.342217,
      1.066866,
      1,
      1,
      0.467192,
      0.263184,
      0.822070,
      2.393436,
      NULL,
      1.287310,
      1,
      NULL,
      5.078334,
      1,
      0.584435,
      7,
      1.579319,
      3.635821,
      3,
      19.644040,
      1,
      2,
      NULL,
      19,
      NULL,
      NULL,
      3,
      2,
      0,
      '42334',
      NULL,
      NULL,
      1.561942,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.620876,
      24,
      220,
      35,
      1.663529,
      NULL,
      3,
      1,
      0,
      2,
      3,
      1.934109,
      3.415397,
      0,
      1,
      2,
      1,
      1,
      0.006837,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.032174,
      NULL,
      NULL,
      2,
      1.807025,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286288,
      1.385641,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      0.815410,
      NULL,
      NULL,
      6.768302,
      7,
      1.686368,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097439,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.336271,
      2.963390,
      2,
      0.834278,
      0,
      0.931133,
      NULL,
      0.843928,
      1.997989,
      NULL,
      0.517202,
      0.902816,
      0.462498,
      0,
      3.982501,
      1,
      1.871198,
      0.284796,
      1.336795,
      0.444130,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.226428,
      3,
      1,
      9.047027,
      5,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.411519,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.416074,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838883,
      NULL,
      NULL,
      0.729147,
      NULL,
      NULL,
      1.674764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.916379,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      0.988096,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.720358,
      0.058150,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      1.249707,
      NULL,
      NULL,
      0,
      1.047477,
      0.678198,
      3.152281,
      1,
      1.183842,
      NULL,
      1,
      NULL,
      0,
      1,
      3.303367,
      NULL,
      3,
      3,
      0.359751,
      0.848923,
      1,
      NULL,
      0.965228,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740647,
      NULL,
      NULL,
      1.669634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179039,
      NULL,
      NULL,
      1.476800,
      NULL,
      NULL,
      0.099785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078950,
      0.547296,
      0.337869,
      0.891210,
      0.684815,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839199,
      0.712095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213117,
      0.134078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.823685,
      NULL,
      NULL,
      NULL,
      1.440733,
      1.657088,
      NULL,
      NULL,
      NULL,
      0.723621,
      NULL,
      NULL,
      0.512540,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.315200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.821775,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.650375,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.380797,
      0,
      0.155386,
      0.713746,
      NULL,
      NULL,
      1.433087,
      NULL,
      NULL,
      1,
      NULL,
      0.343175,
      NULL,
      0,
      NULL,
      0,
      1,
      0.637764,
      0.005126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0.521766,
      1,
      2,
      3.007768,
      2,
      5,
      2.970446,
      2,
      NULL,
      1.456712,
      1,
      NULL,
      1,
      1,
      0.466724,
      0,
      0,
      3.790306,
      0.346550,
      0,
      2,
      0.647453,
      NULL,
      3,
      0,
      0.942673,
      0.740744,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.170929,
      0.672967,
      NULL,
      0.609616,
      NULL,
      1,
      NULL,
      1.806698,
      0.944559,
      0.404218,
      2.924530,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911467,
      0,
      0.270360,
      NULL,
      0.136284,
      NULL,
      2,
      NULL,
      6,
      1,
      NULL,
      NULL,
      63,
      19,
      3,
      5.784570,
      0,
      '14001',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


