set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4611223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1134101',
      0,
      1,
      0,
      2,
      '3224',
      2,
      1,
      3.420767,
      12.191339,
      ' 3- 1-1995',
      17,
      NULL,
      2,
      2.336754,
      1.803397,
      ' 3- 9-1994',
      NULL,
      0,
      24,
      135,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778315,
      3.399817,
      0.390240,
      0,
      1,
      4,
      3,
      NULL,
      NULL,
      NULL,
      6,
      2.502332,
      16.048814,
      7.753119,
      0,
      24,
      NULL,
      1,
      1,
      1.091363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.391619,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.627510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      4,
      1,
      2,
      NULL,
      0,
      3,
      2,
      1,
      1,
      1,
      0,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      0,
      0,
      1.949315,
      0.288764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0.100227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.202675,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1.685769,
      1,
      0.823562,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.870478,
      NULL,
      1,
      NULL,
      1,
      0,
      1.060823,
      NULL,
      2.764757,
      2.364297,
      58,
      572,
      412.110015,
      NULL,
      0.319025,
      2.905419,
      NULL,
      2,
      0,
      3,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      3,
      3.556401,
      0.256259,
      NULL,
      0.030946,
      1,
      NULL,
      0.445831,
      0,
      0.416220,
      0.911102,
      1,
      0,
      NULL,
      NULL,
      1,
      0.339147,
      2.353061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428735,
      77,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      '22132',
      '',
      '',
      1,
      '',
      '',
      '',
      0.744199,
      '',
      '',
      NULL,
      NULL,
      NULL,
      127,
      53.425593,
      NULL,
      51,
      NULL,
      88.475148,
      0,
      NULL,
      NULL,
      0.871361,
      0.548415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461724,
      NULL,
      NULL,
      0,
      0.884122,
      0.374318,
      16.384460,
      NULL,
      NULL,
      1.491605,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.497875,
      1.117352,
      1,
      NULL,
      NULL,
      NULL,
      5,
      7.820307,
      1.115508,
      0,
      0.158012,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      3.622992,
      0.520877,
      1.659917,
      NULL,
      NULL,
      0,
      1,
      1,
      3.345450,
      3,
      3,
      3.923208,
      3.835680,
      2,
      1.526483,
      0.878127,
      1.576263,
      3,
      2.315184,
      0.949785,
      3,
      1.394465,
      NULL,
      NULL,
      3,
      1.276065,
      1.320320,
      1,
      NULL,
      NULL,
      NULL,
      8,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.436710,
      NULL,
      NULL,
      2.776505,
      1,
      0,
      1,
      0,
      NULL,
      1.788217,
      NULL,
      NULL,
      3.736293,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.881920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.123206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.399923,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      2.127123,
      6,
      0,
      0,
      NULL,
      NULL,
      2.171709,
      0,
      1,
      2.250870,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.388658,
      NULL,
      NULL,
      1.245566,
      NULL,
      NULL,
      2.284346,
      NULL,
      NULL,
      3.390383,
      NULL,
      0,
      5.653457,
      11.477670,
      1,
      3.801444,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      1.477736,
      0.223056,
      1.296767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.080951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117351,
      NULL,
      NULL,
      1.657913,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.175761,
      NULL,
      NULL,
      0,
      NULL,
      1.711074,
      1.294197,
      1.072507,
      2,
      2.356399,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.351052,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452924,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.506757,
      NULL,
      NULL,
      0.195036,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.115256,
      NULL,
      NULL,
      3,
      2.935320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      53,
      NULL,
      1,
      NULL,
      NULL,
      1.813898,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.533548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.051784,
      NULL,
      NULL,
      NULL,
      1769,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.076776,
      0.273654,
      0.788432,
      1.746723,
      1,
      0.226593,
      1,
      0,
      1,
      0.834270,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515493,
      2,
      2.304161,
      3.299022,
      2,
      6,
      2,
      NULL,
      3,
      NULL,
      0.963156,
      0,
      0,
      3.274001,
      0.685573,
      NULL,
      3.462884,
      1.800616,
      1.601294,
      0,
      NULL,
      1.339643,
      0,
      NULL,
      1,
      0,
      NULL,
      0.228711,
      2.416786,
      0,
      3,
      3,
      0.192905,
      0.927403,
      1,
      1.672616,
      1,
      1.068222,
      0,
      1.044214,
      1.344248,
      0.389741,
      1,
      0.729908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858036,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      7,
      1,
      NULL,
      0,
      95,
      119,
      NULL,
      NULL,
      1,
      '03122',
      NULL,
      '',
      0.215645,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


