set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '1134000',
      1,
      1.271725,
      0,
      0,
      '1410',
      0,
      1.518321,
      NULL,
      NULL,
      ' 5- 1-1994',
      NULL,
      NULL,
      0,
      1,
      1.550005,
      ' 0- 0-1995',
      22,
      0.045024,
      NULL,
      18.677169,
      2,
      ' 7-21-1994',
      ' 3- 8-1987',
      ' 0-10-1988',
      0,
      NULL,
      2.109639,
      0.587285,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      15.972617,
      18,
      5,
      23,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1,
      0,
      3,
      1,
      2,
      1,
      0,
      0,
      4,
      0,
      2,
      2,
      0,
      1.212514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.549797,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      3,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      1,
      1,
      3,
      0.865823,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      1,
      4,
      0,
      NULL,
      1,
      2,
      0,
      1,
      0,
      4,
      3,
      NULL,
      3,
      NULL,
      0,
      0,
      4,
      0,
      NULL,
      0,
      5,
      3,
      ' 2-28-1974',
      1127,
      NULL,
      10.150175,
      1.120695,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      0,
      1,
      1,
      1.786268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051444,
      0.288772,
      0,
      1,
      0.075229,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365994,
      1.495840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.674867,
      0,
      3,
      52.684462,
      2,
      1,
      131.682321,
      66,
      713,
      3,
      1.012007,
      1,
      NULL,
      0,
      3,
      3,
      2,
      1,
      2,
      1,
      1,
      0,
      6.441809,
      0,
      1,
      0,
      1,
      1,
      4.821004,
      0,
      0,
      0.171468,
      1.567749,
      0,
      0,
      1.446543,
      0.917672,
      0,
      0.703193,
      2,
      0,
      1,
      NULL,
      5,
      2.361670,
      7.049149,
      4,
      2.188786,
      0,
      7.126882,
      0,
      NULL,
      0,
      40,
      NULL,
      1.849968,
      NULL,
      25,
      38,
      29,
      4,
      NULL,
      1,
      '13013',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      28,
      NULL,
      2,
      2.632964,
      28.374622,
      1.045024,
      3.305807,
      1,
      NULL,
      NULL,
      3.461764,
      2.273838,
      1,
      0,
      1.164662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.322790,
      NULL,
      0.873796,
      0,
      NULL,
      1,
      2,
      0.367855,
      1.899963,
      0,
      2.653078,
      0.089848,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.245861,
      NULL,
      NULL,
      8.504656,
      7.115779,
      4.782995,
      NULL,
      1.522074,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.179394,
      1,
      0.904747,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.614233,
      0.776873,
      2,
      1,
      1,
      0.404147,
      NULL,
      1,
      1.868541,
      0.891556,
      1.105712,
      1.698932,
      NULL,
      2.881569,
      2,
      2,
      0.501352,
      0,
      0,
      NULL,
      NULL,
      2.492179,
      1.429845,
      1,
      2.839515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.912399,
      1.337140,
      1,
      1.213170,
      2.642036,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.258821,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.359055,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3.456419,
      1.948328,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963661,
      NULL,
      NULL,
      1.801218,
      NULL,
      NULL,
      1.809327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3,
      0.756374,
      0.523780,
      0,
      1.201581,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.114900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.546214,
      NULL,
      NULL,
      1,
      1.069129,
      0,
      0.788221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028376,
      NULL,
      NULL,
      NULL,
      0,
      347.606581,
      237,
      0.862847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.368469,
      44,
      53,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      52,
      1.975348,
      1,
      0,
      1,
      0,
      0.055323,
      0,
      NULL,
      1.537273,
      1.009681,
      0,
      0.351244,
      1.817575,
      NULL,
      NULL,
      1,
      1.229206,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446024,
      1,
      0.250107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226966,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811626,
      0.802041,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.747869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.106114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416334,
      1.717891,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407171,
      NULL,
      NULL,
      3.134434,
      NULL,
      0.162884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268902,
      NULL,
      0,
      0,
      1.969333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.550229,
      1,
      0.354868,
      0,
      0,
      3,
      1.768745,
      2,
      2.344582,
      NULL,
      3.394946,
      0.246271,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.236963,
      1.450608,
      NULL,
      0.315641,
      2.287334,
      NULL,
      0.459796,
      0,
      NULL,
      NULL,
      1.134975,
      NULL,
      NULL,
      1.552177,
      NULL,
      0.151373,
      3.874756,
      NULL,
      3,
      0.302419,
      2.071544,
      0.181076,
      0.735607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283958,
      NULL,
      1.459180,
      NULL,
      0.159808,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      43,
      99,
      0,
      2.191647,
      3,
      '31414',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


