set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9037938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      1.606417,
      NULL,
      1,
      2,
      '4044',
      2,
      0,
      NULL,
      NULL,
      ' 6- 3-1989',
      7,
      NULL,
      1,
      3.664154,
      1.242391,
      NULL,
      56,
      2.126059,
      208.697133,
      65,
      3,
      ' 4-28-1996',
      ' 8- 3-2002',
      ' 6-21-1992',
      0.120139,
      2,
      NULL,
      1.772956,
      1,
      NULL,
      4,
      1,
      1,
      423,
      6,
      13.521721,
      1,
      41,
      49,
      5,
      16,
      2,
      0,
      7.575293,
      0,
      NULL,
      NULL,
      0,
      1,
      0.254177,
      NULL,
      1,
      1,
      0,
      22.330758,
      8,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0.254446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.608115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      3,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0.713440,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.917561,
      1,
      0,
      1,
      3,
      0,
      1,
      0,
      4,
      2,
      4,
      2,
      0,
      4,
      4,
      1,
      1,
      4,
      4,
      3,
      1,
      1,
      3,
      5,
      4,
      0,
      5.677336,
      NULL,
      ' 4-23-1975',
      458,
      ' 3-25-2002',
      1548.602812,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.326099,
      0,
      0.632008,
      NULL,
      1.414634,
      NULL,
      NULL,
      NULL,
      1.011264,
      1,
      1.474893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.787343,
      1.983108,
      NULL,
      1.483536,
      0,
      1.961186,
      1.547073,
      6631.368004,
      0,
      1.455819,
      NULL,
      NULL,
      NULL,
      2,
      1.799063,
      2.992722,
      3,
      3,
      1,
      3,
      1,
      1,
      3,
      2,
      0,
      1,
      1,
      NULL,
      11,
      80,
      138.144990,
      34,
      NULL,
      NULL,
      21,
      32.068852,
      NULL,
      4.799022,
      135.052455,
      46,
      5.930979,
      0,
      1.576887,
      3.251546,
      NULL,
      2,
      NULL,
      1.159396,
      NULL,
      0.688072,
      0,
      1.428668,
      1,
      2,
      3,
      NULL,
      1.102426,
      25,
      0,
      1,
      NULL,
      8,
      6,
      NULL,
      5,
      1.620746,
      4.646529,
      '32104',
      '23224',
      '',
      NULL,
      '',
      '',
      '',
      3,
      '2033',
      NULL,
      '32020',
      NULL,
      NULL,
      NULL,
      1.293849,
      3.238895,
      36.258923,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.168981,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.218071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.064762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.176188,
      1,
      1.435226,
      2,
      0.767610,
      0.705344,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.501528,
      0.244757,
      3.229434,
      0,
      1.348074,
      NULL,
      3.820032,
      1.975157,
      0,
      1,
      0,
      1.708354,
      1,
      NULL,
      0,
      1.704421,
      1,
      NULL,
      NULL,
      1.154911,
      NULL,
      NULL,
      3.368294,
      NULL,
      1.843374,
      1,
      1.790563,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870788,
      NULL,
      NULL,
      0.922080,
      NULL,
      NULL,
      1.719419,
      NULL,
      NULL,
      0.955364,
      NULL,
      NULL,
      0.064797,
      NULL,
      NULL,
      0.308306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.563951,
      NULL,
      1.066090,
      NULL,
      NULL,
      4,
      6,
      2.811575,
      6.300316,
      7,
      0,
      0,
      NULL,
      1.510257,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      6,
      3,
      1.863879,
      1,
      NULL,
      1,
      2.557606,
      0,
      1.768020,
      NULL,
      3.842622,
      2,
      1,
      1.084490,
      4,
      4,
      1.907123,
      NULL,
      6.274570,
      3,
      3,
      4,
      0,
      0.710585,
      0.380345,
      1,
      NULL,
      1.598621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.455319,
      0.078387,
      1.168466,
      0.787380,
      0.452561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412498,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.105799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374758,
      NULL,
      NULL,
      NULL,
      0.207689,
      NULL,
      NULL,
      NULL,
      0.630893,
      NULL,
      NULL,
      NULL,
      0,
      136.138632,
      110.919922,
      1.743034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.730673,
      NULL,
      NULL,
      3,
      217,
      0,
      2575,
      55,
      1,
      NULL,
      0.005835,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1.863342,
      NULL,
      1.856959,
      1.000885,
      NULL,
      1.833949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      3.411434,
      6,
      NULL,
      NULL,
      17.916030,
      1,
      NULL,
      1.387843,
      NULL,
      0.124272,
      NULL,
      0,
      1,
      NULL,
      3,
      1.921775,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.701366,
      NULL,
      0,
      1.439981,
      NULL,
      0.895431,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.047833,
      NULL,
      1.446416,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      1.115409,
      NULL,
      '32022',
      '',
      0,
      '',
      '',
      '',
      6.821485,
      '1442',
      '4202',
      '12042');
commit;
end;
/


