set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9720166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      3,
      0,
      2.936674,
      2,
      0.071426,
      4,
      NULL,
      '100',
      '00433424',
      65.524211,
      13,
      '0211431',
      1.590192,
      NULL,
      2,
      3,
      '4340',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-2000',
      66.001166,
      97.247972,
      NULL,
      0,
      0,
      ' 4- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3-13-1999',
      NULL,
      ' 1-11-1996',
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      12,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0.258628,
      1,
      1,
      NULL,
      0,
      0,
      5,
      5,
      2,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.103063,
      NULL,
      NULL,
      1,
      1,
      3.668816,
      1,
      NULL,
      1,
      1,
      1.079439,
      2.220447,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.080250,
      0.032706,
      1.229921,
      NULL,
      0,
      2,
      NULL,
      0,
      5,
      1,
      2,
      0.063581,
      1,
      NULL,
      NULL,
      1.692505,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0.035963,
      NULL,
      NULL,
      1,
      NULL,
      1.024073,
      NULL,
      1.363472,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      4,
      2,
      1,
      5,
      NULL,
      0,
      3,
      4,
      5,
      0,
      NULL,
      0.910923,
      NULL,
      ' 4- 0-1984',
      246.652222,
      ' 3- 0-1987',
      11,
      0,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.212582,
      0.404350,
      0.597465,
      NULL,
      1.130866,
      3.859781,
      0,
      NULL,
      NULL,
      NULL,
      0.709228,
      0.515708,
      0.245612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070647,
      0,
      0,
      1.294459,
      1,
      1.157802,
      1,
      3.968043,
      19,
      0.248344,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.952573,
      1,
      2,
      2,
      2,
      1,
      3,
      0,
      NULL,
      3,
      3,
      1.301763,
      1.968587,
      1.861126,
      1,
      1,
      0.555969,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.800316,
      0.403799,
      0,
      NULL,
      3,
      0,
      10.885086,
      8,
      0,
      NULL,
      4,
      NULL,
      4,
      NULL,
      6,
      2.379329,
      0.683751,
      2,
      69,
      0,
      NULL,
      11,
      NULL,
      59,
      26,
      NULL,
      4,
      1,
      '42030',
      '',
      '',
      NULL,
      '4021',
      NULL,
      '',
      3.019416,
      '2403',
      '',
      '',
      0,
      37.147298,
      0,
      6.311942,
      NULL,
      41.133301,
      2.466628,
      NULL,
      1,
      1.514150,
      3.472800,
      3,
      1.201104,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.668409,
      NULL,
      NULL,
      1.841592,
      NULL,
      NULL,
      3.890030,
      3,
      2,
      1.444533,
      NULL,
      1,
      0.992659,
      1.999082,
      1.358425,
      0.759269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.420857,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.892192,
      1,
      0,
      3.297100,
      NULL,
      NULL,
      0.105462,
      2.215158,
      1.099645,
      0,
      0.469683,
      0,
      0.012334,
      2.853709,
      2.283301,
      NULL,
      1.544218,
      NULL,
      NULL,
      1.718023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.689895,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.304660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625009,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.558292,
      0,
      0.572602,
      1.582663,
      NULL,
      NULL,
      1.891193,
      NULL,
      NULL,
      NULL,
      0,
      1.677767,
      3.465686,
      0.596188,
      0.512396,
      NULL,
      NULL,
      NULL,
      4.678893,
      1.666460,
      1,
      1.961742,
      0.126143,
      NULL,
      3,
      1.836421,
      0,
      0,
      0.995863,
      0.702699,
      NULL,
      1,
      1,
      5,
      0.668427,
      1.324407,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0.383415,
      NULL,
      0.539914,
      1,
      1,
      1.628679,
      NULL,
      NULL,
      1.102719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597647,
      NULL,
      NULL,
      1.861489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.242959,
      NULL,
      NULL,
      NULL,
      1.697754,
      1,
      0.004178,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.849086,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.691892,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.779496,
      NULL,
      NULL,
      1.490362,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037778,
      NULL,
      10.916240,
      1,
      1.209002,
      0.285217,
      0.083025,
      0.130044,
      NULL,
      0,
      1.767782,
      0.370543,
      1.136168,
      1.373603,
      NULL,
      0,
      0,
      1.243378,
      0,
      NULL,
      1.660230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.901432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515667,
      3.165082,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.832982,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      0.733976,
      NULL,
      496.504515,
      NULL,
      0.419345,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.691477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034728,
      NULL,
      1.444135,
      NULL,
      1,
      0,
      2,
      31,
      NULL,
      0.172333,
      1,
      1.459811,
      2.500767,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0.187479,
      1,
      3,
      1.640674,
      1,
      0.094041,
      1.305705,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.451639,
      1.174365,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.925084,
      0.413964,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      3.892805,
      NULL,
      0.727370,
      0.630658,
      NULL,
      NULL,
      0.742124,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.883355,
      NULL,
      0.238792,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      40,
      NULL,
      5,
      1,
      4.277893,
      NULL,
      '21332',
      '',
      1.000613,
      '1143',
      '',
      '',
      NULL,
      '0114',
      '',
      '');
commit;
end;
/


