set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526069';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1304033',
      NULL,
      NULL,
      3,
      NULL,
      '1024',
      3.073331,
      0.851723,
      NULL,
      NULL,
      ' 1-23-1986',
      43.021176,
      NULL,
      5,
      0.607945,
      NULL,
      ' 3- 8-1988',
      1.987322,
      2,
      223.266364,
      168.933960,
      NULL,
      ' 0- 0-1979',
      ' 0-15-1990',
      NULL,
      NULL,
      1,
      1.003063,
      1,
      1.105091,
      3,
      3,
      1,
      0.323786,
      4.737718,
      0,
      NULL,
      6,
      24,
      17.284831,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      0,
      0.425594,
      1,
      1.969220,
      0,
      NULL,
      1.090994,
      0,
      2,
      5,
      NULL,
      0.398774,
      4,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      5,
      0,
      0,
      0,
      NULL,
      1,
      2,
      0,
      1,
      0.933238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      9.453916,
      NULL,
      0,
      0.946119,
      0.948237,
      3.959725,
      NULL,
      0,
      2,
      3.979402,
      1,
      3.823518,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      7.505375,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.843710,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      2,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1.595757,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.297496,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3,
      2,
      4,
      0,
      3,
      NULL,
      5,
      4,
      1,
      0,
      5,
      2,
      ' 3-17-1986',
      867.621052,
      '11-26-1992',
      966,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.851952,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0.338015,
      3.042045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.858762,
      1,
      1,
      NULL,
      1.125860,
      1.105174,
      0,
      71.807572,
      0.034776,
      1.542311,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      0.800268,
      0,
      0.010563,
      1.179048,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      5.244153,
      0,
      9.398341,
      NULL,
      1.318226,
      NULL,
      6.014202,
      2,
      5,
      NULL,
      NULL,
      3.717987,
      2.114565,
      1.063349,
      6.027291,
      2,
      3,
      NULL,
      5,
      34,
      21.850282,
      NULL,
      NULL,
      NULL,
      '12010',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      58,
      7.479433,
      56,
      0,
      11,
      5.668437,
      NULL,
      4,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.227600,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.236699,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.176197,
      NULL,
      0.310148,
      1.942046,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.435629,
      NULL,
      NULL,
      0,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854118,
      NULL,
      NULL,
      NULL,
      0.380317,
      0,
      1,
      NULL,
      1,
      1,
      2,
      0.662730,
      0.154488,
      3,
      0,
      0.884160,
      NULL,
      0,
      1.519073,
      3,
      3,
      3,
      0,
      0,
      3,
      NULL,
      2,
      2,
      2.915115,
      1,
      NULL,
      NULL,
      NULL,
      1.204739,
      NULL,
      NULL,
      NULL,
      1.353794,
      6,
      0,
      1,
      1,
      0.304427,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.967825,
      NULL,
      NULL,
      2.880500,
      0,
      1.316498,
      2,
      0.531858,
      1.114842,
      0.048906,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.389984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664447,
      NULL,
      NULL,
      0.973117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694939,
      NULL,
      NULL,
      1.227594,
      NULL,
      NULL,
      1.442014,
      NULL,
      NULL,
      1.842484,
      0,
      1,
      1,
      1.468824,
      0,
      4,
      3,
      NULL,
      3,
      NULL,
      1.949190,
      2,
      2,
      NULL,
      1.993203,
      3.157040,
      2.425484,
      0.313341,
      0,
      2.754909,
      4,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      0.649555,
      1,
      0.292624,
      2,
      NULL,
      NULL,
      1.794358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.142527,
      NULL,
      NULL,
      0.704241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.212486,
      0.490853,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.628785,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.358604,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      3,
      0.305170,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.965295,
      NULL,
      1,
      250,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.405507,
      1,
      0.459159,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.589664,
      0,
      0.974160,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.144926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397309,
      0.090689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.431520,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.265439,
      0.482267,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590891,
      1.742787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      3,
      5,
      2,
      2,
      1,
      0.552935,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.994581,
      0.155192,
      NULL,
      1.522243,
      NULL,
      NULL,
      0.271290,
      0.953918,
      NULL,
      1,
      1,
      NULL,
      0.562686,
      1.332678,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438217,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.521572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687010,
      NULL,
      1.961495,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      2.341292,
      NULL,
      NULL,
      9,
      77,
      5,
      1.743370,
      NULL,
      '24113',
      '',
      '',
      0.800013,
      '',
      '',
      NULL,
      1.218031,
      '',
      '',
      '');
commit;
end;
/


