set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2330241',
      2.573173,
      0,
      2,
      NULL,
      '1300',
      3.175498,
      0,
      NULL,
      NULL,
      ' 8- 5-1981',
      27,
      NULL,
      NULL,
      NULL,
      1.181576,
      ' 4- 4-1978',
      39.926225,
      2,
      NULL,
      116.572987,
      1,
      ' 4-27-1979',
      ' 2-26-1977',
      ' 3-12-1978',
      1,
      NULL,
      3.929538,
      0,
      1.870947,
      1,
      NULL,
      0,
      1.350960,
      94,
      3,
      8,
      NULL,
      3,
      23.355394,
      4,
      22.407810,
      3,
      0,
      2,
      1.797209,
      0,
      1,
      4.332726,
      1,
      0.081259,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      5,
      NULL,
      5,
      3,
      5,
      2,
      0,
      4,
      3,
      0,
      4,
      0,
      6,
      1,
      NULL,
      0,
      0,
      0.308249,
      NULL,
      NULL,
      1.871804,
      NULL,
      NULL,
      1,
      4,
      2.970702,
      2.276530,
      3.788971,
      0.272817,
      NULL,
      NULL,
      1,
      1,
      1.227436,
      3.283089,
      NULL,
      NULL,
      1.377295,
      3,
      NULL,
      3,
      0.195928,
      4,
      1,
      2,
      3,
      NULL,
      2,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.437957,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.110048,
      NULL,
      1,
      1,
      5,
      5,
      2,
      NULL,
      0,
      1,
      5,
      3,
      4,
      NULL,
      4,
      3,
      4,
      2,
      3,
      1,
      2,
      3,
      4,
      4,
      0,
      0,
      5,
      1.297835,
      ' 0-26-1974',
      488.180672,
      ' 4-23-1976',
      45.955078,
      3.187505,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.838268,
      2.771581,
      0.779573,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.857122,
      0.187898,
      1,
      0.116406,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.989496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.683225,
      1,
      1,
      NULL,
      0.682617,
      NULL,
      111.054885,
      1.003301,
      2.564229,
      NULL,
      5.818386,
      25.203641,
      2,
      1.337237,
      0.216819,
      0,
      1,
      0,
      1,
      2,
      2,
      2,
      0,
      1,
      2,
      NULL,
      1.934107,
      0.775427,
      2.934571,
      1.733913,
      NULL,
      0.592475,
      2.862411,
      1,
      100.790228,
      7.366902,
      94.004119,
      0,
      0.751950,
      1.399916,
      0,
      0,
      4.970490,
      1.829723,
      0,
      8.870934,
      NULL,
      NULL,
      0,
      2.227154,
      0.532501,
      NULL,
      1.601826,
      0,
      0.530902,
      NULL,
      NULL,
      3,
      1,
      NULL,
      16,
      45,
      42.197912,
      3,
      0,
      NULL,
      '44441',
      '43312',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1,
      27,
      NULL,
      14,
      1,
      40.773899,
      11,
      6,
      NULL,
      3,
      2.121758,
      0.706542,
      1,
      NULL,
      NULL,
      1.183511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.398098,
      0,
      1,
      3.379592,
      3.035126,
      3.111729,
      2,
      NULL,
      0.032969,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.533109,
      1,
      0,
      1.943138,
      1.447358,
      1.458071,
      NULL,
      NULL,
      6,
      2.130567,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.960294,
      1,
      3.006449,
      3.655437,
      3,
      3.660747,
      2.600740,
      1.603294,
      1.941061,
      NULL,
      2,
      1,
      1.013182,
      1.767281,
      1,
      0,
      3,
      1,
      0,
      0,
      0,
      1.126501,
      0,
      0.144314,
      1,
      1,
      3.967936,
      2,
      1.385078,
      1.635846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.513522,
      NULL,
      NULL,
      7.305883,
      NULL,
      3,
      NULL,
      0.491665,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.151048,
      3.564519,
      0.675885,
      NULL,
      2,
      2.365464,
      0.514811,
      NULL,
      NULL,
      9.432011,
      5,
      0,
      0.105599,
      3,
      1,
      NULL,
      NULL,
      NULL,
      6.289702,
      4.914818,
      5,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769899,
      NULL,
      NULL,
      0.910105,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.279282,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      3.972570,
      1.559332,
      0,
      NULL,
      NULL,
      6.618623,
      7,
      NULL,
      0.990249,
      2,
      0,
      0.427165,
      0.419902,
      NULL,
      3.351192,
      2.449146,
      1,
      3.604779,
      7,
      7.051655,
      5.529213,
      NULL,
      2,
      1.218968,
      1.921695,
      3.563443,
      NULL,
      NULL,
      2,
      1,
      1,
      3.482388,
      NULL,
      3,
      7,
      NULL,
      9,
      3.122232,
      NULL,
      0,
      1,
      0,
      0.111012,
      0,
      1.094173,
      0.388720,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2.188273,
      2,
      1.010148,
      NULL,
      NULL,
      0.040021,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.802711,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.804767,
      0,
      NULL,
      NULL,
      1.167822,
      NULL,
      NULL,
      NULL,
      1.936757,
      NULL,
      NULL,
      NULL,
      1.321978,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665822,
      NULL,
      NULL,
      0,
      0.341441,
      NULL,
      NULL,
      NULL,
      2.997096,
      NULL,
      NULL,
      3,
      2.102293,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.174066,
      NULL,
      NULL,
      1,
      2.326556,
      NULL,
      NULL,
      4.720439,
      1.676214,
      NULL,
      NULL,
      NULL,
      3,
      1.949410,
      5,
      2,
      3,
      125.065141,
      29.341907,
      1.831315,
      9.552378,
      3,
      0,
      NULL,
      NULL,
      NULL,
      15.069142,
      2,
      1.546489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      924,
      31.746618,
      0.944712,
      2.284413,
      NULL,
      0,
      1.339775,
      0.950090,
      0,
      1.773328,
      1,
      1,
      0.585948,
      3,
      NULL,
      0,
      0.734487,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.957477,
      NULL,
      NULL,
      NULL,
      3.651124,
      17.952613,
      22.758891,
      0,
      3,
      3,
      NULL,
      2.214022,
      NULL,
      1.383652,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.543339,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.088959,
      NULL,
      2.726930,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.541910,
      NULL,
      1.535618,
      NULL,
      1.430251,
      1,
      0.347829,
      NULL,
      NULL,
      0,
      NULL,
      0.490522,
      NULL,
      NULL,
      NULL,
      0.813350,
      NULL,
      1.882870,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438309,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.466095,
      NULL,
      1.581120,
      NULL,
      0,
      NULL,
      0,
      0.664146,
      2,
      NULL,
      1.952356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.182091,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636527,
      1.643341,
      NULL,
      1.618529,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.449186,
      0,
      3.856707,
      NULL,
      3.034116,
      NULL,
      0.381980,
      NULL,
      NULL,
      NULL,
      0.150071,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.882282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.387914,
      4,
      NULL,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      1.448878,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346859,
      NULL,
      NULL,
      1,
      1.918998,
      NULL,
      NULL,
      1,
      NULL,
      1.429556,
      0,
      NULL,
      1.364465,
      1,
      NULL,
      1.869236,
      NULL,
      NULL,
      0.082493,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391374,
      NULL,
      0.644452,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      61,
      67,
      0,
      1.763319,
      5.559807,
      '03301',
      '30114',
      '40442',
      0,
      '',
      '',
      '',
      1.489703,
      '',
      NULL,
      '');
commit;
end;
/


