set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      1.237022,
      0.776023,
      3.559174,
      NULL,
      3,
      2.078871,
      2,
      '124',
      '23043042',
      NULL,
      71,
      '2431032',
      0,
      1.678908,
      2,
      NULL,
      '3441',
      4.749467,
      1.934528,
      NULL,
      NULL,
      ' 1-26-1988',
      NULL,
      188,
      NULL,
      1.944396,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-1996',
      3.869698,
      1,
      NULL,
      2,
      2.867799,
      1.855109,
      3,
      0.893016,
      1.309773,
      44.879739,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.384226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      0,
      4,
      0,
      1,
      2,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1.824421,
      1,
      0,
      NULL,
      0,
      1.720852,
      NULL,
      NULL,
      1.897455,
      NULL,
      NULL,
      2,
      3,
      4.169235,
      NULL,
      1,
      0.488812,
      0,
      NULL,
      NULL,
      NULL,
      1.536292,
      0.817037,
      3.835256,
      1,
      1.770054,
      NULL,
      1.719752,
      1.053703,
      1.094525,
      1,
      NULL,
      0,
      3.184651,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      4,
      0,
      0,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      3,
      4,
      1,
      1,
      0,
      0,
      NULL,
      5,
      0,
      1,
      2,
      4,
      1,
      1,
      1,
      5,
      4,
      3,
      3,
      1,
      NULL,
      NULL,
      ' 6-12-2001',
      NULL,
      NULL,
      636,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1,
      NULL,
      1,
      0.016998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.317101,
      4.793933,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.282521,
      2,
      1.458197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.313345,
      3.751769,
      1.515091,
      0.555687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      1,
      2.310226,
      2.647470,
      3,
      NULL,
      1.018149,
      NULL,
      1,
      0.298900,
      1.780813,
      1.792073,
      NULL,
      1.747613,
      0,
      1,
      1.351934,
      0,
      3.563531,
      2.057036,
      0.685711,
      10.147044,
      10,
      0,
      11.440596,
      4,
      6,
      NULL,
      3.660341,
      NULL,
      3.983738,
      3,
      3.891694,
      5.616714,
      NULL,
      0.270765,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.379366,
      '22044',
      NULL,
      '',
      1.385381,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.221117,
      NULL,
      166,
      44.833444,
      3,
      NULL,
      8,
      NULL,
      NULL,
      2.626295,
      3.042318,
      NULL,
      0.702688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.047809,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.901110,
      3.352077,
      2,
      1,
      NULL,
      1,
      1.801652,
      2.358486,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.412648,
      1,
      0.428830,
      NULL,
      NULL,
      NULL,
      0.400111,
      NULL,
      NULL,
      NULL,
      2.090161,
      NULL,
      3.942702,
      0,
      NULL,
      1,
      1.443081,
      1,
      3.018273,
      0,
      1,
      0.466936,
      0.562047,
      1.829704,
      1,
      0,
      0,
      0,
      1,
      2,
      NULL,
      3,
      0,
      0,
      1.784348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.165631,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.134136,
      NULL,
      NULL,
      3,
      1.835567,
      1,
      3.968337,
      1,
      1.923532,
      1,
      NULL,
      NULL,
      3,
      0,
      1.083514,
      3.527045,
      0,
      1.715789,
      2,
      1.575509,
      1.815691,
      3,
      0.602560,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.201463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010110,
      NULL,
      NULL,
      0.025288,
      NULL,
      NULL,
      3,
      1,
      2.442752,
      4,
      0.654206,
      4,
      4.529088,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.087900,
      1.702479,
      3,
      0.801682,
      0.375656,
      NULL,
      0.498375,
      7.048295,
      0,
      1,
      NULL,
      2,
      1.188168,
      NULL,
      0,
      1.240551,
      NULL,
      0.947002,
      NULL,
      2.159541,
      9.027758,
      0.256179,
      3,
      1.146912,
      0.257379,
      2.442779,
      3,
      NULL,
      1,
      3,
      0.517646,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4.351426,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      1.423406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.983428,
      NULL,
      NULL,
      1.569820,
      NULL,
      NULL,
      0.949159,
      NULL,
      NULL,
      1.338735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474674,
      0.449045,
      0.458306,
      1,
      NULL,
      1.721923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466397,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.168823,
      NULL,
      NULL,
      NULL,
      1.387341,
      NULL,
      NULL,
      NULL,
      0.631401,
      NULL,
      NULL,
      NULL,
      0.496862,
      NULL,
      NULL,
      NULL,
      2.750789,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.925434,
      NULL,
      NULL,
      NULL,
      NULL,
      97.518007,
      24,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.907068,
      1,
      2,
      10,
      0,
      1.456392,
      NULL,
      NULL,
      0.342863,
      NULL,
      1.851962,
      24.972956,
      0,
      0.196803,
      0.743308,
      1,
      NULL,
      1,
      0,
      0,
      0.968932,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.421100,
      NULL,
      0.883049,
      1,
      1.441473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      2.363436,
      1,
      7.029880,
      3,
      2.964959,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.180462,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.301544,
      NULL,
      1.936107,
      0.142707,
      NULL,
      NULL,
      0.329870,
      NULL,
      1.857908,
      1.653294,
      NULL,
      0.196811,
      1.544227,
      NULL,
      0.576248,
      0.701128,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469895,
      NULL,
      NULL,
      NULL,
      1.531212,
      NULL,
      4,
      6,
      3,
      NULL,
      NULL,
      NULL,
      57.596062,
      26.716742,
      5,
      4.764100,
      NULL,
      '14101',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


