set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4202234',
      0,
      NULL,
      2,
      3,
      '4002',
      0.305102,
      0,
      NULL,
      NULL,
      ' 6-18-1995',
      NULL,
      NULL,
      4,
      0,
      1.069088,
      ' 0- 8-1990',
      39.160401,
      3.170304,
      86,
      32,
      0,
      NULL,
      NULL,
      ' 7-10-1991',
      0.407650,
      1.730179,
      2.687249,
      1,
      1,
      1.372288,
      4,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.522081,
      NULL,
      0,
      1,
      4.508269,
      5,
      2,
      1.479037,
      NULL,
      0,
      0,
      NULL,
      0,
      1.947665,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      3,
      1,
      3.762486,
      1,
      1,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.750618,
      0,
      NULL,
      2.262282,
      NULL,
      NULL,
      NULL,
      0.718481,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      3,
      0,
      2,
      1,
      1,
      2.234279,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      1,
      2,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      3,
      NULL,
      3,
      5,
      5,
      5,
      NULL,
      4,
      0,
      2,
      0.437948,
      0,
      NULL,
      578.490737,
      NULL,
      438.114955,
      1.578505,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.481215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.212682,
      0,
      1.210127,
      3,
      1.544166,
      0.910744,
      0.980969,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905441,
      0.927970,
      5.902486,
      0,
      0.516994,
      NULL,
      4,
      0.633111,
      NULL,
      NULL,
      NULL,
      0.367461,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.050122,
      0.047013,
      0.114991,
      0,
      1,
      1,
      0,
      0.954628,
      NULL,
      1.803085,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      2,
      1,
      2,
      3.599157,
      0,
      2.956762,
      NULL,
      NULL,
      1,
      97.844425,
      169.327742,
      198.462647,
      1,
      1.408773,
      0,
      0,
      0,
      1.611595,
      0,
      0.852526,
      5,
      0,
      9.807064,
      8,
      NULL,
      2.481884,
      6,
      3,
      2.747444,
      0,
      1.602707,
      3.028632,
      2,
      2,
      19,
      NULL,
      2.185130,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      '22100',
      NULL,
      '44204',
      0,
      '',
      '',
      '',
      NULL,
      '33221',
      NULL,
      '',
      1,
      9.914200,
      25.240356,
      58.446987,
      2,
      15.709604,
      1,
      2,
      3,
      2,
      1.623601,
      2.895805,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.022182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.001371,
      3,
      3.167245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341519,
      NULL,
      NULL,
      0.771050,
      NULL,
      NULL,
      0.544801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.703490,
      NULL,
      0.860291,
      NULL,
      0.469261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.879866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.823527,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280837,
      NULL,
      NULL,
      1.851720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.384838,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.896144,
      NULL,
      NULL,
      1.319606,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.200216,
      NULL,
      NULL,
      1.591328,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4.754268,
      7,
      NULL,
      1.389597,
      NULL,
      NULL,
      0.729633,
      0.205029,
      NULL,
      0.744418,
      NULL,
      NULL,
      4.507904,
      7.771658,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      1.048892,
      0.607840,
      3.371352,
      0,
      0.426346,
      3.895350,
      3,
      4.836627,
      7,
      1,
      NULL,
      NULL,
      NULL,
      3.855174,
      3,
      2,
      NULL,
      0,
      0,
      1,
      0.271106,
      3,
      NULL,
      NULL,
      0.755716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890229,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.740403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0.541647,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.335698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.651751,
      NULL,
      NULL,
      NULL,
      1.980058,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.710288,
      NULL,
      NULL,
      NULL,
      0.808530,
      0,
      2.026373,
      0,
      1.240859,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.257310,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.810371,
      NULL,
      0.233380,
      50.802168,
      10,
      NULL,
      1.543947,
      0,
      0,
      NULL,
      0,
      1,
      1.134104,
      NULL,
      1.217109,
      NULL,
      1,
      0,
      0,
      1.831613,
      0.336101,
      3,
      0.621141,
      NULL,
      NULL,
      0.464856,
      NULL,
      0,
      NULL,
      1.913052,
      NULL,
      1,
      NULL,
      4.123526,
      NULL,
      0.805005,
      NULL,
      3,
      NULL,
      0,
      1.754065,
      NULL,
      0.035959,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.950534,
      NULL,
      3.971832,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.823694,
      1.414037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.027279,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.874306,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.605203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.340521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.137329,
      NULL,
      2.937990,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.283605,
      NULL,
      0.838077,
      NULL,
      0.288630,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      0,
      0,
      1,
      0.432437,
      1.168556,
      NULL,
      NULL,
      1.985660,
      1.374824,
      NULL,
      1.579013,
      0.692280,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.365874,
      NULL,
      0,
      1,
      NULL,
      0,
      1.936489,
      NULL,
      0.167904,
      0.857336,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      0.020625,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.482702,
      NULL,
      1,
      NULL,
      2,
      6,
      NULL,
      3.829470,
      NULL,
      1,
      65.769782,
      58,
      4,
      1.279549,
      0,
      '01234',
      NULL,
      '22432',
      1.703264,
      '',
      '',
      '',
      4,
      '32303',
      '40101',
      NULL);
commit;
end;
/


