set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7220278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4423434',
      1.237642,
      NULL,
      NULL,
      2,
      '4400',
      1.881978,
      NULL,
      NULL,
      NULL,
      '10- 2-2003',
      6,
      NULL,
      NULL,
      NULL,
      13,
      ' 5-11-1991',
      24.355131,
      0,
      327.292539,
      25.020633,
      0,
      ' 5-23-1992',
      ' 0-27-1997',
      ' 3-20-1996',
      NULL,
      NULL,
      2,
      2.319699,
      NULL,
      0,
      3,
      2.261481,
      NULL,
      NULL,
      NULL,
      2.377219,
      1,
      183,
      123,
      0,
      2,
      2,
      3,
      1.315280,
      0.176523,
      0,
      NULL,
      0,
      NULL,
      1.364476,
      1,
      0.411792,
      1.649171,
      1.254422,
      0,
      3,
      1,
      1,
      2.675449,
      0,
      NULL,
      3,
      NULL,
      1,
      5,
      3,
      2,
      0,
      4,
      3,
      1,
      9.771371,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.994706,
      1,
      1,
      1,
      0,
      4.170666,
      2.699677,
      0.924453,
      1.742086,
      3,
      0,
      0.556470,
      3,
      0,
      NULL,
      2,
      NULL,
      1,
      0.193375,
      NULL,
      NULL,
      1,
      NULL,
      5,
      2,
      8.496871,
      2,
      0,
      0.309745,
      0,
      NULL,
      NULL,
      0.893975,
      0,
      NULL,
      NULL,
      3,
      5,
      3,
      4,
      2,
      4,
      1,
      4,
      0,
      1,
      NULL,
      0,
      4.712518,
      0,
      1,
      2,
      1,
      0,
      NULL,
      4.842419,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      5,
      5,
      3,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      2,
      2,
      0,
      3,
      5,
      NULL,
      5,
      0,
      7.403223,
      1.575409,
      '10-22-1990',
      762,
      ' 5-12-1999',
      14,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.389929,
      3.049217,
      0,
      4,
      3,
      NULL,
      0.801299,
      1.751962,
      7,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1,
      7,
      6.787349,
      2,
      1,
      NULL,
      NULL,
      NULL,
      6.256544,
      NULL,
      1,
      3,
      0,
      7,
      ' 3-25-1982',
      25.906390,
      '11-21-1983',
      0.270479,
      1.002132,
      NULL,
      NULL,
      1,
      0.704808,
      1.220038,
      0,
      0.189655,
      1.946143,
      1,
      0.505847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.601766,
      0,
      1,
      3,
      3,
      1,
      1,
      0,
      2,
      0,
      2,
      2,
      2.600860,
      NULL,
      3.265191,
      3.866918,
      1,
      NULL,
      0.181984,
      1.693224,
      5.865919,
      0,
      1,
      NULL,
      1.205365,
      1.518198,
      1,
      0.844696,
      0,
      0.194089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      32,
      5,
      4,
      1,
      4.065704,
      NULL,
      '24033',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0.711641,
      '',
      NULL,
      NULL,
      1.328066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.041112,
      0.212681,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.089802,
      4190.508109,
      831,
      1.717800,
      0.835534,
      1,
      0.049895,
      1.455217,
      1.982840,
      0.688343,
      NULL,
      0,
      0,
      1.578880,
      1.295678,
      1,
      NULL,
      0,
      0.467951,
      1,
      0.561055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438942,
      0.756479,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007505,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.625250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839498,
      NULL,
      NULL,
      NULL,
      1.464835,
      NULL,
      1,
      NULL,
      1.374672,
      NULL,
      1.715845,
      NULL,
      1.511756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.221063,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.495287,
      1,
      NULL,
      3,
      NULL,
      1.702460,
      NULL,
      3.548490,
      NULL,
      42.973689,
      NULL,
      2.353626,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.608080,
      NULL,
      11.586969,
      1.952874,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      4,
      NULL,
      NULL,
      1,
      13.540081,
      0,
      0,
      0.837054,
      NULL,
      1.929639,
      NULL,
      0,
      1.461305,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.827201,
      NULL,
      2,
      1.416775,
      NULL,
      0.582393,
      1,
      NULL,
      1,
      1.057748,
      NULL,
      0.672062,
      0.129906,
      NULL,
      0,
      1.853894,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.563478,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.215003,
      NULL,
      0.423072,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.478284,
      NULL,
      1.839741,
      NULL,
      20.045092,
      2.321362,
      NULL,
      1.254948,
      NULL,
      NULL,
      NULL,
      1.106622,
      NULL,
      1,
      0,
      5,
      2.308779,
      0.994416,
      1.252228,
      89,
      40.739303,
      1,
      0.455194,
      6.533857,
      '40043',
      '14131',
      '22142',
      0.093454,
      '00301',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


