set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7220278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      '0340',
      1.153971,
      1,
      NULL,
      NULL,
      ' 3-13-1995',
      NULL,
      NULL,
      1,
      0,
      14.425478,
      ' 8-14-1978',
      46,
      1.003477,
      28.049457,
      91,
      3,
      '11-25-1988',
      NULL,
      ' 4-15-1983',
      0,
      1,
      0,
      NULL,
      NULL,
      0.304273,
      4,
      0.316328,
      NULL,
      NULL,
      NULL,
      8,
      1,
      25.003366,
      NULL,
      0,
      15,
      1,
      2,
      1,
      1,
      NULL,
      1,
      1.294991,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.080596,
      NULL,
      0,
      NULL,
      NULL,
      2.750997,
      1,
      NULL,
      2,
      3,
      4,
      NULL,
      3,
      5,
      1,
      1,
      0,
      NULL,
      9.366656,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      8,
      0.782936,
      1.226503,
      1.035385,
      3.898391,
      0,
      1.076522,
      2,
      0,
      0,
      1,
      2,
      0.356287,
      1.873864,
      1,
      0,
      0,
      2,
      2,
      3,
      10,
      NULL,
      NULL,
      0,
      1.339823,
      NULL,
      NULL,
      1.061962,
      1,
      NULL,
      0,
      5,
      1,
      5,
      1,
      2,
      1,
      0,
      2,
      0,
      0,
      3,
      0,
      3,
      1,
      1,
      0,
      NULL,
      2.346853,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      2,
      5,
      5,
      NULL,
      2,
      4,
      0,
      5,
      2,
      3,
      0,
      1,
      NULL,
      4,
      NULL,
      4,
      3,
      0.304682,
      1,
      '11- 1-1981',
      NULL,
      NULL,
      11.632832,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      2,
      0.853461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1382,
      2,
      0.174607,
      1,
      1.448089,
      2,
      0,
      0,
      22.362034,
      NULL,
      1.981584,
      0.327655,
      NULL,
      NULL,
      NULL,
      0.204129,
      0.383916,
      6.607162,
      5,
      1.648300,
      9.918246,
      1.968142,
      0.498304,
      1,
      1,
      NULL,
      4,
      3,
      1,
      3,
      2,
      0,
      ' 5-28-1998',
      NULL,
      NULL,
      797,
      1,
      2,
      0,
      2.060219,
      1.138212,
      0,
      0,
      NULL,
      0.989047,
      1.479132,
      1.406077,
      4.677593,
      0.259789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      3,
      0,
      2,
      1,
      3.011270,
      12.340737,
      6,
      0,
      NULL,
      1.422630,
      3,
      0,
      1.347981,
      3.306716,
      0,
      0,
      1.928130,
      1.914062,
      1,
      0,
      1.521004,
      3.613089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.695490,
      NULL,
      47,
      37,
      70.490544,
      3,
      NULL,
      4.163490,
      '24324',
      '00332',
      '',
      0,
      '',
      '',
      '',
      0.163499,
      '',
      NULL,
      NULL,
      0.686155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.520915,
      NULL,
      NULL,
      1.703451,
      NULL,
      NULL,
      1.663793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.828691,
      11387,
      655.909621,
      1,
      NULL,
      NULL,
      0,
      0.197253,
      0.529357,
      1,
      0.754421,
      1.593533,
      0,
      NULL,
      1.617849,
      1,
      1.582313,
      1.239155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867133,
      1.956304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476301,
      0.904077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.145233,
      NULL,
      0,
      NULL,
      1,
      1,
      2.499305,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.556867,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.439796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      1,
      0.625901,
      NULL,
      NULL,
      NULL,
      1.696994,
      NULL,
      0.145500,
      NULL,
      0.925098,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.260246,
      1,
      3,
      48.893810,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      7,
      NULL,
      5,
      1.477262,
      0,
      5,
      0.434239,
      NULL,
      NULL,
      0.622714,
      1.115608,
      NULL,
      1.805505,
      1,
      NULL,
      1,
      0.742025,
      NULL,
      1,
      1.216261,
      NULL,
      3.644636,
      2.486772,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2.272515,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901138,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.231874,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.344956,
      NULL,
      0.722044,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.226321,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.522733,
      NULL,
      0.506663,
      NULL,
      7.826456,
      1.740965,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      2.563760,
      3,
      1.797343,
      83.014529,
      42.263636,
      2,
      0,
      6,
      '01004',
      '01122',
      '34442',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


