set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005690';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0343434',
      NULL,
      NULL,
      1,
      3,
      '0133',
      NULL,
      1,
      NULL,
      NULL,
      ' 6- 7-2001',
      2.343586,
      NULL,
      1,
      0,
      0.669385,
      ' 9-21-1986',
      40.875426,
      4.840402,
      256,
      86.317047,
      1,
      '10-16-1988',
      ' 7-16-1983',
      ' 1-23-1993',
      3.265263,
      NULL,
      3,
      0.411996,
      0.112084,
      1,
      0,
      1.924731,
      NULL,
      72,
      3,
      7,
      7.180915,
      21,
      3.941950,
      NULL,
      5,
      4,
      2,
      7.123145,
      NULL,
      3,
      1,
      0.368953,
      0.493217,
      1,
      NULL,
      1.827395,
      0.401386,
      NULL,
      0.811001,
      1,
      3,
      1,
      NULL,
      4,
      NULL,
      1,
      3,
      4,
      4,
      NULL,
      5,
      0,
      NULL,
      2,
      0,
      0,
      0,
      0,
      0,
      0,
      1.351686,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      4,
      3.970549,
      0,
      1,
      3.563714,
      0,
      0,
      0,
      0.593061,
      1,
      NULL,
      2.327557,
      NULL,
      NULL,
      3.269990,
      0.882625,
      1,
      NULL,
      NULL,
      0,
      7.650919,
      1,
      0,
      NULL,
      0.569974,
      NULL,
      NULL,
      0.583583,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      5,
      0,
      1,
      5,
      0,
      0,
      NULL,
      2.918829,
      2,
      1,
      0,
      NULL,
      2.599746,
      NULL,
      7,
      3,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      5,
      2,
      1,
      5,
      4,
      2,
      0,
      NULL,
      NULL,
      3,
      4,
      1,
      1,
      2.820911,
      3.872958,
      ' 0- 5-2001',
      966.698918,
      '10- 6-1987',
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.516842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.298765,
      1,
      7.587399,
      1.405227,
      5.014734,
      0.315260,
      NULL,
      NULL,
      NULL,
      0.925262,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897980,
      1,
      1.857011,
      1,
      0,
      0,
      89,
      2.982096,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.920030,
      NULL,
      3,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      2,
      NULL,
      3,
      1,
      3.150873,
      2,
      0,
      1,
      1.636076,
      9,
      1.511481,
      0.170932,
      0,
      0,
      0.043090,
      1,
      0.757765,
      1.154982,
      1,
      0,
      3.279083,
      1,
      2,
      NULL,
      NULL,
      2,
      8.782684,
      7.395286,
      0.016847,
      3,
      5.888332,
      0.906842,
      1.034398,
      1.635032,
      NULL,
      0,
      2,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      1.135564,
      0.119552,
      '01331',
      '33114',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      105,
      39,
      2.339596,
      6.218457,
      2,
      21.632364,
      2,
      3.494509,
      3,
      NULL,
      0.709581,
      NULL,
      NULL,
      1.710010,
      NULL,
      NULL,
      NULL,
      3.806604,
      2.617810,
      0,
      1.982684,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.901294,
      NULL,
      NULL,
      0.902845,
      NULL,
      NULL,
      1.370024,
      NULL,
      NULL,
      3.720393,
      9.282801,
      1.317388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.576237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.691969,
      1,
      1,
      0,
      3.357415,
      0.013015,
      1,
      1.128951,
      2.243872,
      0.337666,
      NULL,
      0.554609,
      1,
      3,
      0,
      1,
      1,
      1.078760,
      3.047738,
      0.909308,
      NULL,
      0,
      3.506688,
      0,
      8,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.379739,
      NULL,
      NULL,
      3.867474,
      2,
      NULL,
      1,
      0.206725,
      2,
      NULL,
      0,
      1.539295,
      0,
      1,
      1,
      1.369227,
      NULL,
      NULL,
      0.819899,
      1.611426,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.853528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.247940,
      NULL,
      NULL,
      NULL,
      3,
      0.944081,
      NULL,
      NULL,
      4.529079,
      5,
      6.245152,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      6,
      6.057497,
      6,
      2.841479,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4.211377,
      NULL,
      2.042551,
      NULL,
      5.565608,
      5,
      2,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.707844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379800,
      NULL,
      NULL,
      0.399099,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.270175,
      NULL,
      NULL,
      0.249321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378208,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.737266,
      0.703755,
      NULL,
      1.216902,
      NULL,
      NULL,
      2.336894,
      NULL,
      NULL,
      NULL,
      33.469494,
      NULL,
      NULL,
      NULL,
      1.557461,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.768561,
      NULL,
      NULL,
      NULL,
      1.207130,
      NULL,
      NULL,
      NULL,
      1.265979,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.112495,
      NULL,
      NULL,
      NULL,
      0.200359,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798697,
      2,
      4,
      3,
      190.218093,
      NULL,
      1.764774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.400712,
      NULL,
      0.897930,
      141,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.402621,
      1.325743,
      1.816699,
      1,
      0.154960,
      0.730483,
      0,
      1,
      0,
      1.021870,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.878702,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119681,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.179457,
      NULL,
      0.734552,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.906947,
      1.659545,
      3.776625,
      NULL,
      0.334008,
      NULL,
      NULL,
      NULL,
      188,
      NULL,
      3,
      NULL,
      0.419903,
      NULL,
      0.351284,
      0.446866,
      1.860224,
      7,
      9.842459,
      1.744039,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      0,
      5,
      0,
      5,
      1.445897,
      2.600763,
      0.224703,
      0,
      0,
      NULL,
      NULL,
      0.231525,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.293480,
      NULL,
      1,
      0.507250,
      NULL,
      0,
      NULL,
      NULL,
      0.111514,
      2.759624,
      NULL,
      1.573345,
      NULL,
      NULL,
      2.444784,
      1.422725,
      1.312867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      2.654893,
      61,
      54.874568,
      NULL,
      1,
      3,
      '04324',
      NULL,
      '23034',
      1.680554,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


