set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7431336';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1344422',
      2,
      1.975317,
      0,
      1,
      '4222',
      1,
      1.830099,
      NULL,
      NULL,
      ' 0-25-1993',
      128,
      NULL,
      4,
      3.536066,
      1,
      ' 7- 5-1984',
      44.029796,
      0.811177,
      315,
      124,
      1,
      ' 9-24-1984',
      ' 6-24-1986',
      ' 7-21-1985',
      0.262133,
      0.774197,
      2.458408,
      0.478977,
      0,
      NULL,
      0,
      1.693401,
      NULL,
      NULL,
      NULL,
      9.147992,
      4.266683,
      NULL,
      0.228104,
      2,
      2.340280,
      4,
      NULL,
      1.596581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      5,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      0.084998,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.403202,
      0.625641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      11.715652,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      2,
      1,
      0,
      6,
      NULL,
      1,
      1,
      0,
      NULL,
      0.137307,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      5,
      1,
      0,
      0,
      2,
      1,
      3,
      NULL,
      2,
      3,
      1,
      ' 8-22-1998',
      141.654550,
      ' 2-24-1996',
      189,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      0,
      0,
      0.173192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      397.259589,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.675900,
      1,
      NULL,
      0,
      0,
      5.168698,
      NULL,
      7.611844,
      0.240429,
      1,
      3,
      0.013316,
      NULL,
      NULL,
      NULL,
      0.465100,
      0.259932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.402477,
      0.630742,
      0.057280,
      NULL,
      0.649514,
      0.512891,
      2,
      94,
      0,
      0.713952,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.114737,
      3,
      NULL,
      0,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2.100318,
      1.165588,
      0.167266,
      0,
      0,
      0.375998,
      0.475265,
      1.173298,
      0,
      0.005918,
      0.400295,
      0.920402,
      0.334874,
      1.173126,
      0,
      NULL,
      NULL,
      NULL,
      0.964564,
      0,
      NULL,
      0.326453,
      7.483224,
      NULL,
      6.184702,
      0.713929,
      1.794573,
      0,
      2,
      NULL,
      NULL,
      24.212321,
      0,
      NULL,
      NULL,
      NULL,
      24,
      19,
      3,
      3,
      2,
      '41044',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.271693,
      '11421',
      NULL,
      '',
      2.233946,
      3.463698,
      106,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736795,
      NULL,
      NULL,
      0.864627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062152,
      NULL,
      NULL,
      1,
      0.919149,
      0,
      1.283944,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.569124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.668323,
      1,
      1.486587,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.711130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694591,
      NULL,
      NULL,
      NULL,
      1.822816,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0.949524,
      NULL,
      0,
      1,
      0,
      0.799845,
      2.182082,
      0.327313,
      NULL,
      0,
      1.803042,
      1,
      0,
      NULL,
      NULL,
      1.986564,
      NULL,
      NULL,
      10,
      6.452541,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.653763,
      1,
      0.521557,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      3.891332,
      2,
      1.461970,
      0,
      2,
      1.423924,
      6.723392,
      0,
      4,
      1,
      0.996780,
      NULL,
      2.798579,
      NULL,
      1.795071,
      0.304855,
      3.258032,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.769046,
      1,
      5,
      NULL,
      NULL,
      0,
      3.811659,
      2.199296,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.471817,
      1,
      0.857880,
      0,
      1.027978,
      1,
      1.986345,
      3,
      2,
      4,
      2,
      4.139236,
      1,
      0.102660,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      1.473698,
      0,
      NULL,
      9,
      5,
      3,
      3,
      NULL,
      NULL,
      2.812693,
      NULL,
      NULL,
      1.637874,
      1,
      NULL,
      0.684495,
      1.502430,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.868326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.651796,
      NULL,
      NULL,
      0.651572,
      NULL,
      NULL,
      0.865697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.206230,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.259050,
      NULL,
      471.605718,
      NULL,
      1.732955,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.846814,
      NULL,
      3,
      NULL,
      NULL,
      0.397726,
      1.029275,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.253186,
      NULL,
      0.502054,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.854428,
      1.642411,
      NULL,
      0.787564,
      0,
      3.946082,
      NULL,
      NULL,
      0.060271,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.800313,
      NULL,
      0.259431,
      NULL,
      2.217585,
      1,
      0.688741,
      NULL,
      0,
      1.195695,
      0.496445,
      NULL,
      3,
      1.236935,
      NULL,
      NULL,
      NULL,
      1,
      1.886343,
      NULL,
      8,
      4.550222,
      3,
      NULL,
      1.717504,
      NULL,
      NULL,
      NULL,
      1.050765,
      1.741373,
      2,
      1.459852,
      76.015188,
      71.027816,
      0,
      NULL,
      NULL,
      2.366133,
      25,
      56.303470,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.672238,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.235572,
      1,
      0,
      0.767260,
      1.823378,
      1,
      NULL,
      1.981186,
      0.185845,
      1.920775,
      0.503009,
      0.385071,
      0,
      NULL,
      1.978704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.860991,
      0,
      1,
      4,
      NULL,
      0,
      1.771908,
      2,
      2,
      NULL,
      0,
      1,
      0,
      1.545611,
      NULL,
      1.052517,
      1,
      0.894055,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.391459,
      NULL,
      0,
      3.669890,
      3.491606,
      3.215553,
      2.390395,
      3.538224,
      2,
      0.687464,
      0,
      2,
      1.903319,
      0.430640,
      1.438981,
      0,
      NULL,
      3.165455,
      2.725186,
      3.930934,
      0.791933,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.884870,
      1,
      NULL,
      2,
      NULL,
      0.375450,
      0.990726,
      NULL,
      61.247955,
      5,
      NULL,
      4,
      '11143',
      '33202',
      NULL,
      1.584222,
      NULL,
      NULL,
      NULL,
      2.066190,
      NULL,
      '23424',
      '20223');
commit;
end;
/


