set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7431336';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '11',
      5.725596,
      3,
      '0411434',
      2.117483,
      1.495302,
      3,
      NULL,
      '2310',
      2,
      1.246418,
      NULL,
      NULL,
      ' 3- 8-1997',
      2.931454,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 0-28-1977',
      NULL,
      2,
      2.149196,
      1.680774,
      0,
      0.755688,
      1,
      1,
      0.961929,
      NULL,
      4,
      18,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.580479,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      4.361127,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.638350,
      NULL,
      NULL,
      2,
      NULL,
      0.066813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      5.100396,
      NULL,
      0,
      1,
      1,
      0.380803,
      NULL,
      0.977039,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      0,
      3,
      5,
      5,
      5,
      0,
      NULL,
      3.971917,
      1.647313,
      ' 8- 0-1985',
      214.495167,
      '10-12-1989',
      93.647732,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.413153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9,
      3,
      0.447589,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.118971,
      NULL,
      0.345791,
      1.499985,
      2.927325,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.936310,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      18,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.671760,
      0.846290,
      NULL,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3.713092,
      1,
      2,
      0,
      1,
      1,
      3,
      NULL,
      1.769121,
      0.120288,
      1,
      0,
      0,
      1.806982,
      0,
      1,
      NULL,
      0,
      0,
      11.607561,
      5.022888,
      3,
      4.027235,
      6.832509,
      7.344751,
      NULL,
      1,
      1.888045,
      0,
      3,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      19,
      1,
      NULL,
      0.752332,
      '10411',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.861369,
      '',
      '',
      NULL,
      3,
      23.339869,
      420.465389,
      27.462488,
      1.236500,
      62,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.453979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.562763,
      1,
      NULL,
      0.656735,
      NULL,
      NULL,
      1.514377,
      NULL,
      NULL,
      1.939165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.779612,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464721,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      0.098055,
      NULL,
      NULL,
      0.464359,
      NULL,
      NULL,
      2,
      0,
      0,
      0.930319,
      NULL,
      NULL,
      0,
      0,
      1,
      0.981003,
      3.289767,
      NULL,
      0.767950,
      NULL,
      1.513990,
      0.616025,
      1,
      0.015804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      4,
      1.557280,
      1,
      0.982407,
      NULL,
      NULL,
      NULL,
      3,
      3.719622,
      0.847237,
      0,
      0,
      NULL,
      NULL,
      2.744100,
      2.239821,
      0,
      0.753185,
      1.526876,
      0,
      3,
      3.521697,
      NULL,
      7.010402,
      NULL,
      0,
      NULL,
      0.749397,
      0.447420,
      2,
      1,
      1.593899,
      1,
      2.414053,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378142,
      NULL,
      NULL,
      1.676557,
      NULL,
      NULL,
      0,
      3.368646,
      3,
      1.125255,
      NULL,
      1.900483,
      3.959117,
      3,
      0,
      3.660698,
      NULL,
      2,
      NULL,
      4.232274,
      2,
      11,
      3.309145,
      6,
      0,
      NULL,
      NULL,
      1.743406,
      NULL,
      3,
      1,
      NULL,
      2.571249,
      0.120972,
      3,
      NULL,
      2.111080,
      5.270615,
      NULL,
      0,
      1,
      2.848496,
      NULL,
      2.348156,
      NULL,
      0.308986,
      1,
      3.173465,
      1.109214,
      2,
      3,
      9.012990,
      4,
      NULL,
      1.948583,
      0.892801,
      1,
      3.776113,
      1,
      1,
      NULL,
      0.863429,
      0,
      0.918953,
      1.517963,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882850,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746235,
      NULL,
      NULL,
      0.936498,
      NULL,
      NULL,
      1.155554,
      NULL,
      NULL,
      1.787573,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      1.167374,
      3,
      1.538217,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.356138,
      NULL,
      NULL,
      NULL,
      1.731137,
      1.838972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.154910,
      0.809181,
      NULL,
      NULL,
      2.144596,
      1,
      NULL,
      NULL,
      NULL,
      0.533288,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.549123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.533429,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.429432,
      NULL,
      NULL,
      1,
      0.700264,
      NULL,
      NULL,
      NULL,
      1.621027,
      NULL,
      NULL,
      0.327501,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.255001,
      2.602035,
      NULL,
      540,
      61,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      0,
      NULL,
      NULL,
      0.347313,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.662995,
      0,
      0,
      1,
      1.894691,
      NULL,
      0,
      0.647354,
      1.314620,
      1.499129,
      1.702728,
      0.306998,
      1.027352,
      0.738954,
      1.443417,
      0.948583,
      NULL,
      0.076034,
      0.668136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      11.451353,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.689022,
      0.844145,
      NULL,
      NULL,
      0.033294,
      2.027464,
      3.045444,
      3,
      3,
      3.263047,
      1,
      3.667016,
      3,
      3,
      1.375468,
      3.309723,
      2.386561,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      3.446343,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.581433,
      NULL,
      NULL,
      0,
      4,
      0,
      4,
      2,
      NULL,
      NULL,
      28,
      60,
      1,
      NULL,
      4.350182,
      '24043',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


