set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '1030241',
      1,
      0,
      0,
      2,
      '0241',
      2,
      0,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      1,
      1,
      ' 6- 4-1987',
      35,
      3,
      128.299252,
      0.706055,
      3,
      ' 2- 0-1980',
      ' 1-15-1986',
      '10-14-1984',
      0,
      3.087188,
      NULL,
      1,
      0.314660,
      0.695505,
      0,
      NULL,
      1,
      NULL,
      2,
      0.602429,
      6,
      6,
      8,
      1,
      NULL,
      NULL,
      0,
      6,
      NULL,
      2,
      0,
      1,
      NULL,
      1.874863,
      1.824259,
      0.593785,
      NULL,
      1.398377,
      0.929226,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      5,
      5,
      1,
      1,
      2,
      8.703895,
      0,
      NULL,
      0,
      2,
      0.339411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0.224851,
      NULL,
      0,
      0.998727,
      0.457976,
      1,
      1,
      1,
      NULL,
      1.322266,
      0,
      1.399561,
      1,
      2,
      1.236182,
      1.528588,
      1.718736,
      1,
      1,
      4,
      1.422211,
      1,
      2,
      NULL,
      0.119729,
      NULL,
      NULL,
      1.744042,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      4,
      5,
      0,
      1,
      1,
      NULL,
      0,
      3,
      1,
      1,
      3,
      0,
      4,
      1,
      5,
      3,
      3,
      NULL,
      3,
      5,
      2,
      2.802262,
      ' 3-17-1993',
      104,
      ' 9-10-1975',
      NULL,
      0.975511,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.973627,
      0,
      0.042391,
      NULL,
      NULL,
      NULL,
      1,
      0.747167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.144442,
      0.076940,
      NULL,
      1,
      1.761991,
      1,
      2.888189,
      28.426551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.380069,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      2,
      1,
      0,
      NULL,
      0.755337,
      0,
      5,
      1.051955,
      1,
      NULL,
      0,
      0,
      0.737135,
      0,
      NULL,
      NULL,
      1,
      0.199205,
      1,
      0,
      0.067692,
      1,
      9.282151,
      NULL,
      4.522358,
      2.388489,
      NULL,
      4,
      NULL,
      0.713796,
      7,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.884013,
      '20440',
      '24040',
      '',
      1.401590,
      '44342',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      20.714702,
      286.224778,
      17,
      1.119545,
      60,
      2,
      18,
      0,
      1,
      3.913814,
      NULL,
      0,
      NULL,
      NULL,
      0.982092,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.562817,
      3.979346,
      0.702708,
      NULL,
      NULL,
      3.701563,
      NULL,
      NULL,
      NULL,
      2.617420,
      3.335636,
      NULL,
      NULL,
      1.127822,
      NULL,
      NULL,
      NULL,
      1.182759,
      0.049621,
      NULL,
      3.829710,
      1,
      1,
      9,
      0,
      3,
      1,
      1.585342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.637076,
      NULL,
      3,
      0,
      0.650675,
      NULL,
      2,
      1.679542,
      NULL,
      1.246187,
      0.396237,
      1.894275,
      NULL,
      1.214765,
      2,
      0.919117,
      NULL,
      NULL,
      0.834479,
      NULL,
      NULL,
      2.730203,
      0.170031,
      0,
      NULL,
      1.880410,
      0,
      1,
      1.371399,
      NULL,
      NULL,
      NULL,
      0.420122,
      NULL,
      NULL,
      NULL,
      1.451631,
      NULL,
      NULL,
      NULL,
      1.577018,
      3.937891,
      2,
      1.382289,
      1.544072,
      NULL,
      NULL,
      NULL,
      6.353434,
      4.847104,
      5,
      0.049484,
      1,
      1.729513,
      0.572343,
      NULL,
      0,
      1.268299,
      1,
      0,
      1,
      NULL,
      NULL,
      0.426134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328705,
      NULL,
      NULL,
      1.055211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.234175,
      1.344475,
      1,
      NULL,
      1,
      0.692481,
      1.687183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      1.803888,
      NULL,
      NULL,
      2,
      3.147042,
      NULL,
      NULL,
      NULL,
      0.268302,
      NULL,
      1.964305,
      2.047513,
      2,
      2.446170,
      3.658465,
      0,
      0,
      2.353786,
      6,
      4.542084,
      NULL,
      NULL,
      0.389013,
      2,
      4,
      1,
      0.324548,
      NULL,
      1.243171,
      0.754978,
      3,
      NULL,
      NULL,
      1.984114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.870332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676019,
      1.062769,
      0.744392,
      0.586869,
      0,
      1,
      NULL,
      NULL,
      1,
      0.747490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848959,
      0.139008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.955787,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.152570,
      1.529534,
      NULL,
      NULL,
      0,
      0.421521,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.433622,
      0.253944,
      NULL,
      NULL,
      NULL,
      1.348818,
      NULL,
      NULL,
      0.638391,
      NULL,
      NULL,
      NULL,
      2.893008,
      19.489979,
      NULL,
      0.784578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076157,
      NULL,
      NULL,
      1.164674,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.354726,
      1,
      NULL,
      1,
      0,
      NULL,
      1.964372,
      0.398576,
      NULL,
      NULL,
      1.535052,
      NULL,
      0,
      0.678051,
      0.265783,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271409,
      NULL,
      1,
      NULL,
      0,
      NULL,
      43.177937,
      NULL,
      1.167880,
      NULL,
      34.643746,
      NULL,
      NULL,
      1,
      NULL,
      1.434966,
      NULL,
      NULL,
      NULL,
      1.005199,
      NULL,
      0.771758,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.907789,
      NULL,
      1.923496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817010,
      NULL,
      1.591428,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332858,
      1.306034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.842016,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.844348,
      NULL,
      0.231836,
      0.932594,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      7,
      1.438103,
      0,
      3.869937,
      2,
      3,
      NULL,
      0.559537,
      3,
      0.395340,
      3,
      1,
      0.858586,
      NULL,
      0.887523,
      3.227088,
      0,
      0.967205,
      1.135345,
      0,
      1.563547,
      3.767643,
      0,
      NULL,
      0.169519,
      1,
      0.603936,
      3,
      3,
      2,
      1,
      0,
      0,
      3,
      3.497660,
      1,
      0.433449,
      NULL,
      NULL,
      0.330615,
      0.638458,
      NULL,
      NULL,
      0,
      1.179663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393762,
      0.099408,
      NULL,
      0.351012,
      1.442680,
      0.297433,
      0,
      NULL,
      4,
      0,
      1.824176,
      1,
      68,
      100,
      NULL,
      0,
      4,
      '41144',
      '10013',
      '',
      NULL,
      '00031',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


