set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1003024',
      1,
      1,
      3,
      3,
      '1140',
      2.475517,
      0.686505,
      NULL,
      NULL,
      NULL,
      40.360267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      36,
      82,
      0,
      '11-22-2001',
      ' 7- 2-1982',
      ' 9-29-1989',
      0,
      0,
      1.368460,
      2,
      0,
      1,
      1,
      0,
      1.474958,
      128.109803,
      0,
      19,
      NULL,
      17.328451,
      1,
      4,
      4.546918,
      4,
      2,
      7.196126,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1.651398,
      0,
      1,
      0,
      1,
      1,
      3,
      0,
      2,
      4,
      0,
      0,
      2,
      1,
      0,
      3,
      NULL,
      0,
      0,
      2,
      2,
      8.883755,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.444575,
      3.340864,
      3,
      0,
      0,
      1,
      0.335806,
      0.710063,
      0.464945,
      0.551925,
      NULL,
      0.516042,
      3.061147,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1.203611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      3,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.489807,
      NULL,
      1.136244,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      0,
      4,
      0,
      1,
      NULL,
      2,
      5,
      2,
      0,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      3,
      ' 0-12-1988',
      795,
      '11-26-1995',
      60.976658,
      0.447389,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0.105087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.029423,
      NULL,
      NULL,
      NULL,
      3.793094,
      1,
      1,
      3,
      3,
      NULL,
      1.230887,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.148143,
      1.236773,
      NULL,
      1,
      NULL,
      0,
      2,
      37.492495,
      NULL,
      0.158348,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.544257,
      1,
      0,
      3,
      3,
      3,
      3,
      3,
      NULL,
      0,
      3,
      3.792187,
      1.895870,
      3.062210,
      1,
      1,
      0.013895,
      2.610944,
      1,
      NULL,
      0.882753,
      NULL,
      0.543958,
      1,
      0,
      0.991333,
      0,
      3,
      NULL,
      0.259831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642468,
      NULL,
      6,
      1,
      25,
      0,
      1,
      1,
      '30324',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      10.991163,
      NULL,
      59.539666,
      5.007333,
      9.164913,
      NULL,
      1,
      2.346548,
      1.048646,
      0.438640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.543999,
      1.613624,
      1.502291,
      3.448121,
      NULL,
      NULL,
      1,
      NULL,
      0.264400,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.876640,
      0.829207,
      0,
      NULL,
      NULL,
      NULL,
      1.642716,
      NULL,
      3.660268,
      1.016786,
      1.917256,
      3,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.201312,
      6,
      NULL,
      NULL,
      1.001991,
      NULL,
      NULL,
      1.361903,
      3.691194,
      2,
      1.945459,
      1,
      0.655054,
      0.173325,
      0,
      1.892022,
      0,
      0,
      NULL,
      0,
      1.073488,
      1.397982,
      1.958800,
      18.524567,
      NULL,
      NULL,
      1.563668,
      1,
      1,
      0.570344,
      0.514482,
      0,
      3,
      2,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.795169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.254121,
      1,
      1.455462,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.443211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992339,
      NULL,
      NULL,
      0.987224,
      NULL,
      NULL,
      2,
      0,
      1,
      0.007167,
      NULL,
      NULL,
      1,
      2,
      3.674655,
      7.856833,
      2.654911,
      3,
      1.094886,
      0.085869,
      1.273849,
      NULL,
      0.357091,
      1,
      1,
      NULL,
      1.458942,
      2,
      3,
      NULL,
      5.482188,
      3.874374,
      5,
      2.164490,
      1.589341,
      2,
      0.929974,
      3.634902,
      2.600556,
      2,
      3,
      2,
      NULL,
      0.665090,
      0.638264,
      6,
      1.322077,
      2,
      3,
      NULL,
      NULL,
      1.652079,
      NULL,
      NULL,
      1,
      0.306352,
      1.081115,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.140206,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.060364,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.306497,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.176965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.995286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.200352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.615578,
      NULL,
      NULL,
      NULL,
      0.782237,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.407580,
      NULL,
      NULL,
      NULL,
      3.822528,
      NULL,
      NULL,
      0.001343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.851462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      44.140916,
      1,
      NULL,
      1.642957,
      1.486235,
      0.171714,
      NULL,
      1.895716,
      NULL,
      0.905864,
      NULL,
      0.596556,
      0.293114,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.064918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      11.947030,
      6.205592,
      0.931331,
      3.315744,
      2,
      18,
      NULL,
      NULL,
      0.150495,
      3.246044,
      1.036343,
      NULL,
      1.090368,
      3,
      NULL,
      NULL,
      1.033289,
      NULL,
      14,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.957521,
      NULL,
      1,
      1.289891,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.719854,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401338,
      NULL,
      1,
      NULL,
      1.200946,
      NULL,
      3,
      4,
      7,
      3.611341,
      NULL,
      0.305196,
      34,
      64.932602,
      NULL,
      0,
      0.697239,
      '22443',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.018968,
      '',
      '',
      NULL);
commit;
end;
/


