set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3103144',
      1.809187,
      NULL,
      4,
      1,
      '2021',
      1.096538,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1979',
      NULL,
      NULL,
      4,
      1,
      4,
      '10- 4-1979',
      21,
      1.593770,
      163,
      125,
      2,
      ' 3- 1-1984',
      ' 0-25-1984',
      ' 9- 9-2000',
      2,
      0.271724,
      2.826553,
      1.139067,
      0,
      2,
      NULL,
      0.247914,
      NULL,
      182,
      4,
      5.187705,
      5,
      3.513709,
      NULL,
      NULL,
      3.906123,
      1,
      0,
      5,
      0,
      2,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0.516256,
      0.766940,
      NULL,
      5,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      4,
      5,
      4.677560,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      1.413159,
      1,
      1,
      1.933849,
      1,
      NULL,
      0,
      3,
      2,
      0.916674,
      0.209698,
      1,
      NULL,
      3.786457,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      1,
      0,
      4,
      1,
      0,
      5,
      5,
      1,
      1,
      0.705239,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.115228,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      2,
      4,
      0,
      NULL,
      4,
      2,
      NULL,
      4,
      0,
      2,
      3,
      0,
      3,
      NULL,
      0.448794,
      ' 2-17-1988',
      331,
      NULL,
      100.167131,
      3.263437,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.812404,
      3,
      NULL,
      7.313323,
      1.055983,
      1.944006,
      0,
      NULL,
      NULL,
      NULL,
      1.576239,
      5,
      0.181195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422782,
      0,
      1.179464,
      1.017021,
      1.775669,
      1.361172,
      0,
      NULL,
      NULL,
      1.076218,
      0.685111,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.346082,
      1,
      1,
      1,
      3,
      0,
      NULL,
      2,
      3,
      2,
      1,
      7.901890,
      2,
      NULL,
      NULL,
      NULL,
      1.192707,
      0.845024,
      1.545814,
      1.708166,
      0,
      0,
      1.363600,
      NULL,
      1.927548,
      1.652110,
      1,
      1,
      1,
      1.743354,
      NULL,
      7.834000,
      7,
      3.593700,
      NULL,
      7.173197,
      1.313033,
      0.384969,
      5.082130,
      1.491620,
      NULL,
      3.522107,
      64.566141,
      2,
      0.802450,
      NULL,
      10,
      12,
      22.219818,
      5,
      NULL,
      3,
      '30401',
      '40400',
      '',
      NULL,
      '',
      '',
      '',
      4.594999,
      '3441',
      '0300',
      '4033',
      NULL,
      NULL,
      NULL,
      20.682060,
      2.383405,
      0.778836,
      NULL,
      NULL,
      2,
      2.226880,
      2,
      0.688855,
      1.364682,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.606926,
      2,
      2.041364,
      2.910475,
      NULL,
      2,
      NULL,
      NULL,
      3.405833,
      0.488285,
      2,
      2.077109,
      3.291913,
      2,
      3.065800,
      0,
      NULL,
      1.380868,
      NULL,
      NULL,
      NULL,
      3.100982,
      1,
      2.646818,
      1,
      0.206813,
      6,
      5.718796,
      4,
      1,
      0.262500,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.062884,
      1.488397,
      0.265022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.470220,
      0,
      1.533652,
      1.939388,
      0.114648,
      0.351551,
      3,
      3,
      0,
      NULL,
      1,
      0,
      0.275266,
      2.748455,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.190990,
      5,
      1.480729,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.534064,
      NULL,
      NULL,
      NULL,
      0.300970,
      NULL,
      NULL,
      1.631640,
      2,
      NULL,
      1.765436,
      0.323865,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      1.512594,
      0,
      1.691834,
      NULL,
      1.969401,
      NULL,
      0,
      0,
      1.034463,
      NULL,
      NULL,
      0.480679,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.559599,
      NULL,
      NULL,
      1.485179,
      NULL,
      NULL,
      3.399729,
      1.139302,
      3.013892,
      2.819023,
      0.565667,
      0.550269,
      3,
      NULL,
      2.933069,
      4.520565,
      0,
      0,
      7,
      1,
      1,
      NULL,
      1.016759,
      NULL,
      2.472177,
      3,
      1,
      0.674933,
      NULL,
      1.883065,
      2.102950,
      NULL,
      0,
      1.345557,
      1.185130,
      2.432289,
      NULL,
      2,
      3,
      1.000196,
      NULL,
      3.964044,
      NULL,
      0.218331,
      2,
      8,
      0.045347,
      NULL,
      NULL,
      NULL,
      0.088276,
      3.400148,
      2,
      NULL,
      0.858643,
      1,
      1.266785,
      1.030353,
      1.292111,
      NULL,
      NULL,
      NULL,
      1.993752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.422217,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.010337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.796354,
      NULL,
      NULL,
      NULL,
      1.795305,
      1.598393,
      1.509784,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.358987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.304587,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.858201,
      0,
      NULL,
      NULL,
      0.236085,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717204,
      NULL,
      NULL,
      NULL,
      0.764326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.063490,
      0.152299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.743218,
      13,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.576503,
      NULL,
      13.652249,
      1,
      0,
      1,
      1.208615,
      0.733074,
      0.071334,
      2.419245,
      NULL,
      2.925130,
      1,
      0.263007,
      0,
      1,
      0,
      0,
      0.334769,
      0,
      NULL,
      0.472768,
      NULL,
      0.914753,
      NULL,
      0,
      NULL,
      1.506565,
      NULL,
      0,
      NULL,
      22.506486,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395551,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.983961,
      NULL,
      0,
      NULL,
      1.807414,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.394422,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620464,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.720384,
      NULL,
      0,
      1.011960,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      4,
      5,
      0.028545,
      5,
      1,
      18.690784,
      2.152962,
      0.826638,
      3,
      3.096530,
      3,
      1.857240,
      1.974688,
      0,
      0.477654,
      1,
      0,
      0,
      1.558531,
      0,
      1.346768,
      0,
      3,
      1.061467,
      0,
      NULL,
      1,
      0,
      3.036494,
      0.008530,
      1.116723,
      NULL,
      1,
      0,
      0,
      0.835322,
      2.998570,
      3.536423,
      2,
      1.666933,
      1.469148,
      0,
      NULL,
      2.415491,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424331,
      1.495637,
      0.436009,
      1.853707,
      1.356752,
      0,
      3,
      5,
      4,
      1.168994,
      NULL,
      0,
      36.470633,
      95.141453,
      2,
      0.249948,
      1.048557,
      '14210',
      '24241',
      NULL,
      0.261475,
      '43214',
      '',
      '',
      7,
      NULL,
      '0103',
      '0414');
commit;
end;
/


