set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '10',
      5,
      2,
      '4444211',
      3.039242,
      0,
      3,
      0,
      '2130',
      2.628376,
      1.474062,
      NULL,
      NULL,
      NULL,
      22.274935,
      36.109853,
      NULL,
      2,
      1.906662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 6-21-1989',
      NULL,
      0.872176,
      2,
      1,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.762320,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.328015,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1.940779,
      0,
      0.109192,
      1.655678,
      NULL,
      2,
      NULL,
      3.837226,
      0,
      1,
      0,
      0,
      0,
      0,
      2,
      1,
      2,
      1,
      NULL,
      0,
      6,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      3.286892,
      2,
      1,
      0,
      1,
      0.313668,
      1.665922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      3,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.794442,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      5,
      0,
      4,
      NULL,
      NULL,
      3,
      2,
      0,
      1,
      3,
      2,
      0,
      3,
      1,
      NULL,
      ' 4- 3-1986',
      2082,
      ' 2-25-1985',
      509.886365,
      3.500621,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.428506,
      0,
      2,
      1,
      NULL,
      2,
      0.649278,
      NULL,
      1,
      0.256225,
      0.693798,
      3.839841,
      1,
      0,
      1.846740,
      2,
      7.288854,
      0.806359,
      0,
      6.067376,
      1.186771,
      1,
      2,
      NULL,
      0,
      3.301805,
      0.356048,
      NULL,
      1,
      2,
      0.098652,
      ' 3-25-2002',
      1,
      NULL,
      13,
      0.083741,
      1,
      0.741916,
      NULL,
      0,
      1.943568,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      3,
      0,
      3,
      2,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0.393403,
      1,
      NULL,
      0,
      1,
      0.724386,
      1,
      0.828441,
      0.320906,
      1,
      1.586531,
      1.115447,
      0,
      0,
      3.157776,
      0,
      NULL,
      4,
      3,
      NULL,
      2.177145,
      7,
      3,
      0,
      NULL,
      2.604820,
      NULL,
      2,
      16,
      0,
      1,
      NULL,
      NULL,
      45,
      3,
      3,
      NULL,
      2,
      '33221',
      '43434',
      '',
      NULL,
      '10120',
      '',
      '',
      0.372915,
      '0434',
      '0021',
      '',
      NULL,
      17.161708,
      NULL,
      23,
      3,
      5.125499,
      0.525360,
      3.611084,
      1,
      NULL,
      NULL,
      0.447594,
      1.146836,
      NULL,
      NULL,
      0.504313,
      NULL,
      NULL,
      1.728360,
      1.623541,
      0.038734,
      1,
      2.238593,
      NULL,
      1.346897,
      NULL,
      0,
      2,
      1.090255,
      3.634175,
      2.545160,
      1,
      NULL,
      0.439793,
      0.927928,
      0.888629,
      1,
      NULL,
      NULL,
      1.008041,
      3.216781,
      3.765050,
      1.646467,
      0,
      1,
      7,
      NULL,
      5.797535,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.780069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.248544,
      1,
      NULL,
      NULL,
      0.116716,
      NULL,
      NULL,
      NULL,
      1.824237,
      1,
      2,
      NULL,
      0,
      1.579165,
      0.965850,
      0,
      NULL,
      1.977804,
      3.455564,
      3,
      1.323811,
      0.773694,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.332040,
      1.938059,
      1,
      2,
      1.527037,
      2,
      0,
      1.051289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.005113,
      3.045101,
      2.022296,
      NULL,
      NULL,
      0,
      0.259681,
      NULL,
      NULL,
      NULL,
      3.152105,
      3.678789,
      NULL,
      0,
      0.716597,
      3.925401,
      0,
      0.974860,
      6.019529,
      0.064146,
      0.950409,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.289922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187919,
      NULL,
      NULL,
      0.530473,
      0,
      NULL,
      0.847102,
      0,
      0.151624,
      3,
      5,
      1.700850,
      NULL,
      0.319292,
      3.397192,
      3.363786,
      NULL,
      NULL,
      2.263210,
      NULL,
      3,
      1,
      1,
      0.650262,
      0.504179,
      0,
      3,
      NULL,
      6.283276,
      5,
      2,
      NULL,
      3.854455,
      NULL,
      NULL,
      2,
      0.822809,
      NULL,
      2.395414,
      1.996232,
      3,
      NULL,
      4,
      4,
      2.951378,
      7.739697,
      NULL,
      3.121961,
      NULL,
      1,
      2,
      NULL,
      1,
      1.990480,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.391599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.399767,
      NULL,
      NULL,
      1.757468,
      NULL,
      NULL,
      2,
      3.137912,
      1.070339,
      1.417448,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881002,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.644517,
      NULL,
      NULL,
      NULL,
      3.969194,
      NULL,
      NULL,
      NULL,
      0.014649,
      NULL,
      NULL,
      NULL,
      1.912126,
      NULL,
      NULL,
      NULL,
      0.391240,
      NULL,
      NULL,
      NULL,
      1.352881,
      1,
      NULL,
      NULL,
      0.488946,
      1,
      NULL,
      NULL,
      1.264482,
      1.227702,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.811538,
      NULL,
      NULL,
      NULL,
      1,
      1.824047,
      NULL,
      NULL,
      1,
      1.243119,
      NULL,
      NULL,
      9.941422,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      45.220912,
      9.831473,
      3.073876,
      7.143035,
      2.402916,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.727536,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690531,
      NULL,
      30.221620,
      1.858152,
      NULL,
      1.671823,
      NULL,
      1.723057,
      1.203039,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.158288,
      0.336037,
      1,
      0,
      NULL,
      0,
      NULL,
      0.979647,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      105,
      NULL,
      3.731862,
      NULL,
      NULL,
      0,
      1.749145,
      NULL,
      NULL,
      0.439110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.645703,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.879886,
      NULL,
      1.080246,
      NULL,
      NULL,
      2.188484,
      0,
      0.578785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371589,
      0.489088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.525273,
      NULL,
      0,
      1,
      0.143638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      5,
      1.024332,
      2.475779,
      3,
      0,
      NULL,
      2,
      0,
      0.984639,
      2.689432,
      2.146695,
      0.164311,
      1.168583,
      1,
      1.564864,
      2.917652,
      2,
      0,
      1,
      0.033920,
      0,
      3,
      1.026832,
      1.616576,
      1,
      1.557912,
      NULL,
      NULL,
      NULL,
      2.420155,
      NULL,
      0,
      NULL,
      2.906421,
      NULL,
      0.153693,
      1,
      0,
      1.750916,
      1.313282,
      1.114339,
      0.720495,
      NULL,
      2.019614,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794355,
      1,
      0.094786,
      1.243678,
      0.704365,
      1,
      NULL,
      0,
      0,
      3,
      0.241861,
      2,
      18.736136,
      68,
      2,
      5.723512,
      NULL,
      NULL,
      '11424',
      '',
      3,
      '33432',
      NULL,
      '',
      1,
      '0244',
      NULL,
      '');
commit;
end;
/


