set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0182143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.710828,
      NULL,
      0,
      2.339089,
      2.071718,
      3.958580,
      2.203762,
      '222',
      '41130014',
      34,
      73.668643,
      '4302402',
      0.752842,
      0,
      2,
      3,
      NULL,
      3.985427,
      1,
      NULL,
      NULL,
      '11-27-1994',
      46.963323,
      36.120079,
      NULL,
      0,
      1.071042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 0-13-1979',
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      1.714223,
      0.879133,
      0.936072,
      0,
      1,
      1,
      NULL,
      2,
      4,
      NULL,
      3.411185,
      0,
      1,
      0,
      1,
      NULL,
      0,
      4,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.286179,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.716070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      2,
      4,
      NULL,
      1,
      NULL,
      0,
      4,
      2,
      1,
      5,
      1,
      1,
      0,
      1,
      0,
      2,
      ' 2-18-1999',
      125,
      ' 4-16-1984',
      126.742136,
      0.168629,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.795435,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.972202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.536610,
      NULL,
      1,
      1.556247,
      1,
      NULL,
      3,
      1.244717,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.955546,
      3,
      0,
      2,
      1,
      NULL,
      0,
      3,
      NULL,
      2,
      2,
      2.410901,
      1,
      3.538311,
      0,
      NULL,
      0,
      NULL,
      1,
      1.633039,
      1,
      NULL,
      1.585947,
      0,
      1.058751,
      NULL,
      1,
      1,
      1.121097,
      0,
      4,
      8,
      2.396345,
      2.133231,
      2.528575,
      6.365300,
      0.603664,
      2,
      4.585256,
      1.412250,
      3.154733,
      NULL,
      18,
      NULL,
      1.812004,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.678632,
      11,
      61,
      NULL,
      NULL,
      28,
      NULL,
      0,
      5,
      1.817484,
      1.137077,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.300776,
      0.575608,
      2.670057,
      1.863757,
      0.974008,
      1.777746,
      NULL,
      NULL,
      NULL,
      3.656061,
      NULL,
      1,
      3,
      0.369750,
      0,
      3,
      0.006387,
      0.342598,
      NULL,
      0.452240,
      0,
      3.793945,
      0.804793,
      1.218173,
      3,
      0.717240,
      3.902726,
      0,
      0,
      1.977727,
      1,
      2,
      1,
      NULL,
      0.824819,
      1.898437,
      1,
      1.037057,
      NULL,
      2,
      0.937711,
      2,
      1.856511,
      2,
      0.381580,
      1,
      0,
      1,
      0.145399,
      NULL,
      NULL,
      NULL,
      0,
      3.762632,
      1,
      1,
      NULL,
      0,
      0.541130,
      NULL,
      0.019439,
      0,
      0.539727,
      0.523000,
      NULL,
      1.199456,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      9,
      3.014812,
      NULL,
      NULL,
      NULL,
      1.641107,
      2.097618,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.023927,
      2,
      0.704525,
      1.169717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      0,
      7,
      5.753103,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.041846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.711332,
      NULL,
      1,
      1.274554,
      NULL,
      NULL,
      1,
      0,
      5.393739,
      0.311725,
      1,
      3,
      0.286084,
      NULL,
      NULL,
      NULL,
      2,
      1.224397,
      3.813912,
      1,
      0.485809,
      2,
      1.085667,
      0.965393,
      3.334961,
      3,
      NULL,
      2.757777,
      2,
      1,
      2,
      NULL,
      1,
      1.424633,
      3,
      1,
      NULL,
      3,
      NULL,
      2,
      1.197007,
      NULL,
      NULL,
      6,
      3,
      NULL,
      0,
      0,
      0.452094,
      1,
      2,
      1,
      2,
      0.111247,
      NULL,
      7,
      5.187271,
      NULL,
      4,
      NULL,
      NULL,
      1.196096,
      3.980553,
      NULL,
      2,
      1.733401,
      NULL,
      1.487947,
      1,
      NULL,
      3.671858,
      1,
      NULL,
      2,
      1.474855,
      NULL,
      2,
      2,
      NULL,
      0,
      3.093708,
      NULL,
      3.765970,
      1.405504,
      NULL,
      3.145605,
      0.894048,
      NULL,
      0.589392,
      1.133742,
      NULL,
      NULL,
      3,
      NULL,
      9,
      7.362178,
      NULL,
      2.236277,
      1.814938,
      3.249696,
      3,
      0,
      NULL,
      3,
      0,
      NULL,
      4.694390,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      0.454988,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.974127,
      NULL,
      NULL,
      0.568769,
      1.403480,
      NULL,
      NULL,
      2.799324,
      3.377852,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0.036567,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.466010,
      NULL,
      NULL,
      1.925205,
      0.413613,
      NULL,
      NULL,
      1.584856,
      0.869627,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.355208,
      3,
      NULL,
      NULL,
      2.425413,
      3,
      NULL,
      NULL,
      2.504882,
      1.211665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106872,
      NULL,
      NULL,
      3.135029,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      20,
      1,
      42.634702,
      3.576510,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967399,
      NULL,
      NULL,
      1.013105,
      NULL,
      0.011776,
      64,
      0.016188,
      1,
      1.528478,
      1.321391,
      NULL,
      0,
      0,
      1,
      1.715133,
      NULL,
      1.716561,
      1,
      0.689047,
      1,
      NULL,
      0,
      0,
      1,
      0.254694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861528,
      NULL,
      1.411252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478888,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.074613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063047,
      2,
      NULL,
      0.111926,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.987198,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      7,
      3,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      2.146996,
      0,
      1.233191,
      0,
      1,
      2.851015,
      0.400518,
      1,
      3,
      1,
      1,
      0.984616,
      1.856107,
      0,
      NULL,
      0.819535,
      1.954713,
      0.730757,
      0,
      0.936429,
      0,
      NULL,
      0.016544,
      2,
      1,
      1.324416,
      NULL,
      0.666785,
      NULL,
      NULL,
      2,
      1,
      1.506417,
      NULL,
      0.009607,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689852,
      0.555990,
      NULL,
      1,
      1.556088,
      1.857966,
      4,
      0,
      3,
      1.893720,
      NULL,
      NULL,
      81.273639,
      4.913978,
      NULL,
      NULL,
      3,
      '13121',
      NULL,
      '',
      1.643952,
      '',
      '',
      NULL,
      0.852670,
      '',
      '',
      '');
commit;
end;
/


