set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8608370';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      '4211',
      1,
      NULL,
      1,
      36.918649,
      ' 8-28-1986',
      70.487803,
      NULL,
      0,
      1,
      0,
      ' 6- 3-1995',
      34.964831,
      2.825182,
      211,
      81.795339,
      NULL,
      NULL,
      NULL,
      ' 6-21-1976',
      0.674421,
      0,
      2,
      NULL,
      NULL,
      0.093017,
      2,
      NULL,
      1.639855,
      58,
      NULL,
      4,
      NULL,
      23,
      17.065227,
      0,
      28,
      1,
      NULL,
      10,
      3.745907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      4,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.618991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      3,
      1,
      0,
      0,
      1,
      3,
      3,
      1,
      4,
      NULL,
      3,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      4,
      NULL,
      0,
      0,
      0,
      0,
      1.466523,
      0.337036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.997420,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.714809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.992004,
      1,
      NULL,
      1.201447,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.272371,
      1,
      1,
      0,
      0,
      2,
      1,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      1.075305,
      NULL,
      NULL,
      NULL,
      3.221969,
      1,
      0,
      0,
      NULL,
      NULL,
      0.607515,
      1.594367,
      1,
      0,
      3,
      0,
      3,
      6.635966,
      NULL,
      7.924944,
      9.668362,
      6,
      2.967285,
      NULL,
      6,
      0.033480,
      2,
      1,
      70.975221,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      '24302',
      '',
      '',
      1.610532,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.916761,
      NULL,
      5,
      NULL,
      2,
      20.634216,
      2.646441,
      3.607582,
      4,
      0.902796,
      6.373698,
      1.712088,
      0.239033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4.632043,
      1.555771,
      NULL,
      1.264833,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842268,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.636203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.924722,
      5,
      0.458333,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.179129,
      NULL,
      NULL,
      NULL,
      8.450769,
      NULL,
      NULL,
      2.569881,
      3.259474,
      0.520958,
      0.723942,
      1,
      NULL,
      NULL,
      0.462839,
      0,
      0,
      0,
      0.142913,
      1.565151,
      0,
      1,
      0.406837,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.559251,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081165,
      0.280511,
      0,
      13.281109,
      0,
      NULL,
      NULL,
      2,
      3,
      0.780842,
      1.355816,
      0.998345,
      0,
      3.920503,
      6,
      NULL,
      NULL,
      2.501260,
      5.387788,
      3.005628,
      16.078261,
      0,
      2,
      2,
      1,
      7,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.197675,
      NULL,
      NULL,
      1.530227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674024,
      NULL,
      NULL,
      3.137336,
      0,
      2.120539,
      0,
      NULL,
      NULL,
      0.503550,
      3,
      0,
      9,
      2.142173,
      0,
      3.056127,
      NULL,
      NULL,
      3,
      6,
      1,
      NULL,
      1.925538,
      3,
      1.791063,
      3.623326,
      3,
      2.337439,
      2.940495,
      8,
      1.806942,
      2.436825,
      0.398264,
      1,
      NULL,
      1,
      1.104258,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.332518,
      5.853017,
      5,
      1,
      4,
      3,
      NULL,
      1,
      0.177728,
      1,
      0.457185,
      0.758904,
      NULL,
      NULL,
      1.795028,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779517,
      NULL,
      NULL,
      1.796416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.757487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.266988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.925535,
      0.143006,
      NULL,
      2,
      0.689552,
      1,
      NULL,
      2,
      1.351800,
      3.255420,
      NULL,
      NULL,
      NULL,
      0.836616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981505,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.833222,
      NULL,
      0.629781,
      NULL,
      3.996950,
      NULL,
      NULL,
      NULL,
      11.394982,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.601580,
      NULL,
      2.670515,
      NULL,
      3.893460,
      1,
      0.245874,
      NULL,
      1.840555,
      0,
      NULL,
      NULL,
      3.865626,
      2,
      0,
      NULL,
      0,
      NULL,
      1.230118,
      NULL,
      1,
      NULL,
      2.813151,
      NULL,
      0,
      NULL,
      0.973860,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      3,
      3.940912,
      NULL,
      1,
      0.325813,
      5,
      3,
      2,
      255.094235,
      24.467318,
      3,
      282.648066,
      1862,
      0,
      NULL,
      NULL,
      1.418994,
      NULL,
      NULL,
      2.124690,
      NULL,
      932.055480,
      0.946746,
      NULL,
      NULL,
      0,
      9.843237,
      0.197587,
      423,
      1,
      NULL,
      0,
      0,
      1.774341,
      NULL,
      1.547526,
      0,
      0,
      0.375976,
      1,
      NULL,
      1.608676,
      0,
      1.496994,
      1,
      1,
      1.775353,
      2.251466,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.372926,
      NULL,
      1.627980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.612906,
      0.593954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461689,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.826225,
      NULL,
      3.118157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290457,
      NULL,
      0,
      0.931588,
      1.657468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.335484,
      1,
      1.936805,
      NULL,
      0,
      4.458065,
      NULL,
      2.487361,
      0.963584,
      NULL,
      NULL,
      0.731653,
      0.541148,
      0.234411,
      1,
      NULL,
      2.413270,
      1,
      1.178389,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      1,
      0,
      1,
      NULL,
      3.001875,
      1.646578,
      0,
      0,
      0.182714,
      0,
      NULL,
      0,
      2.508804,
      0,
      1.505254,
      1,
      0.763714,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508661,
      NULL,
      0.660072,
      1,
      1.317665,
      1.278602,
      NULL,
      NULL,
      3,
      3.547343,
      NULL,
      2,
      NULL,
      46.145820,
      2,
      0,
      NULL,
      '42212',
      '',
      '',
      1.011158,
      '',
      '',
      NULL,
      0.232739,
      '',
      NULL,
      '');
commit;
end;
/


