set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.505496,
      2,
      NULL,
      3.594896,
      7,
      2,
      3.351237,
      2,
      NULL,
      '13333334',
      NULL,
      51,
      '4401443',
      4.702116,
      1.914078,
      2,
      3,
      '2243',
      1.865055,
      1.779210,
      NULL,
      NULL,
      ' 8- 8-2002',
      175,
      31.914675,
      NULL,
      0,
      NULL,
      ' 3-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.883833,
      0,
      1,
      1.895384,
      0,
      1.772468,
      1.528211,
      4.910176,
      3,
      9,
      0.691194,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      1.057764,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.406043,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      7.142356,
      NULL,
      NULL,
      NULL,
      0,
      0.513440,
      NULL,
      NULL,
      0.307764,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      0.012120,
      NULL,
      0,
      NULL,
      1.082568,
      1,
      0.403666,
      1.384417,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      1,
      1,
      5,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      4,
      0,
      4,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      5,
      1,
      3,
      0,
      1,
      5,
      1,
      NULL,
      5,
      2,
      1,
      4,
      1,
      1,
      1,
      2.205321,
      2,
      ' 1-10-1976',
      629,
      ' 0-21-1982',
      197.439209,
      3.724319,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11.909704,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.933187,
      7.908506,
      NULL,
      0,
      2.867887,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.861270,
      1,
      0,
      1,
      NULL,
      0.402966,
      NULL,
      NULL,
      NULL,
      1.604692,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795218,
      0,
      3,
      2,
      3,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      0.167497,
      1,
      2.633992,
      0,
      0,
      1.128090,
      0.583022,
      1.409433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.431987,
      NULL,
      NULL,
      0.824350,
      4,
      NULL,
      NULL,
      2.256010,
      4,
      NULL,
      0,
      3,
      2.503832,
      2.342558,
      NULL,
      3,
      1,
      20,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '41434',
      '',
      '',
      0.056227,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.963462,
      2,
      83.022185,
      36.349003,
      1.314258,
      5.620495,
      1.189027,
      2,
      NULL,
      3,
      1,
      0,
      0.843626,
      NULL,
      NULL,
      1.922807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0.060875,
      0,
      0,
      NULL,
      1.998554,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709012,
      1,
      NULL,
      NULL,
      NULL,
      8.613203,
      0,
      1.150879,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.088840,
      0,
      2.780420,
      3.043274,
      NULL,
      1,
      0.792767,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.996082,
      0,
      0,
      0.944745,
      NULL,
      1,
      2,
      3,
      1.273346,
      1,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.275471,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.544367,
      2,
      1.619692,
      NULL,
      1.994202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372261,
      NULL,
      1.759599,
      NULL,
      NULL,
      1.119456,
      NULL,
      NULL,
      NULL,
      0.258203,
      1.824738,
      1.077504,
      NULL,
      0,
      0.564642,
      1.222770,
      1,
      1.759916,
      NULL,
      0.084763,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.815565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.632536,
      NULL,
      NULL,
      0.184351,
      NULL,
      NULL,
      0.585747,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.996762,
      NULL,
      1.723981,
      0.161415,
      3.169403,
      NULL,
      NULL,
      3.553726,
      NULL,
      1.451376,
      2.111056,
      1.670243,
      1.125384,
      NULL,
      NULL,
      2.638813,
      2.646769,
      NULL,
      0.700357,
      0.344009,
      2.838820,
      0.679251,
      1.963228,
      3.679528,
      0.965251,
      3,
      2,
      0.019723,
      NULL,
      2,
      0.011014,
      6.696741,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      0,
      0,
      0.647352,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.288003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.625836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409494,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      3.501472,
      NULL,
      3.906604,
      1,
      0,
      NULL,
      2,
      2.994057,
      0,
      NULL,
      5,
      NULL,
      29,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      1.211391,
      1.779258,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.483564,
      NULL,
      NULL,
      1.129090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.625300,
      NULL,
      NULL,
      NULL,
      1.370107,
      0.572022,
      0,
      NULL,
      2,
      3,
      3.774257,
      NULL,
      2.136312,
      3.855207,
      1,
      NULL,
      2,
      1,
      3.414252,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.074648,
      0.502710,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      15,
      0.272823,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.317714,
      6,
      1,
      3,
      1.933241,
      0.119686,
      1.397076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761406,
      NULL,
      0,
      1,
      5,
      NULL,
      0,
      1.542066,
      0.729712,
      NULL,
      0,
      1,
      1.529400,
      0.718515,
      0.705271,
      1.710156,
      1,
      NULL,
      0,
      1,
      1.177085,
      0,
      1.077881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.955350,
      2,
      2.207448,
      2.948278,
      3,
      4.096086,
      2,
      NULL,
      1,
      1,
      3.737073,
      0.673803,
      NULL,
      1.371276,
      3,
      0,
      NULL,
      2,
      0,
      1.138232,
      1.809774,
      NULL,
      1,
      2,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1.712222,
      0,
      0,
      NULL,
      0.527934,
      1.040080,
      1.723523,
      0,
      0.406834,
      0.302837,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.674637,
      NULL,
      0.662570,
      NULL,
      1,
      NULL,
      7,
      1.480129,
      NULL,
      NULL,
      NULL,
      78.691859,
      3,
      1.391899,
      2,
      '10430',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


