set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '2432030',
      3.259621,
      0.727803,
      4,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 6-1995',
      NULL,
      NULL,
      5,
      1,
      3.070947,
      NULL,
      26.961502,
      2,
      98.023102,
      53,
      NULL,
      NULL,
      ' 6- 0-1983',
      ' 5-11-1984',
      1.654506,
      3,
      1,
      3.323315,
      1,
      NULL,
      0,
      1.028230,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.648227,
      16.817988,
      3,
      NULL,
      NULL,
      2,
      5.835215,
      NULL,
      NULL,
      0,
      1.914501,
      1.210413,
      0,
      1,
      4.309612,
      0.631271,
      NULL,
      NULL,
      2,
      1,
      4,
      1.146152,
      3,
      1,
      0,
      NULL,
      1,
      4,
      2,
      3,
      5,
      0,
      1,
      NULL,
      8,
      0,
      NULL,
      0,
      2,
      1.246918,
      NULL,
      NULL,
      0.592004,
      NULL,
      NULL,
      4,
      1,
      4,
      2,
      1.281567,
      0.236380,
      1.724704,
      0.737909,
      1,
      0,
      NULL,
      0,
      3,
      1,
      0.620224,
      1.854048,
      2,
      3,
      2,
      1,
      1,
      0,
      6,
      1,
      2,
      2.183408,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      4,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      5,
      1,
      1,
      1,
      1,
      1.154173,
      NULL,
      0.945460,
      2,
      1,
      NULL,
      5,
      1,
      4,
      4,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      4,
      3,
      NULL,
      5,
      2,
      1,
      NULL,
      3,
      ' 2- 6-1986',
      NULL,
      ' 8- 4-1990',
      NULL,
      1.137338,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      0,
      1,
      2,
      1.128325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191007,
      0,
      2.388507,
      1.831643,
      0.812934,
      0.455779,
      1.619274,
      NULL,
      NULL,
      NULL,
      1.728844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.838493,
      0,
      NULL,
      NULL,
      2.633352,
      55.827633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516009,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.894243,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0.000098,
      1.145625,
      1,
      NULL,
      2,
      1.616136,
      1.775330,
      7,
      4,
      NULL,
      NULL,
      1.877531,
      3,
      1,
      4,
      1,
      3.862320,
      1.338350,
      29,
      1,
      0,
      NULL,
      7,
      NULL,
      43.070697,
      3,
      2.194168,
      3.147609,
      '20201',
      '',
      '',
      2,
      NULL,
      '',
      '',
      0.935091,
      NULL,
      NULL,
      '',
      NULL,
      9.346491,
      90.085501,
      5.300295,
      3.761935,
      6,
      NULL,
      11.814920,
      NULL,
      2.725210,
      1.409961,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.534950,
      1.934816,
      0.809974,
      1,
      NULL,
      NULL,
      0,
      0.602818,
      0,
      2.423734,
      0,
      3,
      0.458200,
      1,
      1.249274,
      0.540466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.605849,
      NULL,
      NULL,
      0.144971,
      NULL,
      NULL,
      8.088414,
      0.360648,
      NULL,
      1,
      1.824006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.652866,
      0.742050,
      1,
      2.063419,
      0,
      1.270954,
      2,
      1.480343,
      NULL,
      NULL,
      0.068881,
      1.708954,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.227908,
      1.427857,
      3.366005,
      0,
      2,
      1.137342,
      NULL,
      NULL,
      0.794246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149954,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.264752,
      1.641256,
      3.270723,
      0,
      NULL,
      NULL,
      0.107608,
      NULL,
      NULL,
      6,
      5.809408,
      2,
      0.465163,
      NULL,
      NULL,
      0,
      NULL,
      1.519501,
      5.068663,
      3.899635,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589835,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.943312,
      NULL,
      NULL,
      1.869157,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.743255,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.791862,
      2.311882,
      3.749574,
      6,
      1,
      1,
      0,
      NULL,
      NULL,
      0.864788,
      3,
      NULL,
      0.930059,
      3,
      0,
      1.261752,
      0.487657,
      1,
      7,
      1,
      NULL,
      2,
      NULL,
      1.972979,
      NULL,
      NULL,
      0.783027,
      0.594631,
      2.618952,
      3,
      0,
      2,
      2,
      7,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.466693,
      0.640292,
      1.952519,
      0.824700,
      0,
      3,
      NULL,
      NULL,
      0.107835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.941111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.046976,
      NULL,
      NULL,
      2.107501,
      NULL,
      NULL,
      NULL,
      1.729877,
      1.995069,
      1,
      0.642739,
      3,
      1.308841,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      6,
      NULL,
      38,
      4.746001,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0.513361,
      1,
      0.955722,
      1,
      NULL,
      0,
      1,
      3,
      0.743046,
      1,
      0,
      0,
      0,
      2.786852,
      NULL,
      0.016954,
      NULL,
      3.012955,
      NULL,
      0.843625,
      NULL,
      1.316420,
      NULL,
      0,
      NULL,
      0.709830,
      NULL,
      0.298391,
      27.978184,
      10.615967,
      1,
      NULL,
      NULL,
      NULL,
      1.264015,
      NULL,
      1.798337,
      NULL,
      1,
      NULL,
      0.453570,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.888934,
      NULL,
      0.707905,
      NULL,
      1.897271,
      NULL,
      NULL,
      NULL,
      0.654304,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.223089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920431,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352535,
      NULL,
      NULL,
      1.417319,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337905,
      NULL,
      0.662990,
      NULL,
      1.502397,
      1,
      0.307447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.894768,
      NULL,
      7.040605,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      23,
      19.966041,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.803216,
      1.275568,
      NULL,
      1,
      0,
      1,
      3,
      1.866656,
      0.007732,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.276272,
      NULL,
      NULL,
      0.074523,
      NULL,
      NULL,
      1.531931,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.674788,
      1.937448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.447587,
      NULL,
      1.541695,
      NULL,
      1,
      5,
      0,
      1.579916,
      NULL,
      NULL,
      41.513982,
      10,
      4,
      1,
      3,
      NULL,
      '43020',
      '33132',
      1.337092,
      '0303',
      '',
      '',
      0.224055,
      NULL,
      '',
      '');
commit;
end;
/


