set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '3203311',
      1,
      0,
      2,
      NULL,
      '4022',
      1.334121,
      1.824978,
      NULL,
      NULL,
      ' 3- 0-1993',
      29.169131,
      NULL,
      0,
      3,
      NULL,
      ' 2-23-1974',
      40,
      3,
      141.099111,
      95.737413,
      0,
      ' 2-19-2003',
      ' 4-28-1989',
      NULL,
      NULL,
      0.575468,
      0.519798,
      NULL,
      0.574084,
      NULL,
      3,
      1.013436,
      NULL,
      1.028223,
      1,
      14.895164,
      4.647611,
      22,
      1,
      2,
      2.496091,
      2,
      0,
      6.681830,
      1.345126,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0.858980,
      1,
      3,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      6.105629,
      1,
      0,
      0,
      0,
      0.052975,
      NULL,
      NULL,
      1.886066,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      1,
      1,
      0.496240,
      0,
      NULL,
      0,
      1,
      0.797481,
      NULL,
      1.159154,
      NULL,
      0,
      0,
      1,
      3,
      5,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      4,
      NULL,
      NULL,
      ' 9-17-1980',
      8,
      '11- 6-1987',
      8.925677,
      2,
      0,
      1,
      1,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      1.188924,
      0,
      1,
      0,
      3,
      NULL,
      1,
      3.360111,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.736544,
      3,
      7.563257,
      3,
      3,
      2.351214,
      0,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      11.557993,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.588275,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      0.856364,
      1,
      0.127044,
      3.580847,
      1.801121,
      NULL,
      NULL,
      0,
      1,
      0,
      1.434273,
      1,
      1,
      1.396003,
      0.564912,
      0,
      1,
      NULL,
      2.459312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.497594,
      NULL,
      2,
      19,
      NULL,
      2,
      1,
      3,
      '24040',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      26,
      19.478317,
      35,
      0.396354,
      NULL,
      0.179544,
      1.242203,
      5,
      1,
      NULL,
      NULL,
      1.429742,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.154867,
      NULL,
      NULL,
      1.419464,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.456961,
      NULL,
      NULL,
      0.806384,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045103,
      NULL,
      NULL,
      0.014778,
      NULL,
      NULL,
      0.286245,
      NULL,
      NULL,
      1.253440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.358743,
      NULL,
      NULL,
      1.366628,
      NULL,
      NULL,
      1.530760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709474,
      NULL,
      NULL,
      1.388570,
      NULL,
      NULL,
      0.880139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.204065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.918269,
      0.154290,
      0,
      NULL,
      NULL,
      4.953710,
      4.871143,
      0,
      NULL,
      NULL,
      0.341983,
      0,
      NULL,
      NULL,
      1.672788,
      0.168016,
      1.192207,
      NULL,
      1.988242,
      2.175830,
      2,
      NULL,
      NULL,
      1,
      4.431111,
      NULL,
      3.302611,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.767590,
      0,
      3.005828,
      0.961721,
      3.407244,
      NULL,
      NULL,
      2,
      0,
      1.494587,
      NULL,
      NULL,
      1.868569,
      NULL,
      NULL,
      1,
      1.836214,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.672749,
      0.401349,
      NULL,
      1.344734,
      1.669234,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      2.411715,
      14,
      NULL,
      0,
      1.549083,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      149,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.748219,
      1,
      1,
      1.192637,
      1.391730,
      0,
      0,
      1.594445,
      0.738780,
      1.327240,
      NULL,
      1.602273,
      0.770756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      0.561491,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1.111032,
      0.279515,
      1.572672,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.112764,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.475334,
      3,
      NULL,
      0.545566,
      1,
      NULL,
      1.282255,
      1.352110,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.199416,
      NULL,
      2,
      0.701725,
      NULL,
      0,
      NULL,
      0.307120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463884,
      NULL,
      0.197598,
      NULL,
      1,
      NULL,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      60,
      97.702927,
      4,
      NULL,
      0.318727,
      '03011',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.907219,
      '',
      '',
      '');
commit;
end;
/


