set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0203332',
      3,
      0,
      NULL,
      NULL,
      '4320',
      1.186676,
      NULL,
      NULL,
      NULL,
      ' 2-11-1974',
      48.667210,
      NULL,
      2,
      NULL,
      1,
      ' 2-27-1990',
      29,
      3.909745,
      NULL,
      138.229598,
      NULL,
      ' 3- 8-1990',
      ' 2- 8-1998',
      '11-13-1974',
      1.886571,
      3.120103,
      2,
      0,
      0,
      1,
      2,
      0,
      NULL,
      6.330337,
      7,
      7.433177,
      5.291877,
      9.722711,
      NULL,
      3,
      2.297163,
      5,
      NULL,
      0,
      1.562706,
      1,
      1,
      0,
      1,
      0,
      0,
      1.623030,
      NULL,
      2.453505,
      1,
      4,
      4,
      4,
      3.091799,
      NULL,
      0,
      5,
      NULL,
      0,
      0,
      3,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1.914670,
      1,
      1,
      1,
      1,
      0.855847,
      NULL,
      0.119674,
      NULL,
      0,
      1,
      1,
      2,
      1,
      5,
      0,
      5,
      0,
      0,
      1,
      1,
      0,
      NULL,
      5,
      NULL,
      5,
      2,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      0.117592,
      1.102632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      44,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.536996,
      2.020513,
      0,
      NULL,
      2.007616,
      0.384331,
      0.255382,
      4.547010,
      1,
      1.886252,
      NULL,
      3.084997,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.139557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.734324,
      NULL,
      NULL,
      1.957707,
      1.820374,
      1,
      15.196392,
      2.859521,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      3.990802,
      NULL,
      1,
      0,
      1.779880,
      NULL,
      0,
      0.583527,
      1,
      1.989264,
      0,
      NULL,
      0.298158,
      1.702007,
      1,
      0,
      2.372552,
      0.420120,
      1.398309,
      2.942171,
      8.313415,
      1,
      NULL,
      0,
      1,
      5.870371,
      1.648924,
      4.085940,
      2,
      NULL,
      1.128689,
      5.394248,
      1,
      3.606095,
      NULL,
      12,
      NULL,
      1.341219,
      3,
      1.110999,
      2.311557,
      '31144',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      16,
      20,
      NULL,
      6,
      3,
      2,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0.822411,
      1,
      1.485110,
      1.898308,
      NULL,
      NULL,
      1.617563,
      NULL,
      NULL,
      1.059500,
      NULL,
      NULL,
      NULL,
      2.497865,
      3,
      0.934784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.842568,
      NULL,
      NULL,
      1.071613,
      NULL,
      NULL,
      6,
      2,
      2.364365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161634,
      0.186454,
      1.191381,
      2.436982,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.482442,
      NULL,
      1.219011,
      3.869907,
      1,
      NULL,
      0.103964,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.957074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.230755,
      2.312115,
      5.631308,
      3.346076,
      0,
      4.530290,
      NULL,
      NULL,
      NULL,
      1.239376,
      NULL,
      NULL,
      1,
      2.509175,
      1,
      NULL,
      1,
      0.104818,
      6,
      4.160731,
      1.499714,
      2.596911,
      3.984209,
      2.808892,
      0,
      NULL,
      NULL,
      1.182308,
      0.052621,
      1,
      1.136594,
      3,
      2,
      8.643705,
      1,
      5,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3.626710,
      NULL,
      3.127694,
      1,
      1.462925,
      NULL,
      NULL,
      7,
      0,
      NULL,
      50,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.558163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.534099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.959155,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.412962,
      1,
      NULL,
      0.054035,
      NULL,
      NULL,
      1.498102,
      0.290280,
      NULL,
      9,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      1.588301,
      NULL,
      3,
      9,
      NULL,
      0,
      3.007626,
      NULL,
      NULL,
      NULL,
      NULL,
      3.197408,
      NULL,
      NULL,
      NULL,
      3.207589,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.899287,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.602908,
      1,
      3.341576,
      NULL,
      1.926478,
      NULL,
      NULL,
      NULL,
      1.808124,
      NULL,
      NULL,
      NULL,
      3.086228,
      NULL,
      0.722314,
      NULL,
      0,
      NULL,
      3.865365,
      NULL,
      1,
      0.632817,
      NULL,
      NULL,
      NULL,
      1.858462,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.794537,
      2,
      NULL,
      NULL,
      1,
      2.949986,
      NULL,
      1,
      1.641355,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      9,
      0.525702,
      5,
      NULL,
      0.941912,
      NULL,
      NULL,
      NULL,
      2.194193,
      6,
      NULL,
      2.752820,
      15,
      NULL,
      1.959012,
      NULL,
      NULL,
      3.546669,
      13,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001455,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.212438,
      1.070491,
      1.462550,
      1.134298,
      0,
      0,
      0,
      0.744667,
      0.980968,
      NULL,
      0.206036,
      0.064501,
      0,
      0.936893,
      1.593172,
      1,
      0.232670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      3,
      2.170654,
      1.047369,
      0,
      7.668138,
      0,
      3.037202,
      3.422206,
      0,
      NULL,
      0.369440,
      0.005540,
      1.273117,
      1.288782,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.447004,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923114,
      0,
      1.629353,
      1,
      0.607887,
      1.044235,
      NULL,
      0,
      NULL,
      0.305549,
      0,
      0.762042,
      0.015346,
      0.796550,
      3.137391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835223,
      1,
      1,
      1.182044,
      0.868982,
      1,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      58.287848,
      125,
      1,
      1.974001,
      0,
      '11341',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


