set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4030344',
      3,
      0.597296,
      3,
      3,
      '1002',
      NULL,
      0.274554,
      NULL,
      NULL,
      ' 2-10-1998',
      51.898112,
      NULL,
      0,
      3,
      0,
      ' 3-15-1987',
      14,
      NULL,
      285.146331,
      90,
      3,
      ' 6-16-1987',
      ' 3-22-1979',
      ' 2-12-1988',
      0,
      3,
      3.378806,
      NULL,
      1.277600,
      2,
      3,
      1.228304,
      1.359175,
      1.666054,
      NULL,
      3,
      4.637566,
      17,
      25.912802,
      0,
      NULL,
      3,
      2,
      6.021219,
      1,
      1,
      1,
      1.845021,
      1,
      0.754115,
      0,
      0,
      0,
      1.178827,
      0.831360,
      2,
      NULL,
      4,
      2.281097,
      2,
      1,
      3,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      6,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.330834,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0.497731,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.740965,
      4,
      0,
      0,
      4,
      1,
      0,
      3,
      5,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      2,
      5,
      0,
      1,
      0,
      5,
      NULL,
      4,
      1,
      1,
      NULL,
      4.162910,
      0.120822,
      ' 9- 5-1997',
      10,
      ' 2-24-1976',
      17.252852,
      0.228159,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.776747,
      2,
      0,
      3,
      1,
      1.117437,
      0,
      NULL,
      1.706401,
      NULL,
      0.069021,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.141440,
      8,
      NULL,
      NULL,
      2.050169,
      0.954523,
      NULL,
      NULL,
      NULL,
      0.426856,
      5.991605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896486,
      1.443130,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3.804405,
      1.150066,
      0.168207,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      3,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      3,
      0.746392,
      3.834896,
      3,
      1.460615,
      1,
      0,
      0,
      1.677711,
      0.290406,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.337459,
      NULL,
      1.192003,
      NULL,
      7,
      NULL,
      1,
      11.087662,
      1.950609,
      4,
      NULL,
      2,
      3,
      3.058057,
      2,
      4.903082,
      2,
      NULL,
      NULL,
      NULL,
      27,
      12,
      0,
      1,
      2,
      '11222',
      '',
      '',
      0,
      '',
      '',
      '',
      1.338611,
      '',
      '',
      NULL,
      3.592905,
      8.070972,
      48.558430,
      34,
      1,
      32,
      0,
      NULL,
      4,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.491038,
      1.485040,
      3.611475,
      3.447211,
      1,
      1,
      1.163333,
      NULL,
      NULL,
      0.790121,
      NULL,
      NULL,
      3,
      0.610962,
      0.338201,
      1,
      NULL,
      NULL,
      1.971447,
      NULL,
      NULL,
      0.915171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.943990,
      NULL,
      NULL,
      1,
      3.339870,
      0.347135,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1.003593,
      2,
      0.554962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.466008,
      NULL,
      NULL,
      1.872266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.227601,
      NULL,
      NULL,
      1.055830,
      NULL,
      NULL,
      0.259787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.682986,
      3.435673,
      NULL,
      NULL,
      1,
      0,
      1.067224,
      NULL,
      NULL,
      5.201453,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.843997,
      NULL,
      NULL,
      1.422538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.592205,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.726884,
      NULL,
      NULL,
      4,
      5,
      NULL,
      2.822077,
      1,
      3.032686,
      1,
      NULL,
      NULL,
      NULL,
      1.522798,
      0,
      0,
      NULL,
      2.848909,
      2,
      NULL,
      2.647218,
      NULL,
      2.375194,
      7.272585,
      2.884094,
      3.479276,
      NULL,
      1.484346,
      NULL,
      NULL,
      1,
      2,
      0,
      1.494468,
      3,
      3,
      0,
      10.554796,
      7.259630,
      7,
      6.503200,
      4,
      2.428762,
      2,
      3,
      2,
      0.889508,
      2,
      0.837126,
      1,
      3.434253,
      NULL,
      7.827384,
      3.060735,
      NULL,
      6.794240,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.017262,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.810381,
      1,
      NULL,
      2,
      0.697434,
      NULL,
      2.194355,
      0.175233,
      NULL,
      2.496329,
      1,
      NULL,
      3.370784,
      0.428520,
      NULL,
      2,
      0.360300,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.991551,
      0.251855,
      3,
      0.297790,
      1,
      1.603630,
      8.410518,
      NULL,
      3.241061,
      1,
      9.449165,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.956749,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.082661,
      NULL,
      0.496812,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      3.688151,
      1,
      1.788862,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.362165,
      NULL,
      0.932011,
      NULL,
      1.820254,
      0,
      0,
      NULL,
      NULL,
      0.859332,
      3,
      NULL,
      9.514979,
      NULL,
      4.188381,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.280969,
      7.771278,
      3,
      1.825545,
      14,
      4,
      NULL,
      NULL,
      NULL,
      1.500622,
      4,
      2,
      1,
      9.293934,
      0.129747,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.490029,
      119.696709,
      NULL,
      0.257230,
      0.294105,
      0.750444,
      0.439559,
      1.335329,
      0.930552,
      NULL,
      0.467568,
      1,
      1.006224,
      0,
      0,
      NULL,
      1.270635,
      NULL,
      1.747257,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.170153,
      3.952410,
      2.512474,
      2.108332,
      3,
      8.938748,
      1,
      NULL,
      3.480256,
      1,
      1.986160,
      0.383531,
      1.153704,
      0,
      0.705029,
      0.940940,
      0,
      NULL,
      1.561180,
      1,
      NULL,
      1.113002,
      NULL,
      NULL,
      3.338581,
      0.407776,
      NULL,
      1.220453,
      NULL,
      0.555074,
      1,
      0,
      0.562883,
      1,
      0.214102,
      0,
      0.010066,
      1.245698,
      1.331094,
      1.354525,
      2,
      1,
      3.231239,
      3.648685,
      1.472857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.233378,
      0.436619,
      4,
      3,
      NULL,
      0.372411,
      NULL,
      NULL,
      121,
      17.429348,
      0,
      1,
      3.713510,
      '10204',
      '00224',
      '',
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


