set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '3430204',
      0.365251,
      NULL,
      3,
      1,
      '2410',
      0,
      0.302931,
      NULL,
      NULL,
      ' 0-13-1986',
      57,
      NULL,
      4,
      1.594849,
      0,
      '10- 7-2003',
      1,
      3.733235,
      88.343238,
      133,
      NULL,
      ' 1-23-1977',
      NULL,
      NULL,
      2.855453,
      2,
      1,
      0,
      0,
      NULL,
      5,
      NULL,
      1.708849,
      3.518493,
      4,
      7,
      NULL,
      NULL,
      5,
      4,
      17,
      NULL,
      1,
      6,
      0,
      1,
      NULL,
      1.498504,
      1.799135,
      1,
      1,
      0.933901,
      0,
      1,
      0,
      NULL,
      3,
      1,
      1.744904,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      9.108548,
      0,
      1,
      1,
      1,
      1.929531,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.917102,
      1.730544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.963341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      4,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      2,
      5,
      0,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      ' 1-26-1997',
      0.644884,
      '11- 4-1978',
      NULL,
      3.137645,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.364562,
      NULL,
      NULL,
      0,
      2.267212,
      0.981750,
      NULL,
      NULL,
      NULL,
      NULL,
      4.144624,
      1.926965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206282,
      NULL,
      1,
      2.549634,
      1.453888,
      0.506181,
      1,
      1.751396,
      NULL,
      2.480607,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.106897,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.296194,
      3.629093,
      1,
      0.784737,
      1,
      1,
      NULL,
      1.846553,
      1.144707,
      0,
      NULL,
      1,
      1,
      0,
      1,
      3,
      1.739667,
      3,
      NULL,
      9,
      0.282028,
      7,
      1,
      NULL,
      7.104552,
      5.250343,
      3.388427,
      6.559573,
      1.203430,
      1.762802,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      54,
      NULL,
      NULL,
      5,
      1,
      '04041',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.604936,
      '',
      NULL,
      '',
      2,
      32,
      1,
      6.534551,
      3.535369,
      33.210518,
      1.480909,
      0,
      NULL,
      1.822848,
      2.914530,
      1.035948,
      1.891150,
      NULL,
      NULL,
      3.871364,
      3.977261,
      0.654723,
      3,
      0.083065,
      NULL,
      1,
      NULL,
      NULL,
      0.092504,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701753,
      NULL,
      NULL,
      5.960519,
      2,
      1,
      1,
      0,
      0.442422,
      2,
      1.935501,
      NULL,
      3,
      NULL,
      0,
      1.188330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.572800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1.608617,
      1,
      NULL,
      NULL,
      5.742121,
      3.312538,
      1.639131,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.814658,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.908877,
      NULL,
      NULL,
      1.832238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.545443,
      NULL,
      NULL,
      1.382327,
      0.856046,
      3.631824,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      0.939121,
      4,
      1.890483,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.835389,
      3.708859,
      2.929812,
      1.816537,
      8.951439,
      1.018667,
      NULL,
      2.117074,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      0.349609,
      NULL,
      0,
      10,
      10.896299,
      0,
      1.364669,
      7,
      0,
      1.835147,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      2.554670,
      NULL,
      5.410775,
      3.867915,
      NULL,
      16,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051761,
      NULL,
      NULL,
      0.578806,
      NULL,
      NULL,
      0.043760,
      NULL,
      NULL,
      0,
      0.583832,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.220359,
      NULL,
      2.202882,
      0.400496,
      NULL,
      1.218416,
      0,
      NULL,
      1.464751,
      1.868948,
      NULL,
      3.149280,
      1,
      2.695495,
      2.160595,
      3,
      0.583073,
      0,
      2,
      0.955468,
      NULL,
      0,
      0.981801,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.246702,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.689367,
      NULL,
      1.346131,
      1.808398,
      1.658888,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.905865,
      NULL,
      1.015709,
      NULL,
      2,
      NULL,
      3.711456,
      NULL,
      0.551015,
      NULL,
      0.594359,
      1.359502,
      0.131368,
      NULL,
      0.631930,
      1,
      2,
      NULL,
      0,
      1,
      3.630069,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.746173,
      1,
      2.668693,
      NULL,
      1.820709,
      NULL,
      0.969780,
      NULL,
      3,
      3.351931,
      5,
      2,
      0.089454,
      0,
      3,
      1,
      51.702597,
      10,
      0.304253,
      NULL,
      NULL,
      1,
      NULL,
      10,
      NULL,
      10,
      4.821829,
      0.856005,
      NULL,
      NULL,
      0.464111,
      13,
      NULL,
      60.576164,
      0.566601,
      0,
      0.691780,
      1.973286,
      1,
      0.879276,
      1,
      1.148014,
      0.671846,
      NULL,
      NULL,
      0.064152,
      1.789108,
      1.355172,
      0,
      0.870547,
      1.952931,
      1.177870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      8.111464,
      NULL,
      NULL,
      0,
      3,
      8,
      3.738255,
      2,
      1,
      0.641975,
      1,
      1,
      1,
      0.552505,
      1,
      0.873651,
      1.828775,
      1,
      0.802459,
      NULL,
      0,
      NULL,
      0.377538,
      NULL,
      2.430102,
      NULL,
      NULL,
      1.846431,
      NULL,
      1.140710,
      1,
      0.083644,
      0,
      NULL,
      0.613906,
      1,
      0,
      1,
      1,
      0.364021,
      1,
      1,
      1,
      NULL,
      0.572211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.153128,
      1,
      0,
      1,
      1,
      NULL,
      5,
      7,
      0,
      NULL,
      NULL,
      6.656648,
      149.847342,
      5,
      NULL,
      NULL,
      NULL,
      '43331',
      '',
      1.494988,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


