set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0114098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      9.556698,
      1,
      2,
      4,
      0,
      0.379115,
      0.361838,
      NULL,
      NULL,
      '22122120',
      47.347982,
      NULL,
      '4402223',
      NULL,
      1,
      3,
      0,
      '1113',
      NULL,
      1,
      NULL,
      NULL,
      ' 5-22-2000',
      48,
      43.281231,
      NULL,
      2.779843,
      3,
      ' 0- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8-26-1996',
      ' 9-22-1988',
      NULL,
      3,
      1,
      NULL,
      2,
      0.699041,
      NULL,
      3,
      1,
      NULL,
      7.517416,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.741643,
      1,
      NULL,
      0.582797,
      0,
      0,
      1,
      0,
      0,
      5,
      1,
      3,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      3,
      3,
      NULL,
      7,
      3,
      0,
      1,
      0,
      1.352447,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.448325,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.036176,
      2,
      NULL,
      1.525707,
      2,
      0,
      NULL,
      0.817266,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.978916,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      4,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      3,
      1,
      0,
      5,
      1,
      1,
      3,
      1,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      4,
      5,
      4,
      0,
      5,
      0.659912,
      2,
      NULL,
      450,
      ' 6-12-1977',
      112,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0.296636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.038234,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.434024,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524826,
      3,
      1.356655,
      1,
      1.596840,
      NULL,
      1,
      0,
      31.283297,
      1,
      1.238448,
      NULL,
      NULL,
      NULL,
      0,
      2.706534,
      3.717744,
      NULL,
      0,
      1,
      0,
      2,
      0,
      NULL,
      2,
      3,
      1,
      3,
      NULL,
      3,
      1,
      0,
      1.743449,
      6.696909,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338978,
      1.261825,
      0.941396,
      1,
      1.784902,
      1.883208,
      NULL,
      0.014704,
      8.038084,
      NULL,
      8.196727,
      NULL,
      NULL,
      3.151470,
      0,
      2,
      1,
      2.155887,
      2,
      53,
      2,
      3.974191,
      49,
      NULL,
      20,
      25,
      3,
      NULL,
      3.052392,
      '11003',
      '30401',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '1134',
      NULL,
      '',
      3.656119,
      23.284783,
      65.218740,
      NULL,
      2,
      36.749265,
      NULL,
      1.487067,
      2,
      2,
      NULL,
      1.273071,
      0.289103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.806347,
      2.105317,
      NULL,
      3.849962,
      1,
      0.470823,
      0.383372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122861,
      NULL,
      NULL,
      1.459601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.485993,
      0.373379,
      0.090404,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.565716,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.174216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.080126,
      1.828058,
      NULL,
      0.083652,
      2.370139,
      2,
      1.403024,
      2.017432,
      0.614838,
      2.730289,
      1.442075,
      1,
      0,
      1.230234,
      1,
      2,
      0.178828,
      NULL,
      NULL,
      NULL,
      NULL,
      3.622747,
      2,
      1,
      2.830759,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.759049,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.530866,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.485525,
      NULL,
      NULL,
      2.648315,
      NULL,
      0,
      1.156809,
      1,
      1.101434,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.378327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.340585,
      NULL,
      NULL,
      2.336422,
      2,
      2.031747,
      0.860950,
      2.518231,
      7.509221,
      NULL,
      8.703623,
      0,
      0,
      1.076511,
      0,
      2,
      1.238187,
      NULL,
      2.993027,
      2,
      3,
      3,
      1,
      4.982307,
      6.673599,
      6,
      0,
      5,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.325956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555310,
      NULL,
      NULL,
      0.682852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935702,
      NULL,
      NULL,
      1,
      1,
      2.931778,
      0,
      1.579830,
      1.208701,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.228910,
      NULL,
      NULL,
      NULL,
      3.871252,
      NULL,
      NULL,
      NULL,
      0.053340,
      6.212738,
      1,
      3,
      0.658706,
      1.786115,
      NULL,
      0.428853,
      1.367619,
      0.809035,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554758,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      82.302325,
      13.739228,
      1,
      1,
      0.714306,
      0,
      0.076883,
      0.978265,
      1,
      1,
      1,
      1,
      0,
      1.170176,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.044632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.770556,
      NULL,
      0,
      NULL,
      1.945954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489243,
      NULL,
      1.776565,
      NULL,
      1,
      NULL,
      1.042010,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.299488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.051378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158950,
      0.930964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.212494,
      NULL,
      NULL,
      3.530810,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      28,
      NULL,
      0.020807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.819477,
      3,
      2.341317,
      0.635683,
      NULL,
      8.267750,
      0.907064,
      NULL,
      0.078179,
      0,
      1.353333,
      NULL,
      0,
      0.930619,
      NULL,
      1.844162,
      1.730503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.076153,
      NULL,
      1,
      1.259581,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.236216,
      NULL,
      1,
      0,
      NULL,
      1.675439,
      2,
      NULL,
      1.274900,
      NULL,
      NULL,
      0,
      0,
      1.396386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      6,
      0,
      NULL,
      NULL,
      NULL,
      102,
      1,
      5.521527,
      1.326981,
      '10023',
      NULL,
      NULL,
      1.600680,
      NULL,
      '',
      NULL,
      3,
      NULL,
      '3243',
      '');
commit;
end;
/


