set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8011440';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3430340',
      1,
      1,
      3,
      2,
      '0141',
      2.146307,
      NULL,
      NULL,
      NULL,
      ' 1-29-1979',
      30.646851,
      NULL,
      3,
      1.192562,
      1,
      '11-20-2001',
      1,
      3,
      292,
      41.134625,
      NULL,
      '10- 3-1978',
      ' 3-25-1999',
      ' 6-26-1986',
      NULL,
      1,
      2.450160,
      0,
      1,
      0.656194,
      2,
      0.960008,
      0,
      184,
      NULL,
      9,
      NULL,
      0.518112,
      NULL,
      NULL,
      17.133140,
      1,
      NULL,
      4,
      NULL,
      1,
      0,
      1.054581,
      NULL,
      NULL,
      1.367744,
      1.568587,
      NULL,
      NULL,
      126,
      8,
      4,
      NULL,
      2.578900,
      1,
      NULL,
      1,
      5,
      0,
      1,
      2,
      0,
      1,
      0,
      1,
      4,
      7,
      3,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      7.960733,
      3,
      1.962023,
      0,
      2.196923,
      2,
      0.054926,
      3.779437,
      2.495546,
      0,
      1,
      NULL,
      0,
      3.860036,
      NULL,
      0.379372,
      0,
      0,
      0,
      0,
      11.847266,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      0,
      NULL,
      3,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      4.673755,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      5,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      0,
      1,
      5,
      4,
      5,
      2,
      4,
      2,
      NULL,
      1,
      NULL,
      3,
      2,
      0,
      2,
      3,
      11,
      1,
      '10-23-1993',
      1112,
      ' 1-10-1985',
      351.288615,
      2,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.543609,
      1,
      NULL,
      1,
      0.381655,
      1,
      3.594468,
      1.981024,
      1,
      0,
      NULL,
      0.730546,
      NULL,
      0.955509,
      3.183357,
      1.460376,
      4.479563,
      7.095203,
      0.312987,
      3,
      0.676042,
      NULL,
      NULL,
      NULL,
      1.190185,
      2.942614,
      0.254295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.667880,
      NULL,
      0,
      3,
      1.238229,
      0.412181,
      1,
      NULL,
      933.012299,
      0,
      0.541006,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      2.420049,
      3.481907,
      1,
      4.610578,
      NULL,
      0.837814,
      3.826128,
      1.071557,
      1,
      1,
      1.382851,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1.665623,
      11.788533,
      1,
      NULL,
      4.955010,
      NULL,
      NULL,
      4,
      1,
      5.033414,
      3,
      3.826512,
      2,
      31,
      1,
      2,
      NULL,
      21,
      20,
      NULL,
      2,
      0,
      3.624573,
      '23332',
      NULL,
      '',
      1.038260,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.060664,
      12.676598,
      494,
      NULL,
      3.930403,
      21,
      43,
      155,
      2,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.374554,
      1,
      NULL,
      NULL,
      0.540783,
      1.163265,
      1,
      2.251956,
      0,
      3,
      0.924451,
      NULL,
      NULL,
      0,
      0,
      2,
      1.745760,
      1.841196,
      2,
      1.854096,
      NULL,
      NULL,
      0,
      NULL,
      2,
      5.807175,
      NULL,
      8.094392,
      1,
      0.807327,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.469834,
      NULL,
      1.585389,
      3.555839,
      0.727413,
      NULL,
      2.861815,
      1.201802,
      0.353219,
      0,
      1.753088,
      0.952326,
      2,
      2,
      3,
      0,
      3,
      NULL,
      0.343629,
      2.711229,
      1,
      3.278681,
      2,
      3,
      2.336035,
      2.619248,
      1,
      1.156451,
      0.625963,
      NULL,
      NULL,
      NULL,
      1,
      1.751178,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.767784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791375,
      3.710192,
      1.573741,
      NULL,
      NULL,
      3.735387,
      2,
      7.924102,
      1,
      NULL,
      NULL,
      1.138921,
      NULL,
      NULL,
      1.683761,
      NULL,
      NULL,
      1.810225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.688208,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535980,
      2.443671,
      1,
      0.187919,
      1,
      5.697743,
      2.125768,
      7,
      0.551331,
      3,
      7,
      0,
      4,
      1,
      1,
      NULL,
      3.577194,
      0,
      0,
      2.013985,
      2.024059,
      0,
      7,
      4,
      2.266071,
      2,
      3,
      3,
      0,
      2,
      1.292516,
      NULL,
      2,
      NULL,
      1.713851,
      1,
      NULL,
      2,
      NULL,
      2.350932,
      0.804207,
      2,
      5.437545,
      1,
      NULL,
      0,
      1,
      1.981258,
      0.745622,
      NULL,
      NULL,
      0.802837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.593212,
      NULL,
      NULL,
      1.431561,
      NULL,
      NULL,
      1.248418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.076680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.810512,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      2,
      0.793518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.502649,
      NULL,
      NULL,
      NULL,
      3.980655,
      NULL,
      NULL,
      NULL,
      1.814432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861751,
      NULL,
      NULL,
      NULL,
      0.915156,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.292606,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      5.875230,
      9,
      NULL,
      0,
      NULL,
      413,
      1.170454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      9.348703,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952754,
      44,
      1.253673,
      274.184945,
      7,
      1,
      NULL,
      0,
      NULL,
      1.979685,
      0.913934,
      0.213121,
      3,
      1.339809,
      3.359749,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1.665142,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.712995,
      NULL,
      1.071159,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.855097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.780177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.060487,
      0,
      1.625652,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.496918,
      NULL,
      0.534477,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.947242,
      0,
      0.817854,
      NULL,
      1,
      3,
      2.444250,
      0,
      NULL,
      0,
      NULL,
      0.328714,
      1.019688,
      NULL,
      2.545316,
      1.069056,
      NULL,
      1.368062,
      0.149712,
      NULL,
      2,
      3.777253,
      NULL,
      1.617894,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.026527,
      0,
      NULL,
      1,
      0,
      NULL,
      2.122824,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.421340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.551139,
      NULL,
      0,
      NULL,
      4,
      0,
      4,
      NULL,
      2.741829,
      NULL,
      8.403337,
      10,
      0,
      0.313632,
      NULL,
      '24314',
      '',
      '',
      0.570561,
      NULL,
      '',
      '',
      0.113062,
      NULL,
      '',
      '');
commit;
end;
/


